/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.rationals;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class LinearExpression<T>
implements Iterable<Map.Entry<T, Rational>> {
    private final ImmutableMap<T, Rational> data;
    private int hashCache = 0;

    private LinearExpression(Map<T, Rational> data) {
        this.data = ImmutableMap.copyOf(data);
    }

    public static <T> LinearExpression<T> empty() {
        return new LinearExpression<T>(ImmutableMap.of());
    }

    public static <T> LinearExpression<T> pair(T var, Rational coeff) {
        if (coeff.equals(Rational.ZERO)) {
            return LinearExpression.empty();
        }
        return new LinearExpression<T>(ImmutableMap.of(var, (Object)coeff));
    }

    public static <T> LinearExpression<T> ofVariable(T var) {
        return LinearExpression.pair(var, Rational.ONE);
    }

    public LinearExpression<T> add(LinearExpression<T> other) {
        HashMap<T, Rational> newData = new HashMap<T, Rational>(this.data);
        for (Map.Entry e : other.data.entrySet()) {
            Object var = e.getKey();
            Rational oldValue = (Rational)newData.get(var);
            Rational newValue = (Rational)e.getValue();
            if (oldValue != null) {
                newValue = newValue.plus(oldValue);
            }
            if (newValue.equals(Rational.ZERO)) {
                newData.remove(var);
                continue;
            }
            newData.put(var, newValue);
        }
        return new LinearExpression<T>(newData);
    }

    public LinearExpression<T> sub(LinearExpression<T> other) {
        return this.add(other.negate());
    }

    public LinearExpression<T> multByConst(Rational constant) {
        if (constant.equals(Rational.ZERO)) {
            return LinearExpression.empty();
        }
        HashMap newData = new HashMap(this.data.size());
        for (Map.Entry e : this.data.entrySet()) {
            newData.put(e.getKey(), ((Rational)e.getValue()).times(constant));
        }
        return new LinearExpression(newData);
    }

    public LinearExpression<T> negate() {
        return this.multByConst(Rational.NEG_ONE);
    }

    public Rational getCoeff(T variable) {
        Rational out = (Rational)this.data.get(variable);
        if (out == null) {
            return Rational.ZERO;
        }
        return out;
    }

    public int size() {
        return this.data.size();
    }

    public boolean isIntegral() {
        for (Map.Entry<T, Rational> e : this) {
            if (e.getValue().isIntegral()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Map.Entry<T, Rational>> iterator() {
        return this.data.entrySet().iterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<T, Rational> monomial : this) {
            Rational coeff = monomial.getValue();
            if (b.length() != 0 && coeff.signum() >= 0) {
                b.append(" + ");
            }
            T var = monomial.getKey();
            if (coeff == Rational.ONE) {
                b.append(var);
                continue;
            }
            if (coeff == Rational.NEG_ONE) {
                b.append(" - ").append(var);
                continue;
            }
            b.append(coeff.toString()).append(var);
        }
        return b.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        LinearExpression other = (LinearExpression)object;
        return this.data.equals(other.data);
    }

    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = this.data.hashCode();
        }
        return this.hashCache;
    }
}

