/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.rationals;

import com.google.common.base.Objects;
import java.math.BigInteger;

public class Rational
implements Comparable<Rational> {
    private static final BigInteger b_zero = BigInteger.ZERO;
    private static final BigInteger b_one = BigInteger.ONE;
    private static final BigInteger b_m_one = b_one.negate();
    public static final Rational ZERO = new Rational(b_zero, b_one);
    public static final Rational ONE = new Rational(b_one, b_one);
    public static final Rational NEG_ONE = new Rational(b_m_one, b_one);
    private final BigInteger num;
    private final BigInteger den;

    private Rational(BigInteger numerator, BigInteger denominator) {
        this.num = numerator;
        this.den = denominator;
    }

    public static Rational of(BigInteger numerator, BigInteger denominator) {
        int denSignum = denominator.signum();
        if (denSignum == 0) {
            throw new IllegalArgumentException("Infinity is not supported, use ExtendedRational instead");
        }
        if (denSignum == -1) {
            denominator = denominator.negate();
            numerator = numerator.negate();
        }
        BigInteger gcd = numerator.gcd(denominator);
        numerator = numerator.divide(gcd);
        denominator = denominator.divide(gcd);
        return Rational.ofNormalForm(numerator, denominator);
    }

    public static Rational ofLongs(long numerator, long denominator) {
        return Rational.of(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    public static Rational ofLong(long numerator) {
        return Rational.of(BigInteger.valueOf(numerator), b_one);
    }

    public static Rational ofBigInteger(BigInteger numerator) {
        return Rational.of(numerator, b_one);
    }

    public static Rational ofString(String s) throws NumberFormatException {
        int idx = s.indexOf(47);
        if (idx == -1) {
            BigInteger num = new BigInteger(s);
            return Rational.ofBigInteger(num);
        }
        BigInteger num = new BigInteger(s.substring(0, idx));
        BigInteger den = new BigInteger(s.substring(idx + 1, s.length()));
        return Rational.of(num, den);
    }

    private static Rational ofNormalForm(BigInteger num, BigInteger den) {
        if (num.equals(b_zero)) {
            return ZERO;
        }
        if (den.equals(b_one)) {
            if (num.equals(b_one)) {
                return ONE;
            }
            if (num.equals(b_m_one)) {
                return NEG_ONE;
            }
        }
        return new Rational(num, den);
    }

    public Rational times(Rational b) {
        Rational a = this;
        if (a == ZERO || b == ZERO) {
            return ZERO;
        }
        if (a == ONE) {
            return b;
        }
        if (b == ONE) {
            return a;
        }
        Rational c = Rational.of(a.num, b.den);
        Rational d = Rational.of(b.num, a.den);
        return Rational.ofNormalForm(c.num.multiply(d.num), c.den.multiply(d.den));
    }

    public Rational plus(Rational b) {
        Rational a = this;
        if (a == ZERO) {
            return b;
        }
        if (b == ZERO) {
            return a;
        }
        return Rational.of(a.num.multiply(b.den).add(b.num.multiply(a.den)), a.den.multiply(b.den));
    }

    public Rational minus(Rational b) {
        return this.plus(b.negate());
    }

    public Rational divides(Rational b) {
        return this.times(b.reciprocal());
    }

    public Rational reciprocal() throws IllegalArgumentException {
        if (this.num.equals(b_zero)) {
            throw new IllegalArgumentException("Division by zero not supported, use ExtendedRational if you need it");
        }
        return Rational.ofNormalForm(this.den, this.num);
    }

    public Rational negate() {
        return Rational.ofNormalForm(this.num.negate(), this.den);
    }

    public double toDouble() {
        return this.num.doubleValue() / this.den.doubleValue();
    }

    public boolean isIntegral() {
        return this.den.equals(b_one);
    }

    public BigInteger getNum() {
        return this.num;
    }

    public int signum() {
        return this.num.signum();
    }

    public String toString() {
        if (this.den.equals(b_one)) {
            return this.num.toString();
        }
        return this.num + "/" + this.den;
    }

    @Override
    public int compareTo(Rational b) {
        BigInteger lhs = this.num.multiply(b.den);
        BigInteger rhs = this.den.multiply(b.num);
        return lhs.subtract(rhs).signum();
    }

    public boolean equals(Object y) {
        if (this == y) {
            return true;
        }
        if (y == null) {
            return false;
        }
        if (y.getClass() != this.getClass()) {
            return false;
        }
        Rational b = (Rational)y;
        return this.num.equals(b.num) && this.den.equals(b.den);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.num, this.den});
    }

    public static Rational max(Rational a, Rational b) {
        if (a.compareTo(b) >= 0) {
            return a;
        }
        return b;
    }
}

