/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.rationals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.rationals.ExtendedRational;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class TestExtendedRational {
    @Test
    public void testTypes() {
        ExtendedRational x = new ExtendedRational(Rational.ofLongs(23L, 7L));
        Assert.assertEquals((Object)true, (Object)x.isRational());
        x = ExtendedRational.INFTY;
        Assert.assertEquals((Object)false, (Object)x.isRational());
    }

    @Test
    public void testInstantiation() {
        ExtendedRational x = new ExtendedRational(Rational.ofLongs(108L, 96L));
        Assert.assertEquals((Object)"9/8", (Object)x.toString());
    }

    @Test
    public void testAddition() {
        ExtendedRational a = new ExtendedRational(Rational.ofLongs(12L, 8L));
        ExtendedRational b = new ExtendedRational(Rational.ofLongs(-54L, 12L));
        Assert.assertEquals((Object)"-3", (Object)a.plus(b).toString());
        b = ExtendedRational.INFTY;
        Assert.assertEquals((Object)"Infinity", (Object)a.plus(b).toString());
        b = ExtendedRational.NaN;
        Assert.assertEquals((Object)"NaN", (Object)a.plus(b).toString());
        a = ExtendedRational.INFTY;
        b = ExtendedRational.NEG_INFTY;
        Assert.assertEquals((Object)"NaN", (Object)a.plus(b).toString());
        a = ExtendedRational.ofString("2309820938409238490");
        b = ExtendedRational.NEG_INFTY;
        Assert.assertEquals((Object)"-Infinity", (Object)a.plus(b).toString());
    }

    @Test
    public void testSubtraction() {
        ExtendedRational a = ExtendedRational.ofString("5/2");
        ExtendedRational b = ExtendedRational.ofString("3/2");
        Assert.assertEquals((Object)"1", (Object)a.minus(b).toString());
    }

    @Test
    public void testMultiplication() {
        ExtendedRational a = ExtendedRational.ofString("2/4");
        ExtendedRational b = ExtendedRational.ofString("-1/3");
        Assert.assertEquals((Object)ExtendedRational.ofString("-2/12"), (Object)a.times(b));
        a = ExtendedRational.ofString("100/4");
        b = ExtendedRational.ofString("1/100");
        Assert.assertEquals((Object)ExtendedRational.ofString("1/4"), (Object)a.times(b));
        a = ExtendedRational.ofString("100/4");
        b = ExtendedRational.ofString("Infinity");
        Assert.assertEquals((Object)ExtendedRational.ofString("Infinity"), (Object)a.times(b));
    }

    @Test
    public void testDivision() {
        ExtendedRational a = ExtendedRational.ofString("2/4");
        ExtendedRational b = ExtendedRational.ofString("1/4");
        Assert.assertEquals((Object)"2", (Object)a.divides(b).toString());
        a = ExtendedRational.ofString("234234");
        b = ExtendedRational.INFTY;
        Assert.assertEquals((Object)"0", (Object)a.divides(b).toString());
        a = ExtendedRational.ofString("234234");
        b = ExtendedRational.NEG_INFTY;
        Assert.assertEquals((Object)"0", (Object)a.divides(b).toString());
        a = ExtendedRational.ofString("234234");
        b = ExtendedRational.NaN;
        Assert.assertEquals((Object)"NaN", (Object)a.divides(b).toString());
    }

    @Test
    public void testComparison() {
        List<ExtendedRational> unsorted = Arrays.asList(ExtendedRational.NaN, ExtendedRational.NEG_INFTY, ExtendedRational.ofString("-2/4"), ExtendedRational.ofString("1/3"), ExtendedRational.ofString("2/3"), ExtendedRational.INFTY);
        Collections.shuffle(unsorted);
        List<ExtendedRational> sorted = Arrays.asList(ExtendedRational.NEG_INFTY, ExtendedRational.ofString("-2/4"), ExtendedRational.ofString("1/3"), ExtendedRational.ofString("2/3"), ExtendedRational.INFTY, ExtendedRational.NaN);
        Collections.sort(unsorted);
        Assert.assertEquals(sorted, unsorted);
    }

    @Test
    public void testOfString() {
        ExtendedRational a = ExtendedRational.ofString("Infinity");
        Assert.assertEquals((Object)ExtendedRational.INFTY, (Object)a);
        a = ExtendedRational.ofString("-Infinity");
        Assert.assertEquals((Object)ExtendedRational.NEG_INFTY, (Object)a);
        a = ExtendedRational.ofString("NaN");
        Assert.assertEquals((Object)ExtendedRational.NaN, (Object)a);
        a = ExtendedRational.ofString("-2");
        Assert.assertEquals((Object)new ExtendedRational(Rational.ofLong(-2L)), (Object)a);
    }
}

