/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.rationals;

import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.rationals.LinearExpression;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class TestLinearExpression {
    @Test
    public void testInstantiation() {
        LinearExpression<Object> x = LinearExpression.empty();
        Truth.assertThat((Integer)x.size()).isEqualTo(0L);
        x = LinearExpression.pair("x", Rational.ofString("5"));
        Truth.assertThat((Integer)x.size()).isEqualTo(1L);
        Truth.assertThat((Comparable)x.getCoeff("x")).isEqualTo((Object)Rational.ofString("5"));
        x = LinearExpression.ofVariable("y");
        Truth.assertThat((Integer)x.size()).isEqualTo(1L);
        Truth.assertThat((Comparable)x.getCoeff("y")).isEqualTo((Object)Rational.ONE);
        x = LinearExpression.pair("x", Rational.ofString("0"));
        Truth.assertThat((Integer)x.size()).isEqualTo(0L);
    }

    @Test
    public void testAdd() {
        LinearExpression<String> x = LinearExpression.pair("x", Rational.ofString("5"));
        x = x.add(LinearExpression.pair("x", Rational.ofString("8")));
        x = x.add(LinearExpression.pair("y", Rational.ofString("2")));
        x = x.add(LinearExpression.pair("z", Rational.ofString("3")));
        Truth.assertThat((Integer)x.size()).isEqualTo(3L);
        Truth.assertThat((Comparable)x.getCoeff("x")).isEqualTo((Object)Rational.ofString("13"));
        Truth.assertThat((Comparable)x.getCoeff("y")).isEqualTo((Object)Rational.ofString("2"));
        Truth.assertThat((Comparable)x.getCoeff("z")).isEqualTo((Object)Rational.ofString("3"));
        Truth.assertThat((Boolean)x.isIntegral()).isTrue();
    }

    @Test
    public void testSub() {
        LinearExpression<String> x = LinearExpression.pair("x", Rational.ofString("5"));
        x = x.add(LinearExpression.pair("y", Rational.ofString("3")));
        x = x.sub(LinearExpression.pair("x", Rational.ofString("5")));
        x = x.sub(LinearExpression.pair("y", Rational.ofString("2")));
        x = x.sub(LinearExpression.pair("z", Rational.ofString("1")));
        Truth.assertThat((Integer)x.size()).isEqualTo(2L);
        Truth.assertThat((Comparable)x.getCoeff("x")).isEqualTo((Object)Rational.ZERO);
        Truth.assertThat((Comparable)x.getCoeff("y")).isEqualTo((Object)Rational.ONE);
        Truth.assertThat((Comparable)x.getCoeff("z")).isEqualTo((Object)Rational.NEG_ONE);
    }

    @Test
    public void testMultiplication() {
        LinearExpression<String> x = LinearExpression.pair("x", Rational.ofString("5"));
        x = x.multByConst(Rational.ZERO);
        Truth.assertThat((Integer)x.size()).isEqualTo(0L);
        x = LinearExpression.pair("x", Rational.ofString("5"));
        x = x.add(LinearExpression.pair("y", Rational.ofString("3")));
        x = x.multByConst(Rational.ofString("2"));
        Truth.assertThat((Integer)x.size()).isEqualTo(2L);
        Truth.assertThat((Comparable)x.getCoeff("x")).isEqualTo((Object)Rational.ofString("10"));
        Truth.assertThat((Comparable)x.getCoeff("y")).isEqualTo((Object)Rational.ofString("6"));
    }

    @Test
    public void testNegation() {
        LinearExpression<String> x = LinearExpression.pair("x", Rational.ofString("5"));
        x = x.add(LinearExpression.pair("y", Rational.ofString("3")));
        x = x.negate();
        Truth.assertThat((Integer)x.size()).isEqualTo(2L);
        Truth.assertThat((Comparable)x.getCoeff("x")).isEqualTo((Object)Rational.ofString("-5"));
        Truth.assertThat((Comparable)x.getCoeff("y")).isEqualTo((Object)Rational.ofString("-3"));
    }

    @Test
    public void testEquality() {
        LinearExpression<String> x = LinearExpression.pair("x", Rational.ofString("6"));
        LinearExpression<String> y = LinearExpression.pair("x", Rational.ofString("3"));
        y = y.add(LinearExpression.pair("x", Rational.ofString("3")));
        y = y.add(LinearExpression.pair("z", Rational.ofString("3")));
        y = y.sub(LinearExpression.pair("z", Rational.ofString("3")));
        new EqualsTester().addEqualityGroup(new Object[]{x, y});
    }
}

