/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.rationals;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.rationals.Rational;

public class TestRational {
    @Test
    public void testInstantiation() {
        Rational x = Rational.ofLongs(108L, 96L);
        Assert.assertEquals((Object)"9/8", (Object)x.toString());
        x = Rational.ofLong(50L);
        Assert.assertEquals((Object)"50", (Object)x.toString());
        x = Rational.of(BigInteger.ZERO, BigInteger.ONE);
        Assert.assertEquals((Object)"0", (Object)x.toString());
    }

    @Test
    public void testAddition() {
        Rational a = Rational.ofLongs(12L, 8L);
        Rational b = Rational.ofLongs(-54L, 12L);
        Assert.assertEquals((Object)"-3", (Object)a.plus(b).toString());
    }

    @Test
    public void testSubtraction() {
        Rational a = Rational.ofString("5/2");
        Rational b = Rational.ofString("3/2");
        Assert.assertEquals((Object)"1", (Object)a.minus(b).toString());
    }

    @Test
    public void testMultiplication() {
        Rational a = Rational.ofString("2/4");
        Rational b = Rational.ofString("-1/3");
        Assert.assertEquals((Object)Rational.ofString("-2/12"), (Object)a.times(b));
        a = Rational.ofString("100/4");
        b = Rational.ofString("1/100");
        Assert.assertEquals((Object)Rational.ofString("1/4"), (Object)a.times(b));
    }

    @Test
    public void testDivision() {
        Rational a = Rational.ofString("2/4");
        Rational b = Rational.ofString("1/4");
        Assert.assertEquals((Object)"2", (Object)a.divides(b).toString());
    }

    @Test
    public void testComparison() {
        List<Rational> unsorted = Arrays.asList(Rational.ofLongs(-2L, 4L), Rational.ofLongs(1L, 3L), Rational.ofLongs(2L, 3L));
        Collections.shuffle(unsorted);
        List<Rational> sorted = Arrays.asList(Rational.ofLongs(-2L, 4L), Rational.ofLongs(1L, 3L), Rational.ofLongs(2L, 3L));
        Collections.sort(unsorted);
        Assert.assertEquals(sorted, unsorted);
    }

    @Test
    public void testOfString() {
        Rational a = Rational.ofString("6/8");
        Assert.assertEquals((Object)Rational.ofLongs(3L, 4L), (Object)a);
        a = Rational.ofString("-2");
        Assert.assertEquals((Object)Rational.ofLongs(-2L, 1L), (Object)a);
    }

    @Test
    public void testCanonicity() {
        Rational b;
        Rational a = Rational.ofString("6/8");
        Assert.assertTrue((Rational.ZERO == a.plus(b = Rational.ofString("-6/8")) ? 1 : 0) != 0);
        a = Rational.ofString("2");
        b = Rational.ofString("-1");
        Assert.assertTrue((Rational.NEG_ONE == b ? 1 : 0) != 0);
        Assert.assertTrue((Rational.ONE == a.plus(b) ? 1 : 0) != 0);
        a = Rational.ofString("-2");
        b = Rational.ofString("1");
        Assert.assertTrue((Rational.NEG_ONE == a.plus(b) ? 1 : 0) != 0);
    }
}

