/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.reachingdef;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;

public class ReachingDefUtils {
    private static List<CFANode> cfaNodes;

    public static List<CFANode> getAllNodesFromCFA() {
        return cfaNodes;
    }

    public static Pair<Set<String>, Map<FunctionEntryNode, Set<String>>> getAllVariables(CFANode pMainNode) {
        CFAEdge out;
        Vector<String> globalVariables = new Vector<String>();
        Vector<CFANode> nodes = new Vector<CFANode>();
        while (!(pMainNode instanceof FunctionEntryNode)) {
            out = pMainNode.getLeavingEdge(0);
            if (out instanceof CDeclarationEdge && ((CDeclarationEdge)out).getDeclaration() instanceof CVariableDeclaration) {
                globalVariables.add(((CVariableDeclaration)((CDeclarationEdge)out).getDeclaration()).getName());
            }
            nodes.add(pMainNode);
            pMainNode = pMainNode.getLeavingEdge(0).getSuccessor();
        }
        HashMap<FunctionEntryNode, ImmutableSet> result = new HashMap<FunctionEntryNode, ImmutableSet>();
        HashSet<FunctionEntryNode> reachedFunctions = new HashSet<FunctionEntryNode>();
        Stack<FunctionEntryNode> functionsToProcess = new Stack<FunctionEntryNode>();
        Stack<CFANode> currentWaitlist = new Stack<CFANode>();
        HashSet<CFANode> seen = new HashSet<CFANode>();
        Vector<String> localVariables = new Vector<String>();
        reachedFunctions.add((FunctionEntryNode)pMainNode);
        functionsToProcess.add((FunctionEntryNode)pMainNode);
        while (!functionsToProcess.isEmpty()) {
            FunctionEntryNode currentFunction = (FunctionEntryNode)functionsToProcess.pop();
            currentWaitlist.clear();
            currentWaitlist.add(currentFunction);
            seen.clear();
            seen.add(currentFunction);
            localVariables.clear();
            while (!currentWaitlist.isEmpty()) {
                CFANode currentElement = (CFANode)currentWaitlist.pop();
                nodes.add(currentElement);
                for (int i = 0; i < currentElement.getNumLeavingEdges(); ++i) {
                    out = currentElement.getLeavingEdge(i);
                    if (out instanceof FunctionReturnEdge) continue;
                    if (out instanceof FunctionCallEdge) {
                        if (!reachedFunctions.contains(out.getSuccessor())) {
                            functionsToProcess.add((FunctionEntryNode)out.getSuccessor());
                            reachedFunctions.add((FunctionEntryNode)out.getSuccessor());
                        }
                        out = currentElement.getLeavingSummaryEdge();
                    }
                    if (out instanceof CDeclarationEdge && ((CDeclarationEdge)out).getDeclaration() instanceof CVariableDeclaration) {
                        if (((CDeclarationEdge)out).getDeclaration().isGlobal()) {
                            globalVariables.add(((CVariableDeclaration)((CDeclarationEdge)out).getDeclaration()).getName());
                        } else {
                            localVariables.add(((CVariableDeclaration)((CDeclarationEdge)out).getDeclaration()).getName());
                        }
                    }
                    if (seen.contains(out.getSuccessor())) continue;
                    currentWaitlist.add(out.getSuccessor());
                    seen.add(out.getSuccessor());
                }
            }
            result.put(currentFunction, ImmutableSet.copyOf(localVariables));
        }
        cfaNodes = ImmutableList.copyOf(nodes);
        return Pair.of((Object)ImmutableSet.copyOf(globalVariables), result);
    }

    public static class VariableExtractor
    extends DefaultCExpressionVisitor<String, UnsupportedCCodeException> {
        private CFAEdge edgeForExpression;
        private String warning;

        public void resetWarning() {
            this.warning = null;
        }

        public String getWarning() {
            return this.warning;
        }

        public VariableExtractor(CFAEdge pEdgeForExpression) {
            this.edgeForExpression = pEdgeForExpression;
        }

        @Override
        protected String visitDefault(CExpression pExp) {
            return null;
        }

        @Override
        public String visit(CArraySubscriptExpression pIastArraySubscriptExpression) throws UnsupportedCCodeException {
            this.warning = "Analysis may be unsound in case of aliasing.";
            return pIastArraySubscriptExpression.getArrayExpression().accept(this);
        }

        @Override
        public String visit(CCastExpression pIastCastExpression) throws UnsupportedCCodeException {
            return pIastCastExpression.getOperand().accept(this);
        }

        @Override
        public String visit(CComplexCastExpression pIastCastExpression) throws UnsupportedCCodeException {
            return pIastCastExpression.getOperand().accept(this);
        }

        @Override
        public String visit(CFieldReference pIastFieldReference) throws UnsupportedCCodeException {
            if (pIastFieldReference.isPointerDereference()) {
                throw new UnsupportedCCodeException("Does not support assignment to dereferenced variable due to missing aliasing support", this.edgeForExpression, pIastFieldReference);
            }
            this.warning = "Analysis may be unsound in case of aliasing.";
            return pIastFieldReference.getFieldOwner().accept(this);
        }

        @Override
        public String visit(CIdExpression pIastIdExpression) {
            return pIastIdExpression.getName();
        }

        @Override
        public String visit(CUnaryExpression pIastUnaryExpression) throws UnsupportedCCodeException {
            return pIastUnaryExpression.getOperand().accept(this);
        }

        @Override
        public String visit(CPointerExpression pIastUnaryExpression) throws UnsupportedCCodeException {
            throw new UnsupportedCCodeException("Does not support assignment to dereferenced variable due to missing aliasing support", this.edgeForExpression, pIastUnaryExpression);
        }
    }
}

