/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.reachingdef;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.reachdef.ReachingDefState;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class ReachingDefinitionStorage
implements Serializable {
    private static final long serialVersionUID = 5248630359398001325L;
    private static ReachingDefinitionStorage instance = new ReachingDefinitionStorage();
    private List<Map<String, Set<ReachingDefState.DefinitionPoint>>> savedReachingDefinitions;
    private Map<Map<String, Set<ReachingDefState.DefinitionPoint>>, Integer> elementsToSave;
    private int nextId = 0;

    private ReachingDefinitionStorage() {
        GlobalInfo.getInstance().addHelperStorage(this);
    }

    public int saveMap(Map<String, Set<ReachingDefState.DefinitionPoint>> reachDefs) {
        if (this.elementsToSave == null) {
            this.elementsToSave = new HashMap<Map<String, Set<ReachingDefState.DefinitionPoint>>, Integer>();
        }
        if (this.elementsToSave.containsKey(reachDefs)) {
            return this.elementsToSave.get(reachDefs);
        }
        if (this.nextId == Integer.MAX_VALUE) {
            throw new IllegalStateException("More Elements must be stored than IDs are available");
        }
        this.elementsToSave.put(reachDefs, this.nextId);
        int result = this.nextId++;
        return result;
    }

    public Map<String, Set<ReachingDefState.DefinitionPoint>> getMap(int pId) {
        return this.savedReachingDefinitions.get(pId);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.elementsToSave.size());
        Map[] array = new Map[this.elementsToSave.size()];
        Iterator<Map<String, Set<ReachingDefState.DefinitionPoint>>> i$ = this.elementsToSave.keySet().iterator();
        while (i$.hasNext()) {
            Map<String, Set<ReachingDefState.DefinitionPoint>> elem;
            array[this.elementsToSave.get(elem).intValue()] = elem = i$.next();
        }
        for (Map elem : array) {
            out.writeInt(elem.size());
            for (Map.Entry entry : elem.entrySet()) {
                String key = (String)entry.getKey();
                out.writeObject(key);
                out.writeInt(((Set)entry.getValue()).size());
                for (ReachingDefState.DefinitionPoint point : (Set)entry.getValue()) {
                    out.writeObject(point);
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int numElem = in.readInt();
        this.savedReachingDefinitions = new ArrayList<Map<String, Set<ReachingDefState.DefinitionPoint>>>(numElem);
        for (int i = 0; i < numElem; ++i) {
            int numKeys = in.readInt();
            HashMap map = Maps.newHashMapWithExpectedSize((int)numKeys);
            for (int j = 0; j < numKeys; ++j) {
                String key = (String)in.readObject();
                int numPoints = in.readInt();
                Object[] set = new ReachingDefState.DefinitionPoint[numPoints];
                for (int k = 0; k < numPoints; ++k) {
                    set[k] = (ReachingDefState.DefinitionPoint)in.readObject();
                }
                map.put(key, ImmutableSet.copyOf((Object[])set));
            }
            this.savedReachingDefinitions.add(map);
        }
        ReachingDefinitionStorage.instance.savedReachingDefinitions = this.savedReachingDefinitions;
    }

    public static ReachingDefinitionStorage getInstance() {
        return instance;
    }
}

