/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.resources;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;

public class MemoryStatistics
implements Runnable {
    private static final long MEMORY_CHECK_INTERVAL = 100L;
    private final LogManager logger;
    private long maxHeap = 0L;
    private long sumHeap = 0L;
    private long maxHeapAllocated = 0L;
    private long sumHeapAllocated = 0L;
    private long maxNonHeap = 0L;
    private long sumNonHeap = 0L;
    private long maxNonHeapAllocated = 0L;
    private long sumNonHeapAllocated = 0L;
    private final MemoryPoolMXBean[] pools;
    private final long[] sumHeapAllocatedPerPool;
    private final long[] maxHeapAllocatedPerPool;
    private long maxProcess = 0L;
    private long sumProcess = 0L;
    private long count = 0L;
    private final MemoryMXBean memory;
    private final MBeanServer mbeanServer;
    private ObjectName osMbean;
    private static final String MEMORY_SIZE = "CommittedVirtualMemorySize";

    public MemoryStatistics(LogManager pLogger) {
        this.logger = pLogger;
        this.memory = ManagementFactory.getMemoryMXBean();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.osMbean = new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            this.logger.logDebugException((Throwable)e, "Accessing OperatingSystemMXBean failed");
            this.osMbean = null;
        }
        ArrayList<MemoryPoolMXBean> poolList = new ArrayList<MemoryPoolMXBean>(2);
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = pool.getName();
            if (!name.contains("Old")) continue;
            poolList.add(pool);
        }
        this.pools = poolList.toArray(new MemoryPoolMXBean[poolList.size()]);
        this.sumHeapAllocatedPerPool = new long[this.pools.length];
        this.maxHeapAllocatedPerPool = new long[this.pools.length];
    }

    @Override
    public void run() {
        while (true) {
            ++this.count;
            MemoryUsage currentHeap = this.memory.getHeapMemoryUsage();
            long currentHeapUsed = currentHeap.getUsed();
            this.maxHeap = Math.max(this.maxHeap, currentHeapUsed);
            this.sumHeap += currentHeapUsed;
            long currentHeapAllocated = currentHeap.getCommitted();
            this.maxHeapAllocated = Math.max(this.maxHeapAllocated, currentHeapAllocated);
            this.sumHeapAllocated += currentHeapAllocated;
            MemoryUsage currentNonHeap = this.memory.getNonHeapMemoryUsage();
            long currentNonHeapUsed = currentNonHeap.getUsed();
            this.maxNonHeap = Math.max(this.maxNonHeap, currentNonHeapUsed);
            this.sumNonHeap += currentNonHeapUsed;
            long currentNonHeapAllocated = currentNonHeap.getCommitted();
            this.maxNonHeapAllocated = Math.max(this.maxNonHeapAllocated, currentNonHeapAllocated);
            this.sumNonHeapAllocated += currentNonHeapAllocated;
            int i = 0;
            while (i < this.pools.length) {
                long currentPoolUsage = this.pools[i].getUsage().getUsed();
                this.maxHeapAllocatedPerPool[i] = Math.max(this.maxHeapAllocatedPerPool[i], currentPoolUsage);
                int n = i++;
                this.sumHeapAllocatedPerPool[n] = this.sumHeapAllocatedPerPool[n] + currentPoolUsage;
            }
            if (this.osMbean != null) {
                try {
                    long memUsed = (Long)this.mbeanServer.getAttribute(this.osMbean, MEMORY_SIZE);
                    this.maxProcess = Math.max(this.maxProcess, memUsed);
                    this.sumProcess += memUsed;
                }
                catch (JMException e) {
                    this.logger.logDebugException((Throwable)e, "Querying memory size failed");
                    this.osMbean = null;
                }
                catch (ClassCastException e) {
                    this.logger.logDebugException((Throwable)e, "Querying memory size failed");
                    this.osMbean = null;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void printStatistics(PrintStream out) {
        long heapPeak = 0L;
        long nonHeapPeak = 0L;
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            long peak = pool.getPeakUsage().getUsed();
            if (pool.getType() == MemoryType.HEAP) {
                heapPeak += peak;
                continue;
            }
            nonHeapPeak += peak;
        }
        out.println("Used heap memory:             " + MemoryStatistics.formatMem(this.maxHeap) + " max; " + MemoryStatistics.formatMem(this.sumHeap / this.count) + " avg; " + MemoryStatistics.formatMem(heapPeak) + " peak");
        out.println("Used non-heap memory:         " + MemoryStatistics.formatMem(this.maxNonHeap) + " max; " + MemoryStatistics.formatMem(this.sumNonHeap / this.count) + " avg; " + MemoryStatistics.formatMem(nonHeapPeak) + " peak");
        for (int i = 0; i < this.pools.length; ++i) {
            String name = Strings.padEnd((String)("Used in " + this.pools[i].getName() + " pool:"), (int)30, (char)' ');
            out.println(name + MemoryStatistics.formatMem(this.maxHeapAllocatedPerPool[i]) + " max; " + MemoryStatistics.formatMem(this.sumHeapAllocatedPerPool[i] / this.count) + " avg; " + MemoryStatistics.formatMem(this.pools[i].getPeakUsage().getUsed()) + " peak");
        }
        out.println("Allocated heap memory:        " + MemoryStatistics.formatMem(this.maxHeapAllocated) + " max; " + MemoryStatistics.formatMem(this.sumHeapAllocated / this.count) + " avg");
        out.println("Allocated non-heap memory:    " + MemoryStatistics.formatMem(this.maxNonHeapAllocated) + " max; " + MemoryStatistics.formatMem(this.sumNonHeapAllocated / this.count) + " avg");
        if (this.osMbean != null) {
            out.println("Total process virtual memory: " + MemoryStatistics.formatMem(this.maxProcess) + " max; " + MemoryStatistics.formatMem(this.sumProcess / this.count) + " avg");
        }
    }

    public static void printGcStatistics(PrintStream out) {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        HashSet<String> gcNames = new HashSet<String>();
        long gcTime = 0L;
        int gcCount = 0;
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            gcTime += gcBean.getCollectionTime();
            gcCount = (int)((long)gcCount + gcBean.getCollectionCount());
            gcNames.add(gcBean.getName());
        }
        out.println("Time for Garbage Collector:   " + TimeSpan.ofMillis((long)gcTime).formatAs(TimeUnit.SECONDS) + " (in " + gcCount + " runs)");
        out.println("Garbage Collector(s) used:    " + Joiner.on((String)", ").join(gcNames));
    }

    private static String formatMem(long mem) {
        return String.format("%6dMB (%6d MiB)", mem / 1000L / 1000L, mem >> 20);
    }
}

