/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.resources;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public final class ProcessCpuTime {
    private static final MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final ObjectName osMbean;
    private static final String PROCESS_CPU_TIME = "ProcessCpuTime";

    private ProcessCpuTime() {
    }

    public static long read() throws JMException {
        Object cputime = mbeanServer.getAttribute(osMbean, PROCESS_CPU_TIME);
        if (!(cputime instanceof Long)) {
            throw new JMException("Invalid value received for cpu time: " + cputime);
        }
        long time = (Long)cputime;
        if (time < 0L) {
            throw new JMException("Current platform does not support reading the process cpu time");
        }
        return time;
    }

    static {
        try {
            osMbean = new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
    }
}

