/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.resources;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.util.resources.ProcessCpuTime;
import org.sosy_lab.cpachecker.util.resources.ResourceLimit;

public class ProcessCpuTimeLimit
implements ResourceLimit {
    private final int processorCount = Runtime.getRuntime().availableProcessors();
    private final long duration;
    private final long endTime;

    private ProcessCpuTimeLimit(long pStart, long pLimit, TimeUnit pUnit) {
        Preconditions.checkArgument((pLimit > 0L ? 1 : 0) != 0);
        this.duration = TimeUnit.NANOSECONDS.convert(pLimit, pUnit);
        this.endTime = pStart + this.duration;
    }

    public static ProcessCpuTimeLimit fromNowOn(TimeSpan timeSpan) throws JMException {
        return new ProcessCpuTimeLimit(ProcessCpuTime.read(), timeSpan.asNanos(), TimeUnit.NANOSECONDS);
    }

    public static ProcessCpuTimeLimit fromNowOn(long limit, TimeUnit unit) throws JMException {
        return new ProcessCpuTimeLimit(ProcessCpuTime.read(), limit, unit);
    }

    public static ProcessCpuTimeLimit sinceProcessStart(long time, TimeUnit unit) throws JMException {
        ProcessCpuTime.read();
        return new ProcessCpuTimeLimit(0L, time, unit);
    }

    @Override
    public long getCurrentValue() {
        try {
            return ProcessCpuTime.read();
        }
        catch (JMException e) {
            return 0L;
        }
    }

    @Override
    public boolean isExceeded(long pCurrentValue) {
        return pCurrentValue >= this.endTime;
    }

    @Override
    public long nanoSecondsToNextCheck(long pCurrentValue) {
        if (pCurrentValue == 0L) {
            return Long.MAX_VALUE;
        }
        return (this.endTime - pCurrentValue) / (long)this.processorCount;
    }

    @Override
    public String getName() {
        return "CPU-time limit of " + TimeUnit.NANOSECONDS.toSeconds(this.duration) + "s";
    }
}

