/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;
import org.sosy_lab.cpachecker.util.statistics.StatisticsUtils;

public abstract class AbstractStatistics
implements Statistics {
    protected int outputNameColWidth = 50;
    private Map<String, Object> keyValueStats = new TreeMap<String, Object>();

    protected void put(PrintStream target, int indentLevel, String name, Object value) {
        StatisticsUtils.write(target, indentLevel, this.outputNameColWidth, name, value);
    }

    protected void put(PrintStream target, int indentLevel, AbstractStatValue stat) {
        StatisticsUtils.write(target, indentLevel, this.outputNameColWidth, stat);
    }

    protected void put(PrintStream pTarget, String pName, Object pValue) {
        this.put(pTarget, 0, pName, pValue);
    }

    public void addKeyValueStatistic(String pName, Object pValue) {
        this.keyValueStats.put(pName, pValue);
    }

    @Override
    public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        for (String key : this.keyValueStats.keySet()) {
            this.put(pOut, key, this.keyValueStats.get(key));
        }
    }

    @Override
    public String getName() {
        String result = this.getClass().getSimpleName();
        int relevantUntil = result.lastIndexOf(Statistics.class.getSimpleName());
        if (relevantUntil == -1) {
            return result;
        }
        return result.substring(0, relevantUntil);
    }
}

