/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;
import org.sosy_lab.cpachecker.util.statistics.StatKind;

public class StatInt
extends AbstractStatValue {
    private int maxValue = Integer.MIN_VALUE;
    private int minValue = Integer.MAX_VALUE;
    private int valueCount = 0;
    private int valueSum = 0;

    public StatInt(StatKind pMainStatisticKind, String pTitle) {
        super(pMainStatisticKind, pTitle);
    }

    public void setNextValue(int newValue) {
        this.valueSum += newValue;
        ++this.valueCount;
        this.maxValue = Math.max(newValue, this.maxValue);
        this.minValue = Math.min(newValue, this.minValue);
    }

    public int getMaxValue() {
        return this.valueCount == 0 ? 0 : this.maxValue;
    }

    public int getMinValue() {
        return this.valueCount == 0 ? 0 : this.minValue;
    }

    public int getValueCount() {
        return this.valueCount;
    }

    public int getValueSum() {
        return this.valueSum;
    }

    public float getAverage() {
        if (this.valueCount > 0) {
            return (float)this.valueSum / (float)this.valueCount;
        }
        return 0.0f;
    }

    @Override
    public int getUpdateCount() {
        return this.valueCount;
    }

    public String toString() {
        return String.format("%8d (count: %d, min: %d, max: %d, avg: %.2f)", this.valueSum, this.valueCount, this.getMinValue(), this.getMaxValue(), Float.valueOf(this.getAverage()));
    }
}

