/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.statistics;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.Locale;
import org.sosy_lab.cpachecker.util.statistics.AbstractStatValue;

public class StatisticsUtils {
    private StatisticsUtils() {
    }

    public static String toPercent(double val, double full) {
        return String.format("%1.0f", val / full * 100.0) + "%";
    }

    public static String valueWithPercentage(int value, int totalCount) {
        return value + " (" + StatisticsUtils.toPercent(value, totalCount) + ")";
    }

    public static String div(double val, double full) {
        return String.format(Locale.ROOT, "%.2f", val / full);
    }

    public static void write(PrintStream target, int indentLevel, int outputNameColWidth, String name, Object value) {
        String indentation = Strings.repeat((String)"  ", (int)indentLevel);
        target.println(String.format("%-" + outputNameColWidth + "s %s", indentation + name + ":", value));
    }

    public static void write(PrintStream target, int indentLevel, int outputNameColWidth, AbstractStatValue stat) {
        StatisticsUtils.write(target, indentLevel, outputNameColWidth, stat.getTitle(), stat.toString());
    }
}

