/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.test;

import com.google.common.base.Preconditions;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class BooleanFormulaSubject
extends Subject<BooleanFormulaSubject, BooleanFormula> {
    private final FormulaManager mgr;

    BooleanFormulaSubject(FailureStrategy pFailureStrategy, BooleanFormula pFormula, FormulaManager pMgr) {
        super(pFailureStrategy, (Object)pFormula);
        this.mgr = (FormulaManager)Preconditions.checkNotNull((Object)pMgr);
    }

    private void checkIsUnsat(BooleanFormula subject, String verb, Object expected) throws SolverException, InterruptedException {
        try (ProverEnvironment prover = this.mgr.newProverEnvironment(true, false);){
            prover.push(subject);
            if (prover.isUnsat()) {
                return;
            }
            Model model = prover.getModel();
            if (model.isEmpty()) {
                this.fail(verb, expected);
            } else {
                this.failWithBadResults(verb, expected, "has counterexample", (Object)model);
            }
        }
    }

    public void isUnsatisfiable() throws SolverException, InterruptedException {
        if (this.mgr.getBooleanFormulaManager().isTrue((BooleanFormula)this.getSubject())) {
            this.failWithBadResults("is", "unsatisfiable", "is", "trivially satisfiable");
        }
        this.checkIsUnsat((BooleanFormula)this.getSubject(), "is", "unsatisfiable");
    }

    public void isSatisfiable() throws SolverException, InterruptedException {
        if (this.mgr.getBooleanFormulaManager().isFalse((BooleanFormula)this.getSubject())) {
            this.failWithBadResults("is", "satisfiable", "is", "trivially unsatisfiable");
        }
        try (ProverEnvironment prover = this.mgr.newProverEnvironment(false, true);){
            prover.push((BooleanFormula)this.getSubject());
            if (!prover.isUnsat()) {
                return;
            }
            List<BooleanFormula> unsatCore = prover.getUnsatCore();
            if (unsatCore.isEmpty()) {
                this.fail("is", "satisfiable");
            } else {
                this.failWithBadResults("is", "satisfiable", "has unsat core", unsatCore);
            }
        }
    }

    public void isEquivalentTo(BooleanFormula expected) throws SolverException, InterruptedException {
        if (((BooleanFormula)this.getSubject()).equals(expected)) {
            return;
        }
        BooleanFormula f = this.mgr.getBooleanFormulaManager().xor((BooleanFormula)this.getSubject(), expected);
        this.checkIsUnsat(f, "is equivalent to", expected);
    }

    public void implies(BooleanFormula expected) throws SolverException, InterruptedException {
        if (((BooleanFormula)this.getSubject()).equals(expected)) {
            return;
        }
        BooleanFormulaManager bmgr = this.mgr.getBooleanFormulaManager();
        BooleanFormula implication = bmgr.or(bmgr.not((BooleanFormula)this.getSubject()), expected);
        this.checkIsUnsat(bmgr.not(implication), "implies", expected);
    }
}

