/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.test;

import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.StringBuildingLogHandler;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class CPATestRunner {
    public static TestResults runAndLogToSTDOUT(Map<String, String> pProperties, String pSourceCodeFilePath) throws Exception {
        return CPATestRunner.run(pProperties, pSourceCodeFilePath, true);
    }

    public static TestResults run(Map<String, String> pProperties, String pSourceCodeFilePath) throws Exception {
        return CPATestRunner.run(pProperties, pSourceCodeFilePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestResults run(Map<String, String> pProperties, String pSourceCodeFilePath, boolean writeLogToSTDOUT) throws Exception {
        Configuration config = TestDataTools.configurationForTest().setOptions(pProperties).build();
        StringBuildingLogHandler stringLogHandler = new StringBuildingLogHandler();
        Object h = writeLogToSTDOUT ? new StreamHandler(System.out, new SimpleFormatter()) : stringLogHandler;
        BasicLogManager logger = new BasicLogManager(config, (Handler)h);
        ShutdownNotifier shutdownNotifier = ShutdownNotifier.create();
        CPAchecker cpaChecker = new CPAchecker(config, (LogManager)logger, shutdownNotifier);
        try {
            CPAcheckerResult results = cpaChecker.run(pSourceCodeFilePath);
            TestResults testResults = new TestResults(stringLogHandler.getLog(), results);
            return testResults;
        }
        finally {
            logger.flush();
        }
    }
}

