/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.test;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.exceptions.SolverException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BasicProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ProverEnvironment;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class ProverEnvironmentSubject
extends Subject<ProverEnvironmentSubject, BasicProverEnvironment<?>> {
    ProverEnvironmentSubject(FailureStrategy pFailureStrategy, BasicProverEnvironment<?> pStack) {
        super(pFailureStrategy, pStack);
    }

    public void isUnsatisfiable() throws SolverException, InterruptedException {
        if (((BasicProverEnvironment)this.getSubject()).isUnsat()) {
            return;
        }
        Model model = ((BasicProverEnvironment)this.getSubject()).getModel();
        if (model.isEmpty()) {
            this.fail("is", "unsatisfiable");
        } else {
            this.failWithBadResults("is", "unsatisfiable", "has counterexample", (Object)model);
        }
    }

    public void isSatisfiable() throws SolverException, InterruptedException {
        List<BooleanFormula> unsatCore;
        if (!((BasicProverEnvironment)this.getSubject()).isUnsat()) {
            return;
        }
        if (this.getSubject() instanceof ProverEnvironment && !(unsatCore = ((ProverEnvironment)this.getSubject()).getUnsatCore()).isEmpty()) {
            this.failWithBadResults("is", "satisfiable", "has unsat core", unsatCore);
            return;
        }
        this.fail("is", "satisfiable");
    }
}

