/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.test;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.SubjectFactory;
import com.google.common.truth.TruthJUnit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;
import org.junit.After;
import org.junit.Before;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.util.predicates.FormulaManagerFactory;
import org.sosy_lab.cpachecker.util.predicates.interfaces.ArrayFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BasicProverEnvironment;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.FunctionFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interfaces.QuantifiedFormulaManager;
import org.sosy_lab.cpachecker.util.test.BooleanFormulaSubject;
import org.sosy_lab.cpachecker.util.test.ProverEnvironmentSubject;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="test code")
public abstract class SolverBasedTest0 {
    protected Configuration config;
    protected final LogManager logger = TestLogManager.getInstance();
    protected FormulaManagerFactory factory;
    protected FormulaManager mgr;
    protected BooleanFormulaManager bmgr;
    protected FunctionFormulaManager fmgr;
    protected NumeralFormulaManager<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> imgr;
    @Nullable
    protected NumeralFormulaManager<NumeralFormula, NumeralFormula.RationalFormula> rmgr;
    @Nullable
    protected QuantifiedFormulaManager qmgr;
    @Nullable
    protected ArrayFormulaManager amgr;

    protected FormulaManagerFactory.Solvers solverToUse() {
        return FormulaManagerFactory.Solvers.SMTINTERPOL;
    }

    protected ConfigurationBuilder createTestConfigBuilder() throws InvalidConfigurationException {
        return TestDataTools.configurationForTest().setOption("cpa.predicate.solver", this.solverToUse().toString());
    }

    @Before
    public final void initSolver() throws Exception {
        this.config = this.createTestConfigBuilder().build();
        try {
            this.factory = new FormulaManagerFactory(this.config, this.logger, ShutdownNotifier.create());
        }
        catch (NoClassDefFoundError e) {
            TruthJUnit.assume().withFailureMessage("Scala is not on class path").that(e.getMessage()).doesNotContain((CharSequence)"scala");
        }
        this.mgr = this.factory.getFormulaManager();
        this.fmgr = this.mgr.getFunctionFormulaManager();
        this.bmgr = this.mgr.getBooleanFormulaManager();
        this.imgr = this.mgr.getIntegerFormulaManager();
        try {
            this.rmgr = this.mgr.getRationalFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.rmgr = null;
        }
        try {
            this.qmgr = this.mgr.getQuantifiedFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.qmgr = null;
        }
        try {
            this.amgr = this.mgr.getArrayFormulaManager();
        }
        catch (UnsupportedOperationException e) {
            this.amgr = null;
        }
    }

    @After
    public final void closeSolver() throws Exception {
        if (this.mgr instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.mgr)).close();
        }
    }

    protected final void requireRationals() {
        TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support the theory of rationals").that(this.rmgr).isNotNull();
    }

    protected final void requireQuantifiers() {
        TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support quantifiers").that((Object)this.qmgr).isNotNull();
    }

    protected final void requireArrays() {
        TruthJUnit.assume().withFailureMessage("Solver " + (Object)((Object)this.solverToUse()) + " does not support the theory of arrays").that((Object)this.amgr).isNotNull();
    }

    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="fits better when called as about(BooleanFormula())")
    protected final SubjectFactory<BooleanFormulaSubject, BooleanFormula> BooleanFormula() {
        return SolverBasedTest0.BooleanFormulaOfSolver(this.mgr);
    }

    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="fits better when called as about(BooleanFormulaOfSolver())")
    public static final SubjectFactory<BooleanFormulaSubject, BooleanFormula> BooleanFormulaOfSolver(final FormulaManager mgr) {
        return new SubjectFactory<BooleanFormulaSubject, BooleanFormula>(){

            public BooleanFormulaSubject getSubject(FailureStrategy pFs, BooleanFormula pFormula) {
                return new BooleanFormulaSubject(pFs, pFormula, mgr);
            }
        };
    }

    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="fits better when called as about(ProverEnvironment())")
    public static final SubjectFactory<ProverEnvironmentSubject, BasicProverEnvironment<?>> ProverEnvironment() {
        return new SubjectFactory<ProverEnvironmentSubject, BasicProverEnvironment<?>>(){

            public ProverEnvironmentSubject getSubject(FailureStrategy pFs, BasicProverEnvironment<?> pFormula) {
                return new ProverEnvironmentSubject(pFs, pFormula);
            }
        };
    }
}

