/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.converters.FileTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.exceptions.ParserException;

public class TestDataTools {
    public static final CFANode DUMMY_CFA_NODE = new CFANode("DUMMY");
    private static int dummyNodeCounter = 0;
    public static final CInitializer INT_ZERO_INITIALIZER = new CInitializerExpression(FileLocation.DUMMY, CIntegerLiteralExpression.ZERO);

    public static ConfigurationBuilder configurationForTest() throws InvalidConfigurationException {
        Configuration typeConverterConfig = Configuration.builder().setOption("output.disable", "true").build();
        return Configuration.builder().addConverter(FileOption.class, (TypeConverter)FileTypeConverter.createWithSafePathsOnly((Configuration)typeConverterConfig));
    }

    private static CFANode newDummyNode() {
        return new CFANode("DUMMY" + dummyNodeCounter++);
    }

    public static Triple<CDeclarationEdge, CFunctionDeclaration, CFunctionType> makeFunctionDeclaration(String pFunctionName, CType pFunctionReturnType, List<CParameterDeclaration> pParameters) {
        CFunctionType functionType = new CFunctionType(false, false, (CType)Preconditions.checkNotNull((Object)pFunctionReturnType), (List<CType>)ImmutableList.of(), false);
        CFunctionDeclaration fd = new CFunctionDeclaration(FileLocation.DUMMY, functionType, pFunctionName, pParameters);
        CDeclarationEdge declEdge = new CDeclarationEdge("", FileLocation.DUMMY, TestDataTools.newDummyNode(), TestDataTools.newDummyNode(), fd);
        return Triple.of((Object)declEdge, (Object)fd, (Object)functionType);
    }

    public static Triple<CDeclarationEdge, CVariableDeclaration, CIdExpression> makeDeclaration(String varName, CType varType, @Nullable CInitializer initializer) {
        FileLocation loc = FileLocation.DUMMY;
        CVariableDeclaration decl = new CVariableDeclaration(loc, true, CStorageClass.AUTO, varType, varName, varName, varName, initializer);
        return Triple.of((Object)new CDeclarationEdge(String.format("%s %s", "dummy", varName), FileLocation.DUMMY, TestDataTools.newDummyNode(), TestDataTools.newDummyNode(), decl), (Object)decl, (Object)new CIdExpression(FileLocation.DUMMY, decl));
    }

    public static CFAEdge makeBlankEdge(String pDescription) {
        return new BlankEdge("", FileLocation.DUMMY, TestDataTools.newDummyNode(), TestDataTools.newDummyNode(), pDescription);
    }

    public static Pair<CFAEdge, CExpressionAssignmentStatement> makeAssignment(CLeftHandSide pLhs, CExpression pRhs) {
        CExpressionAssignmentStatement stmt = new CExpressionAssignmentStatement(FileLocation.DUMMY, pLhs, pRhs);
        CStatementEdge edge = new CStatementEdge("dummy := rhs", stmt, FileLocation.DUMMY, TestDataTools.newDummyNode(), TestDataTools.newDummyNode());
        return Pair.of((Object)edge, (Object)stmt);
    }

    public static CIdExpression makeVariable(String varName, CSimpleType varType) {
        FileLocation loc = FileLocation.DUMMY;
        CVariableDeclaration decl = new CVariableDeclaration(loc, true, CStorageClass.AUTO, varType, varName, varName, varName, null);
        return new CIdExpression(loc, decl);
    }

    public static Pair<CAssumeEdge, CExpression> makeNegatedAssume(CExpression pAssumeExr) {
        CAssumeEdge assumeEdge = new CAssumeEdge("dummyassume", FileLocation.DUMMY, TestDataTools.newDummyNode(), TestDataTools.newDummyNode(), pAssumeExr, false);
        return Pair.of((Object)assumeEdge, (Object)pAssumeExr);
    }

    public static Pair<CAssumeEdge, CExpression> makeAssume(CExpression pAssumeExr, CFANode pPred, CFANode pSucc) {
        CAssumeEdge assumeEdge = new CAssumeEdge("dummyassume", FileLocation.DUMMY, pPred, pSucc, pAssumeExr, true);
        return Pair.of((Object)assumeEdge, (Object)pAssumeExr);
    }

    public static Pair<CAssumeEdge, CExpression> makeAssume(CExpression pAssumeExr) {
        return TestDataTools.makeAssume(pAssumeExr, TestDataTools.newDummyNode(), TestDataTools.newDummyNode());
    }

    public static CFA makeCFA(String cProgram) throws IOException, ParserException, InterruptedException {
        try {
            return TestDataTools.makeCFA(cProgram, TestDataTools.configurationForTest().build());
        }
        catch (InvalidConfigurationException e) {
            throw new AssertionError((Object)"Default configuration is invalid?");
        }
    }

    public static CFA makeCFA(String cProgram, Configuration config) throws InvalidConfigurationException, IOException, ParserException, InterruptedException {
        CFACreator creator = new CFACreator(config, TestLogManager.getInstance(), ShutdownNotifier.create());
        return creator.parseFileAndCreateCFA(cProgram);
    }
}

