/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.sosy_lab.common.log.LogManager;

public abstract class AbstractMBean {
    @Nullable
    private static final MBeanServer MBEAN_SERVER = AbstractMBean.getMBeanServer();
    @Nullable
    private ObjectName oname = null;
    private final LogManager logger;

    @Nullable
    private static MBeanServer getMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    protected AbstractMBean(String name, LogManager logger) {
        this.logger = Preconditions.checkNotNull(logger);
        if (MBEAN_SERVER != null) {
            try {
                this.oname = new ObjectName(Preconditions.checkNotNull(name));
            }
            catch (MalformedObjectNameException e) {
                logger.logException(Level.WARNING, e, "Invalid object name specified for management interface");
            }
        }
    }

    public void register() {
        if (MBEAN_SERVER != null && this.oname != null) {
            try {
                if (MBEAN_SERVER.isRegistered(this.oname)) {
                    MBEAN_SERVER.unregisterMBean(this.oname);
                    assert (!MBEAN_SERVER.isRegistered(this.oname));
                }
                MBEAN_SERVER.registerMBean(this, this.oname);
            }
            catch (JMException e) {
                this.logger.logException(Level.WARNING, e, "Error during registration of management interface");
                this.oname = null;
            }
            catch (SecurityException e) {
                this.logger.logException(Level.WARNING, e, "Error during registration of management interface");
                this.oname = null;
            }
        } else {
            this.logger.log(Level.WARNING, "Cannot register management interface");
        }
    }

    public void unregister() {
        if (MBEAN_SERVER != null && this.oname != null) {
            try {
                MBEAN_SERVER.unregisterMBean(this.oname);
            }
            catch (JMException e) {
                this.logger.logException(Level.WARNING, e, "Error during unregistration of management interface");
            }
            catch (SecurityException e) {
                this.logger.logException(Level.WARNING, e, "Error during unregistration of management interface");
            }
        }
    }
}

