/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Triple<A, B, C>
implements Serializable {
    private static final long serialVersionUID = 1272029955865151903L;
    @Nullable
    private final A first;
    @Nullable
    private final B second;
    @Nullable
    private final C third;

    private Triple(@Nullable A first, @Nullable B second, @Nullable C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, B, C> Triple<A, B, C> of(@Nullable A first, @Nullable B second, @Nullable C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    @Nullable
    public final A getFirst() {
        return this.first;
    }

    @Nullable
    public final B getSecond() {
        return this.second;
    }

    @Nullable
    public final C getThird() {
        return this.third;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ")";
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Triple && Objects.equals(this.first, ((Triple)other).first) && Objects.equals(this.second, ((Triple)other).second) && Objects.equals(this.third, ((Triple)other).third);
    }

    public int hashCode() {
        if (this.first == null && this.second == null) {
            return this.third == null ? 0 : this.third.hashCode() + 1;
        }
        if (this.first == null && this.third == null) {
            return this.second.hashCode() + 2;
        }
        if (this.first == null) {
            return this.second.hashCode() * 7 + this.third.hashCode();
        }
        if (this.second == null && this.third == null) {
            return this.first.hashCode() + 3;
        }
        if (this.second == null) {
            return this.first.hashCode() * 11 + this.third.hashCode();
        }
        if (this.third == null) {
            return this.first.hashCode() * 13 + this.second.hashCode();
        }
        return this.first.hashCode() * 17 + this.second.hashCode() * 5 + this.third.hashCode();
    }

    public static <T> Function<Triple<? extends T, ?, ?>, T> getProjectionToFirst() {
        return Holder.getInstance().PROJECTION_TO_FIRST;
    }

    public static <T> Function<Triple<?, ? extends T, ?>, T> getProjectionToSecond() {
        return Holder.getInstance().PROJECTION_TO_SECOND;
    }

    public static <T> Function<Triple<?, ?, ? extends T>, T> getProjectionToThird() {
        return Holder.getInstance().PROJECTION_TO_THIRD;
    }

    public static <A1, B1, A2, B2, A3, B3> Function<Triple<A1, A2, A3>, Triple<B1, B2, B3>> componentWise(final Function<? super A1, ? extends B1> f1, final Function<? super A2, ? extends B2> f2, final Function<? super A3, ? extends B3> f3) {
        Preconditions.checkNotNull(f1);
        Preconditions.checkNotNull(f2);
        Preconditions.checkNotNull(f3);
        return new Function<Triple<A1, A2, A3>, Triple<B1, B2, B3>>(){

            @Override
            public Triple<B1, B2, B3> apply(@Nonnull Triple<A1, A2, A3> pInput) {
                return Triple.of(f1.apply(pInput.getFirst()), f2.apply(pInput.getSecond()), f3.apply(pInput.getThird()));
            }
        };
    }

    public static <A extends Comparable<? super A>, B extends Comparable<? super B>, C extends Comparable<? super C>> Ordering<Triple<A, B, C>> lexicographicalNaturalComparator() {
        return Triple.lexicographicalComparator(Ordering.natural(), Ordering.natural(), Ordering.natural());
    }

    public static <A, B, C> Ordering<Triple<A, B, C>> lexicographicalComparator(Comparator<A> firstOrdering, Comparator<B> secondOrdering, Comparator<C> thirdOrdering) {
        Ordering firstDimension = Ordering.from(firstOrdering).onResultOf(Triple.getProjectionToFirst());
        Ordering secondDimension = Ordering.from(secondOrdering).onResultOf(Triple.getProjectionToSecond());
        Ordering thirdDimension = Ordering.from(thirdOrdering).onResultOf(Triple.getProjectionToThird());
        return firstDimension.compound(secondDimension).compound(thirdDimension);
    }

    private static final class Holder<T> {
        private static final Holder<?> INSTANCE = new Holder();
        private final Function<Triple<? extends T, ?, ?>, T> PROJECTION_TO_FIRST = new Function<Triple<? extends T, ?, ?>, T>(){

            @Override
            public T apply(@Nonnull Triple<? extends T, ?, ?> pArg0) {
                return pArg0.getFirst();
            }
        };
        private final Function<Triple<?, ? extends T, ?>, T> PROJECTION_TO_SECOND = new Function<Triple<?, ? extends T, ?>, T>(){

            @Override
            public T apply(@Nonnull Triple<?, ? extends T, ?> pArg0) {
                return pArg0.getSecond();
            }
        };
        private final Function<Triple<?, ?, ? extends T>, T> PROJECTION_TO_THIRD = new Function<Triple<?, ?, ? extends T>, T>(){

            @Override
            public T apply(@Nonnull Triple<?, ?, ? extends T> pArg0) {
                return pArg0.getThird();
            }
        };

        private Holder() {
        }

        public static <T> Holder<T> getInstance() {
            return INSTANCE;
        }
    }
}

