/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableListIterator;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.common.collect.PersistentList;

@Immutable
public class PersistentLinkedList<T>
extends AbstractSequentialList<T>
implements PersistentList<T> {
    @Nullable
    private final T head;
    @Nullable
    private final PersistentLinkedList<T> tail;
    private static final PersistentLinkedList EMPTY = PersistentLinkedList.makeEmpty();

    private PersistentLinkedList(@Nullable T head, @Nullable PersistentLinkedList<T> tail) {
        this.head = head;
        this.tail = tail;
    }

    private static PersistentLinkedList makeEmpty() {
        return new PersistentLinkedList<Object>(null, null);
    }

    public static <T> PersistentLinkedList<T> of() {
        return EMPTY;
    }

    public static <T> PersistentLinkedList<T> of(T value) {
        Preconditions.checkNotNull(value);
        return new PersistentLinkedList<T>(value, PersistentLinkedList.of());
    }

    public static <T> PersistentLinkedList<T> of(T v1, T v2) {
        return PersistentLinkedList.of(v2).with((Object)v1);
    }

    public static <T> PersistentLinkedList<T> of(T v1, T v2, T v3) {
        return ((PersistentLinkedList)PersistentLinkedList.of(v3).with((Object)v2)).with((Object)v1);
    }

    public static <T> PersistentLinkedList<T> of(T v1, T ... values) {
        return PersistentLinkedList.copyOf(values).with((Object)v1);
    }

    public static <T> PersistentLinkedList<T> copyOf(T ... values) {
        return PersistentLinkedList.copyOf(Arrays.asList(values));
    }

    public static <T> PersistentLinkedList<T> copyOf(List<T> values) {
        if (values instanceof PersistentLinkedList) {
            return (PersistentLinkedList)values;
        }
        PersistentList<T> result = PersistentLinkedList.of();
        for (T value : Lists.reverse(values)) {
            result = result.with((Object)value);
        }
        return result;
    }

    public T head() {
        Preconditions.checkState(!this.isEmpty());
        return this.head;
    }

    public PersistentLinkedList<T> tail() {
        Preconditions.checkState(!this.isEmpty());
        return this.tail;
    }

    @Override
    public PersistentLinkedList<T> with(T value) {
        Preconditions.checkNotNull(value);
        return new PersistentLinkedList<T>(value, this);
    }

    @Override
    public PersistentLinkedList<T> withAll(List<T> values) {
        PersistentList<T> result = this;
        if (values instanceof PersistentLinkedList) {
            values = ImmutableList.copyOf(values);
        }
        for (T value : Lists.reverse(values)) {
            result = result.with((Object)value);
        }
        return result;
    }

    @Override
    public PersistentLinkedList<T> without(@Nullable T value) {
        PersistentLinkedList<T> suffix = PersistentLinkedList.of();
        int pos = 0;
        PersistentLinkedList<T> list = this;
        while (!list.isEmpty()) {
            if (Objects.equals(value, list.head)) {
                suffix = list.tail;
                break;
            }
            ++pos;
            list = list.tail;
        }
        ImmutableList prefix = FluentIterable.from(this).limit(pos).toList();
        PersistentList<T> result = suffix;
        for (Object v : prefix.reverse()) {
            result = result.with(v);
        }
        return result;
    }

    @Override
    public PersistentLinkedList<T> empty() {
        return PersistentLinkedList.of();
    }

    @Override
    public int size() {
        int size = 0;
        PersistentLinkedList<T> list = this;
        while (!list.isEmpty()) {
            ++size;
            list = list.tail;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this == EMPTY;
    }

    @Override
    public PersistentLinkedList<T> reversed() {
        PersistentList result = this.empty();
        PersistentLinkedList<T> p = this;
        while (!p.isEmpty()) {
            result = ((PersistentLinkedList)result).with((Object)p.head);
            p = p.tail;
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter(this);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Iter it = new Iter(this);
        for (int i = 0; i < index; ++i) {
            if (!it.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            it.next();
        }
        return it;
    }

    private static class Iter<T>
    extends UnmodifiableListIterator<T> {
        private PersistentLinkedList<T> list;
        private int nextIndex = 0;

        private Iter(PersistentLinkedList<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return !this.list.isEmpty();
        }

        @Override
        public T next() {
            if (this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            ++this.nextIndex;
            Object result = ((PersistentLinkedList)this.list).head;
            this.list = ((PersistentLinkedList)this.list).tail;
            return (T)result;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T previous() {
            throw new UnsupportedOperationException();
        }
    }
}

