/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.collect.PersistentSortedMap;

public class PersistentSortedMaps {
    private PersistentSortedMaps() {
    }

    public static <K, V> MergeConflictHandler<K, V> getExceptionMergeConflictHandler() {
        return new MergeConflictHandler<K, V>(){

            @Override
            public V resolveConflict(K key, V value1, V value2) {
                throw new IllegalArgumentException("Conflicting value when merging maps for key " + key + ": " + value1 + " and " + value2);
            }
        };
    }

    public static <K, V extends Comparable<? super V>> MergeConflictHandler<K, V> getMaximumMergeConflictHandler() {
        return new MergeConflictHandler<K, V>(){

            @Override
            public V resolveConflict(K key, V value1, V value2) {
                return (Comparable)Ordering.natural().max(value1, value2);
            }
        };
    }

    public static <K, V extends Comparable<? super V>> MergeConflictHandler<K, V> getMinimumMergeConflictHandler() {
        return new MergeConflictHandler<K, V>(){

            @Override
            public V resolveConflict(K key, V value1, V value2) {
                return (Comparable)Ordering.natural().min(value1, value2);
            }
        };
    }

    private static <K, V> MergeConflictHandler<K, V> inverseMergeConflictHandler(final MergeConflictHandler<K, V> delegate) {
        return new MergeConflictHandler<K, V>(){

            @Override
            public V resolveConflict(K pKey, V pValue1, V pValue2) {
                return delegate.resolveConflict(pKey, pValue2, pValue1);
            }
        };
    }

    public static <K extends Comparable<? super K>, V> PersistentSortedMap<K, V> merge(PersistentSortedMap<K, V> map1, PersistentSortedMap<K, V> map2, MergeConflictHandler<K, V> conflictHandler) {
        if (map1.size() >= map2.size()) {
            return PersistentSortedMaps.merge(map1, map2, Equivalence.equals(), conflictHandler, null);
        }
        return PersistentSortedMaps.merge(map2, map1, Equivalence.equals(), PersistentSortedMaps.inverseMergeConflictHandler(conflictHandler), null);
    }

    public static <K extends Comparable<? super K>, V> PersistentSortedMap<K, V> merge(PersistentSortedMap<K, V> map1, PersistentSortedMap<K, V> map2, Equivalence<? super V> valueEquals, MergeConflictHandler<? super K, V> conflictHandler, @Nullable List<Triple<K, V, V>> collectDifferences) {
        Iterator rest;
        Object value2;
        Comparable key;
        Preconditions.checkNotNull(map1);
        Preconditions.checkNotNull(map2);
        Preconditions.checkNotNull(valueEquals);
        Preconditions.checkNotNull(conflictHandler);
        if (map1 == map2) {
            return map1;
        }
        PersistentSortedMap<Object, V> result = map1;
        Iterator it1 = map1.entrySet().iterator();
        Iterator it2 = map2.entrySet().iterator();
        Map.Entry e1 = null;
        Map.Entry e2 = null;
        while ((e1 != null || it1.hasNext()) && (e2 != null || it2.hasNext())) {
            Object value22;
            Object value1;
            int comp;
            if (e1 == null) {
                e1 = (Map.Entry)it1.next();
            }
            if (e2 == null) {
                e2 = (Map.Entry)it2.next();
            }
            if ((comp = ((Comparable)e1.getKey()).compareTo(e2.getKey())) < 0) {
                key = (Comparable)e1.getKey();
                value1 = e1.getValue();
                if (collectDifferences != null) {
                    collectDifferences.add(Triple.of(key, value1, null));
                }
                e1 = null;
                continue;
            }
            if (comp > 0) {
                key = (Comparable)e2.getKey();
                value2 = e2.getValue();
                assert (!result.containsKey(key));
                result = result.putAndCopy(key, value2);
                if (collectDifferences != null) {
                    collectDifferences.add(Triple.of(key, null, value2));
                }
                e2 = null;
                continue;
            }
            key = (Comparable)e1.getKey();
            value1 = e1.getValue();
            if (!valueEquals.equivalent(value1, value22 = e2.getValue())) {
                V newValue = conflictHandler.resolveConflict(key, value1, value22);
                result = result.putAndCopy(key, newValue);
                if (collectDifferences != null) {
                    collectDifferences.add(Triple.of(key, value1, value22));
                }
            }
            e1 = null;
            e2 = null;
        }
        if (collectDifferences != null) {
            Iterator rest2;
            Iterator<Object> iterator = rest2 = e1 != null ? Iterators.concat(Iterators.singletonIterator(e1), it1) : it1;
            while (rest2.hasNext()) {
                e1 = (Map.Entry)rest2.next();
                collectDifferences.add(Triple.of(e1.getKey(), e1.getValue(), null));
            }
        }
        Iterator<Object> iterator = rest = e2 != null ? Iterators.concat(Iterators.singletonIterator(e2), it2) : it2;
        while (rest.hasNext()) {
            e2 = (Map.Entry)rest.next();
            key = (Comparable)e2.getKey();
            value2 = e2.getValue();
            result = result.putAndCopy(key, value2);
            if (collectDifferences == null) continue;
            collectDifferences.add(Triple.of(key, null, value2));
        }
        assert (result.size() >= Math.max(map1.size(), map2.size()));
        return result;
    }

    public static <K extends Comparable<? super K>, V> Triple<PersistentSortedMap<K, V>, PersistentSortedMap<K, V>, PersistentSortedMap<K, V>> mergeWithKeyDifferences(PersistentSortedMap<K, V> map1, PersistentSortedMap<K, V> map2, MergeConflictHandler<K, V> conflictHandler) {
        if (map1.size() < map2.size()) {
            Triple<PersistentSortedMap<K, V>, PersistentSortedMap<K, V>, PersistentSortedMap<K, V>> result = PersistentSortedMaps.mergeWithKeyDifferences(map2, map1, PersistentSortedMaps.inverseMergeConflictHandler(conflictHandler));
            return Triple.of(result.getSecond(), result.getFirst(), result.getThird());
        }
        ArrayList<Triple<K, V, V>> differences = new ArrayList<Triple<K, V, V>>();
        PersistentSortedMap<K, Object> union = PersistentSortedMaps.merge(map1, map2, Equivalence.equals(), conflictHandler, differences);
        PersistentSortedMap fromSet1 = union.empty();
        PersistentSortedMap fromSet2 = union.empty();
        for (Triple triple : differences) {
            if (triple.getSecond() == null) {
                fromSet2 = fromSet2.putAndCopy(triple.getFirst(), triple.getThird());
                continue;
            }
            if (triple.getThird() != null) continue;
            fromSet1 = fromSet1.putAndCopy(triple.getFirst(), triple.getSecond());
        }
        return Triple.of(fromSet1, fromSet2, union);
    }

    public static interface MergeConflictHandler<K, V> {
        public V resolveConflict(K var1, V var2, V var3);
    }
}

