/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

class SortedMapKeySet<K extends Comparable<? super K>>
extends AbstractSet<K>
implements SortedSet<K> {
    private final SortedMap<K, ?> map;

    SortedMapKeySet(SortedMap<K, ?> pMap) {
        this.map = Preconditions.checkNotNull(pMap);
    }

    @Override
    public Iterator<K> iterator() {
        return Iterators.transform(this.map.entrySet().iterator(), new Function<Map.Entry<K, ?>, K>(){

            @Override
            public K apply(Map.Entry<K, ?> input) {
                return (Comparable)input.getKey();
            }
        });
    }

    @Override
    public boolean contains(Object pO) {
        return this.map.containsKey(pO);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.map.comparator();
    }

    @Override
    public K first() {
        return (K)((Comparable)this.map.firstKey());
    }

    @Override
    public K last() {
        return (K)((Comparable)this.map.lastKey());
    }

    @Override
    public SortedSet<K> subSet(K pFromElement, K pToElement) {
        return new SortedMapKeySet<K>(this.map.subMap(pFromElement, pToElement));
    }

    @Override
    public SortedSet<K> headSet(K pToElement) {
        return new SortedMapKeySet<K>(this.map.headMap(pToElement));
    }

    @Override
    public SortedSet<K> tailSet(K pFromElement) {
        return new SortedMapKeySet<K>(this.map.tailMap(pFromElement));
    }
}

