/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.concurrency;

import com.google.common.base.Preconditions;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class CatchSecurityViolationThreadFactoryBuilder {
    @Nullable
    private Boolean daemon;
    @Nullable
    private String nameFormat;
    @Nullable
    private Integer priority;
    @Nullable
    private Thread.UncaughtExceptionHandler handler;
    @Nullable
    private ThreadFactory backingFactory;

    public CatchSecurityViolationThreadFactoryBuilder setThreadFactory(ThreadFactory factory) {
        this.backingFactory = Preconditions.checkNotNull(factory);
        return this;
    }

    public CatchSecurityViolationThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler pHandler) {
        this.handler = Preconditions.checkNotNull(pHandler);
        return this;
    }

    public CatchSecurityViolationThreadFactoryBuilder setPriority(int pPriority) {
        this.priority = pPriority;
        return this;
    }

    public CatchSecurityViolationThreadFactoryBuilder setNameFormat(String pNamingFormat) {
        this.nameFormat = Preconditions.checkNotNull(pNamingFormat);
        return this;
    }

    public CatchSecurityViolationThreadFactoryBuilder setDaemon(boolean pDaemon) {
        this.daemon = pDaemon;
        return this;
    }

    public ThreadFactory build() {
        return CatchSecurityViolationThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(CatchSecurityViolationThreadFactoryBuilder builder) {
        final Boolean daemon = builder.daemon;
        final String nameFormat = builder.nameFormat;
        final Integer priority = builder.priority;
        final Thread.UncaughtExceptionHandler handler = builder.handler;
        final AtomicLong count = new AtomicLong(0L);
        final ThreadFactory factory = builder.backingFactory != null ? builder.backingFactory : Executors.defaultThreadFactory();
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = factory.newThread(r);
                try {
                    if (daemon != null) {
                        thread.setDaemon(daemon);
                    }
                    if (nameFormat != null) {
                        thread.setName(String.format(nameFormat, count.getAndIncrement()));
                    }
                    if (priority != null) {
                        thread.setPriority(priority);
                    }
                    if (handler != null) {
                        thread.setUncaughtExceptionHandler(handler);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return thread;
            }
        };
    }
}

