/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Builder;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.ConfigurationBuilderFactory;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.OptionCollector;
import org.sosy_lab.common.configuration.OptionDetailAnnotation;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.configuration.converters.BaseTypeConverter;
import org.sosy_lab.common.configuration.converters.ClassTypeConverter;
import org.sosy_lab.common.configuration.converters.IntegerTypeConverter;
import org.sosy_lab.common.configuration.converters.TimeSpanTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;

@Options
public final class Configuration {
    private static ConfigurationBuilderFactory builderFactory = new ConfigurationBuilderFactory(){

        @Override
        public ConfigurationBuilder getBuilder() {
            return new Builder();
        }
    };
    private static boolean secureMode = false;
    @Option(name="log.usedOptions.export", description="all used options are printed")
    private boolean exportUsedOptions = false;
    private static final Splitter ARRAY_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    static final Map<Class<? extends Iterable<?>>, Class<? extends Iterable<?>>> COLLECTIONS;
    static final Map<Class<?>, TypeConverter> DEFAULT_CONVERTERS;
    final ImmutableMap<String, String> properties;
    final ImmutableMap<String, Path> sources;
    final String prefix;
    final ImmutableMap<Class<?>, TypeConverter> converters;
    final Set<String> unusedProperties;
    final Set<String> deprecatedProperties;
    @Nullable
    private LogManager logger = null;

    public static ConfigurationBuilder builder() {
        return Configuration.getBuilderFactory().getBuilder();
    }

    public static void setBuilderFactory(ConfigurationBuilderFactory factory) {
        builderFactory = Preconditions.checkNotNull(factory);
    }

    @VisibleForTesting
    static ConfigurationBuilderFactory getBuilderFactory() {
        return builderFactory;
    }

    public static void enableSecureModeGlobally() {
        secureMode = true;
    }

    public static Configuration defaultConfiguration() {
        return new Configuration(ImmutableMap.of(), ImmutableMap.of(), "", ImmutableMap.copyOf(DEFAULT_CONVERTERS), new HashSet<String>(0), new HashSet<String>(0), null);
    }

    public static Configuration copyWithNewPrefix(Configuration oldConfig, String newPrefix) {
        Configuration newConfig = new Configuration(oldConfig.properties, oldConfig.sources, newPrefix, oldConfig.converters, oldConfig.unusedProperties, oldConfig.deprecatedProperties, oldConfig.logger);
        newConfig.exportUsedOptions = oldConfig.exportUsedOptions;
        return newConfig;
    }

    private static <T extends Iterable<?>> void putSafely(ImmutableMap.Builder<Class<? extends Iterable<?>>, Class<? extends Iterable<?>>> builder, Class<T> iface, Class<? extends T> impl) {
        assert (!impl.isInterface());
        builder.put(iface, impl);
    }

    public static Map<Class<?>, TypeConverter> getDefaultConverters() {
        return DEFAULT_CONVERTERS;
    }

    static Map<Class<?>, TypeConverter> createConverterMap() {
        return MapConstraints.constrainedMap(new HashMap(), new MapConstraint<Class<?>, TypeConverter>(){

            @Override
            public void checkKeyValue(@Nonnull Class<?> cls, @Nonnull TypeConverter pValue) {
                Preconditions.checkNotNull(cls);
                Preconditions.checkNotNull(pValue);
                if (cls.isAnnotation() && !cls.isAnnotationPresent(OptionDetailAnnotation.class)) {
                    throw new IllegalArgumentException("Can register type converters only for annotations which are option detail annotations");
                }
            }

            @Override
            public String toString() {
                return "valid type converter registration";
            }
        });
    }

    @Nullable
    LogManager getLogger() {
        return this.logger;
    }

    Configuration(ImmutableMap<String, String> pProperties, ImmutableMap<String, Path> pSources, String pPrefix, ImmutableMap<Class<?>, TypeConverter> pConverters, Set<String> pUnusedProperties, Set<String> pDeprecatedProperties, @Nullable LogManager pLogger) {
        Preconditions.checkNotNull(pProperties);
        Preconditions.checkNotNull(pSources);
        Preconditions.checkNotNull(pPrefix);
        assert (((ImmutableSet)pProperties.keySet()).equals(pSources.keySet()));
        this.properties = pProperties;
        this.sources = pSources;
        this.prefix = pPrefix.isEmpty() ? "" : pPrefix + ".";
        this.converters = Preconditions.checkNotNull(pConverters);
        this.unusedProperties = Preconditions.checkNotNull(pUnusedProperties);
        this.deprecatedProperties = Preconditions.checkNotNull(pDeprecatedProperties);
        this.logger = pLogger;
    }

    public void enableLogging(LogManager pLogger) {
        Preconditions.checkState(this.logger == null, "Logging already enabled.");
        this.logger = Preconditions.checkNotNull(pLogger);
    }

    @Nullable
    public String getProperty(String key) {
        Preconditions.checkNotNull(key);
        String result = this.properties.get(this.prefix + key);
        this.unusedProperties.remove(this.prefix + key);
        if (result == null && !this.prefix.isEmpty()) {
            result = this.properties.get(key);
            this.unusedProperties.remove(key);
        }
        return result;
    }

    public boolean hasProperty(String key) {
        Preconditions.checkNotNull(key);
        return this.properties.containsKey(this.prefix + key) || this.properties.containsKey(key);
    }

    public Set<String> getUnusedProperties() {
        return Collections.unmodifiableSet(this.unusedProperties);
    }

    public Set<String> getDeprecatedProperties() {
        return Collections.unmodifiableSet(this.deprecatedProperties);
    }

    public String asPropertiesString() {
        String[] lines = new String[this.properties.size()];
        int i = 0;
        for (Map.Entry entry : this.properties.entrySet()) {
            lines[i++] = (String)entry.getKey() + " = " + (String)entry.getValue();
        }
        Arrays.sort(lines, String.CASE_INSENSITIVE_ORDER);
        StringBuffer sb = new StringBuffer();
        for (String line : lines) {
            sb.append(line);
            sb.append('\n');
        }
        return sb.toString();
    }

    public void inject(Object obj) throws InvalidConfigurationException {
        this.inject(obj, obj.getClass());
    }

    public void recursiveInject(Object obj) throws InvalidConfigurationException {
        Class<?> cls = obj.getClass();
        Preconditions.checkNotNull(cls.getAnnotation(Options.class), "Class " + cls.getName() + " must have @Options annotation.");
        do {
            if (!cls.isAnnotationPresent(Options.class)) continue;
            this.inject(obj, cls);
        } while ((cls = cls.getSuperclass()) != null);
    }

    public void inject(Object obj, Class<?> cls) throws InvalidConfigurationException {
        Field[] fields;
        Preconditions.checkNotNull(obj);
        Preconditions.checkNotNull(cls);
        Preconditions.checkArgument(cls.isAssignableFrom(obj.getClass()));
        Options options = cls.getAnnotation(Options.class);
        Preconditions.checkNotNull(options, "Class " + cls.getName() + " must have @Options annotation.  If you used inject(Object), try" + " inject(Object, Class) instead.");
        for (Field field : fields = cls.getDeclaredFields()) {
            field.setAccessible(true);
        }
        Method[] methods = cls.getDeclaredMethods();
        for (Method method : methods) {
            method.setAccessible(true);
        }
        try {
            for (AccessibleObject accessibleObject : fields) {
                if (!accessibleObject.isAnnotationPresent(Option.class)) continue;
                this.setOptionValueForField(obj, (Field)accessibleObject, options);
            }
            for (AccessibleObject accessibleObject : methods) {
                if (!accessibleObject.isAnnotationPresent(Option.class)) continue;
                this.setOptionValueForMethod(obj, (Method)accessibleObject, options);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <T> void setOptionValueForField(Object obj, Field field, Options options) throws InvalidConfigurationException, IllegalAccessException {
        block10: {
            Object defaultValue;
            block9: {
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new UnsupportedOperationException("@Option is not allowed on static members");
                }
                if (Modifier.isFinal(field.getModifiers())) {
                    throw new UnsupportedOperationException("@Option is not allowed on final fields because Java doesn't guarantee visibility of new value");
                }
                defaultValue = null;
                try {
                    defaultValue = field.get(obj);
                }
                catch (IllegalArgumentException e) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)"Type checks above were not successful apparently.");
                }
            }
            Object typedDefaultValue = defaultValue;
            Class<?> type = field.getType();
            Type genericType = field.getGenericType();
            Option option = field.getAnnotation(Option.class);
            String name = this.getOptionName(options, field, option);
            Object value = this.getValue(name, typedDefaultValue, type, genericType, option, field);
            if (value == defaultValue) {
                if (this.logger != null) {
                    this.logger.log(Level.CONFIG, "Option:", name, "Class:", field.getDeclaringClass().getName(), "field:", field.getName(), "value: <DEFAULT>");
                }
                return;
            }
            if (this.logger != null) {
                this.logger.log(Level.CONFIG, "Option:", name, "Class:", field.getDeclaringClass().getName(), "field:", field.getName(), "value:", value);
            }
            try {
                field.set(obj, value);
            }
            catch (IllegalArgumentException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)"Type checks above were not successful apparently.");
            }
        }
    }

    private void setOptionValueForMethod(Object obj, Method method, Options options) throws InvalidConfigurationException, IllegalAccessException {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new UnsupportedOperationException("@Option is not allowed on static members");
        }
        String exception = Classes.verifyDeclaredExceptions(method, InvalidConfigurationException.class);
        if (exception != null) {
            throw new UnsupportedOperationException("Method with @Option may not throw " + exception);
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length != 1) {
            throw new UnsupportedOperationException("Method with @Option must have exactly one parameter!");
        }
        Class<?> type = parameters[0];
        Type genericType = method.getGenericParameterTypes()[0];
        Option option = method.getAnnotation(Option.class);
        String name = this.getOptionName(options, method, option);
        Object value = this.getValue(name, null, type, genericType, option, method);
        if (this.logger != null) {
            this.logger.log(Level.CONFIG, "Option:", name, "Class:", method.getDeclaringClass().getName(), "method:", method.getName(), "value:", value);
        }
        try {
            method.invoke(obj, value);
        }
        catch (IllegalArgumentException e) {
            assert (false) : "Type checks above were not successful apparently.";
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalArgumentException) {
                throw new InvalidConfigurationException("Invalid value in configuration file: \"" + name + " = " + value + '\"' + (t.getMessage() != null ? " (" + t.getMessage() + ")" : ""), t);
            }
            Throwables.propagateIfPossible(t, InvalidConfigurationException.class);
            throw new Classes.UnexpectedCheckedException("configuration injection in method " + method, t);
        }
    }

    private String getOptionName(Options options, Member member, Option option) {
        String name;
        String prefix = options.prefix();
        if (!prefix.isEmpty()) {
            prefix = prefix + ".";
        }
        if ((name = option.name()).isEmpty()) {
            name = member.getName();
        }
        return prefix + name;
    }

    @Nullable
    private <T> Object getValue(String optionName, T defaultValue, Class<T> type, Type genericType, Option option, AnnotatedElement member) throws UnsupportedOperationException, InvalidConfigurationException {
        Object value;
        String valueStr = this.getValueString(optionName, option, type.isEnum());
        Annotation secondaryOption = this.getSecondaryAnnotation(member);
        if (valueStr != null) {
            if (secureMode && !option.secure()) {
                throw new InvalidConfigurationException("Configuration option " + optionName + " was specified, but is not allowed in secure mode.");
            }
            value = this.convertValue(optionName, valueStr, type, genericType, secondaryOption);
            if (member.isAnnotationPresent(Deprecated.class)) {
                this.deprecatedProperties.add(optionName);
            }
        } else {
            if (option.required()) {
                throw new InvalidConfigurationException("Required configuration option " + optionName + " is missing.");
            }
            value = this.convertDefaultValue(optionName, defaultValue, type, genericType, secondaryOption);
        }
        if (this.exportUsedOptions) {
            this.printOptionInfos(type, option, optionName, valueStr, defaultValue);
        }
        return value;
    }

    @Nullable
    private String getValueString(String name, Option option, boolean alwaysUppercase) throws InvalidConfigurationException {
        String[] allowedValues;
        String valueStr = Configuration.trimToNull(this.getProperty(name));
        if (valueStr == null) {
            return null;
        }
        if (alwaysUppercase || option.toUppercase()) {
            valueStr = valueStr.toUpperCase();
        }
        if ((allowedValues = option.values()).length > 0 && !Arrays.asList(allowedValues).contains(valueStr)) {
            throw new InvalidConfigurationException("Invalid value in configuration file: \"" + name + " = " + valueStr + '\"' + " (not listed as allowed value)");
        }
        String regexp = option.regexp();
        if (!regexp.isEmpty() && !valueStr.matches(regexp)) {
            throw new InvalidConfigurationException("Invalid value in configuration file: \"" + name + " = " + valueStr + '\"' + " (does not match RegExp \"" + regexp + "\")");
        }
        return valueStr;
    }

    private Annotation getSecondaryAnnotation(AnnotatedElement element) {
        Annotation result = null;
        for (Annotation a : element.getDeclaredAnnotations()) {
            if (!a.annotationType().isAnnotationPresent(OptionDetailAnnotation.class)) continue;
            if (result != null) {
                throw new UnsupportedOperationException("Both " + result + " and " + a + " are present at " + element.toString());
            }
            result = a;
        }
        return result;
    }

    private void checkApplicability(Annotation annotation, Class<?> optionType) throws UnsupportedOperationException {
        if (annotation == null) {
            return;
        }
        List<Class<?>> applicableTypes = Arrays.asList(annotation.annotationType().getAnnotation(OptionDetailAnnotation.class).applicableTo());
        if (!applicableTypes.contains(optionType)) {
            throw new UnsupportedOperationException("Annotation " + annotation + " is not applicable for options of type " + optionType.getCanonicalName());
        }
    }

    private void printOptionInfos(Class<?> type, Option option, String name, String valueStr, Object defaultValue) {
        StringBuilder optionInfo = new StringBuilder(OptionCollector.formatText(option.description()));
        optionInfo.append(name + "\n");
        if (type.isArray()) {
            optionInfo.append("    default value:  " + Arrays.deepToString((Object[])defaultValue) + "\n");
        } else if (type.equals(String.class)) {
            optionInfo.append("    default value:  '" + defaultValue + "'\n");
        } else {
            optionInfo.append("    default value:  " + defaultValue + "\n");
        }
        if (valueStr != null) {
            optionInfo.append("--> used value:     " + valueStr + "\n");
        }
        System.out.println(optionInfo.toString());
    }

    private <T> Object convertValue(String optionName, String valueStr, Class<?> pType, Type genericType, Annotation secondaryOption) throws UnsupportedOperationException, InvalidConfigurationException {
        Class<?> componentType;
        Class<? extends Iterable<?>> collectionClass = COLLECTIONS.get(pType);
        if (collectionClass == null && !pType.isArray()) {
            Class<?> type = Primitives.wrap(pType);
            this.checkApplicability(secondaryOption, type);
            return this.convertSingleValue(optionName, valueStr, type, genericType, secondaryOption);
        }
        ParameterizedType componentGenericType = null;
        if (pType.isArray()) {
            componentType = pType.getComponentType();
        } else {
            Pair<Class<?>, ParameterizedType> p = Classes.getComponentType(genericType);
            componentType = p.getFirst();
            componentGenericType = p.getSecond();
        }
        componentType = Primitives.wrap(componentType);
        this.checkApplicability(secondaryOption, componentType);
        List<?> values = this.convertMultipleValues(optionName, valueStr, componentType, componentGenericType, secondaryOption);
        if (pType.isArray()) {
            Class<?> arrayComponentType = componentType;
            ?[] result = ObjectArrays.newArray(arrayComponentType, values.size());
            return values.toArray(result);
        }
        assert (collectionClass != null);
        if (collectionClass == EnumSet.class) {
            assert (componentType.isEnum()) : "";
            return Configuration.createEnumSetUnchecked(componentType, values);
        }
        if (componentType.isEnum() && (collectionClass == Set.class || collectionClass == ImmutableSet.class)) {
            return BaseTypeConverter.invokeStaticMethod(Sets.class, "immutableEnumSet", Iterable.class, values, optionName);
        }
        return BaseTypeConverter.invokeStaticMethod(collectionClass, "copyOf", Iterable.class, values, optionName);
    }

    private Object convertSingleValue(String optionName, String valueStr, Class<?> type, Type genericType, Annotation secondaryOption) throws InvalidConfigurationException {
        TypeConverter converter = this.getConverter(type, secondaryOption);
        return converter.convert(optionName, valueStr, type, genericType, secondaryOption, this.sources.get(optionName), MoreObjects.firstNonNull(this.logger, TestLogManager.getInstance()));
    }

    private List<?> convertMultipleValues(String optionName, String valueStr, Class<?> type, Type genericType, Annotation secondaryOption) throws InvalidConfigurationException {
        Iterable<String> values = ARRAY_SPLITTER.split(valueStr);
        ArrayList<Object> result = new ArrayList<Object>();
        for (String item : values) {
            result.add(this.convertSingleValue(optionName, item, type, genericType, secondaryOption));
        }
        return result;
    }

    private <T> Object convertDefaultValue(String optionName, T defaultValue, Class<T> type, Type genericType, Annotation secondaryOption) throws InvalidConfigurationException {
        Class<Object> innerType = type.isArray() ? type.getComponentType() : (COLLECTIONS.containsKey(type) ? Classes.getComponentType(genericType).getFirst() : type);
        innerType = Primitives.wrap(innerType);
        this.checkApplicability(secondaryOption, innerType);
        if (type == innerType) {
            TypeConverter converter = this.getConverter(type, secondaryOption);
            return converter.convertDefaultValue(optionName, defaultValue, type, genericType, secondaryOption);
        }
        return defaultValue;
    }

    private TypeConverter getConverter(Class<?> type, Annotation secondaryOption) {
        TypeConverter converter = null;
        if (secondaryOption != null) {
            converter = this.converters.get(secondaryOption.annotationType());
        }
        if (converter == null) {
            converter = this.converters.get(type);
        }
        if (converter == null) {
            converter = BaseTypeConverter.INSTANCE;
        }
        return converter;
    }

    @Nullable
    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        return Strings.emptyToNull(s.trim());
    }

    private static <T extends Enum<T>> EnumSet<?> createEnumSetUnchecked(Class<?> enumType, Collection<?> values) {
        EnumSet<?> result = EnumSet.noneOf(enumType);
        result.addAll(values);
        return result;
    }

    public String toString() {
        return "Configuration" + (!this.prefix.isEmpty() ? " with prefix " + this.prefix : "") + ": [" + Joiner.on(", ").withKeyValueSeparator("=").join(this.properties) + "]";
    }

    static {
        ImmutableMap.Builder<Class<Iterable<?>>, Class<Iterable<?>>> builder = ImmutableMap.builder();
        Configuration.putSafely(builder, EnumSet.class, EnumSet.class);
        Configuration.putSafely(builder, Iterable.class, ImmutableList.class);
        Configuration.putSafely(builder, Collection.class, ImmutableList.class);
        Configuration.putSafely(builder, List.class, ImmutableList.class);
        Configuration.putSafely(builder, Set.class, ImmutableSet.class);
        Configuration.putSafely(builder, SortedSet.class, ImmutableSortedSet.class);
        Configuration.putSafely(builder, Multiset.class, ImmutableMultiset.class);
        Configuration.putSafely(builder, ImmutableCollection.class, ImmutableList.class);
        Configuration.putSafely(builder, ImmutableList.class, ImmutableList.class);
        Configuration.putSafely(builder, ImmutableSet.class, ImmutableSet.class);
        Configuration.putSafely(builder, ImmutableSortedSet.class, ImmutableSortedSet.class);
        Configuration.putSafely(builder, ImmutableMultiset.class, ImmutableMultiset.class);
        COLLECTIONS = builder.build();
        DEFAULT_CONVERTERS = Collections.synchronizedMap(Configuration.createConverterMap());
        DEFAULT_CONVERTERS.put(Class.class, new ClassTypeConverter());
        DEFAULT_CONVERTERS.put(IntegerOption.class, new IntegerTypeConverter());
        DEFAULT_CONVERTERS.put(TimeSpanOption.class, new TimeSpanTypeConverter());
    }
}

