/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.ClassOption;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;

public class OptionCollector {
    private static final Pattern IGNORED_CLASSES = Pattern.compile("^org\\.sosy_lab\\.common\\..*Test(\\$.*)?$");
    private static final int CHARS_PER_LINE = 75;
    private final Set<String> errorMessages = new LinkedHashSet<String>();
    private final String sourcePath;
    private final boolean verbose;
    private final SortedMap<String, Pair<String, String>> options = new TreeMap<String, Pair<String, String>>();

    public static void main(String[] args) {
        boolean verbose = false;
        for (String arg : args) {
            if (!"-v".equals(arg) && !"-verbose".equals(arg)) continue;
            verbose = true;
        }
        System.out.println(OptionCollector.getCollectedOptions(verbose));
    }

    public static String getCollectedOptions(boolean verbose) {
        return new OptionCollector(verbose).getCollectedOptions();
    }

    public OptionCollector(boolean pVerbose) {
        this.verbose = pVerbose;
        this.sourcePath = OptionCollector.getSourcePath();
    }

    public String getCollectedOptions() {
        PrintStream originalStdOut = System.out;
        System.setOut(System.err);
        boolean appendCommonOptions = true;
        for (Class<?> c : this.getClasses()) {
            if (c.isAnnotationPresent(Options.class)) {
                this.collectOptions(c);
            }
            if (!c.getPackage().getName().startsWith("org.sosy_lab.common")) continue;
            appendCommonOptions = false;
        }
        System.setOut(originalStdOut);
        for (String error : this.errorMessages) {
            System.err.println(error);
        }
        StringBuilder content = new StringBuilder();
        if (appendCommonOptions) {
            try {
                URL resource = Resources.getResource("org/sosy_lab/common/ConfigurationOptions.txt");
                content.append(Resources.toString(resource, StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                System.err.println("Could not find options of org.sosy-lab.common classes: " + e.getMessage());
            }
        }
        String description = "";
        for (Pair<String, String> descriptionAndInfo : this.options.values()) {
            if (descriptionAndInfo.getFirst().isEmpty() || !description.equals(descriptionAndInfo.getFirst())) {
                content.append("\n");
                content.append(descriptionAndInfo.getFirst());
                description = descriptionAndInfo.getFirst();
            }
            content.append(descriptionAndInfo.getSecond());
        }
        return content.toString();
    }

    private static String getSourcePath() {
        Iterator<URL> resources = OptionCollector.getClassLoaderResources();
        while (resources.hasNext()) {
            try {
                File file = new File(resources.next().toURI());
                String testPath = file.toString().substring(0, file.toString().length() - 3);
                if (!new File(testPath + "src/org/sosy_lab").isDirectory()) continue;
                return testPath + "src/";
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
        return "";
    }

    @Nullable
    private static Iterator<URL> getClassLoaderResources() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        try {
            return Iterators.forEnumeration(classLoader.getResources(""));
        }
        catch (IOException e) {
            System.err.println("Could not get recources of classloader.");
            return Collections.emptyIterator();
        }
    }

    private void collectOptions(Class<?> c) {
        String classSource = this.getContentOfFile(c);
        for (Field field : c.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Option.class)) continue;
            this.getOptionsDescription(c);
            String optionName = OptionCollector.getOptionName(c, field);
            String defaultValue = OptionCollector.getDefaultValue(field, classSource);
            StringBuilder optionInfo = new StringBuilder();
            optionInfo.append(optionName);
            if (this.verbose) {
                optionInfo.append("\n  field:    " + field.getName() + "\n");
                optionInfo.append("  class:    " + field.getDeclaringClass().toString().substring(6) + "\n");
                optionInfo.append("  type:     " + field.getType().getSimpleName() + "\n");
                optionInfo.append("  default value: ");
                if (!defaultValue.isEmpty()) {
                    optionInfo.append(defaultValue);
                } else {
                    optionInfo.append("not available");
                }
            } else if (!defaultValue.isEmpty()) {
                optionInfo.append(" = " + defaultValue);
            } else {
                optionInfo.append(" = no default value");
            }
            optionInfo.append("\n");
            optionInfo.append(OptionCollector.getAllowedValues(field, this.verbose));
            if (this.options.containsKey(optionName)) {
                String commonOptionInfo;
                Pair oldValues = (Pair)this.options.get(optionName);
                String description = OptionCollector.getOptionDescription(field);
                if (!description.equals(oldValues.getFirst())) {
                    description = description + (String)oldValues.getFirst();
                }
                if (!(commonOptionInfo = optionInfo.toString()).equals(oldValues.getSecond())) {
                    commonOptionInfo = commonOptionInfo + (String)oldValues.getSecond();
                }
                this.options.put(optionName, Pair.of(description, commonOptionInfo));
                continue;
            }
            this.options.put(optionName, Pair.of(OptionCollector.getOptionDescription(field), optionInfo.toString()));
        }
    }

    private static String getOptionDescription(Field field) {
        Option option = field.getAnnotation(Option.class);
        String text = option.description();
        if (field.getAnnotation(Deprecated.class) != null) {
            text = "DEPRECATED: " + text;
        }
        return OptionCollector.formatText(text);
    }

    private void getOptionsDescription(Class<?> c) {
        Options classOption;
        if (c.isAnnotationPresent(Options.class) && !(classOption = c.getAnnotation(Options.class)).prefix().isEmpty() && !classOption.description().isEmpty()) {
            this.options.put(classOption.prefix(), Pair.of(OptionCollector.formatText(classOption.description()), ""));
        }
    }

    public static String formatText(String text) {
        return OptionCollector.formatText(text, "# ", true);
    }

    public static String formatText(String text, String lineStart, boolean useLineStartInFirstLine) {
        Preconditions.checkNotNull(lineStart);
        if (text.isEmpty()) {
            return text;
        }
        String[] lines = text.split("\n");
        ArrayList<String> splittedLines = new ArrayList<String>();
        for (String line : lines) {
            while (line.length() > 75) {
                String start;
                int spaceIndex = line.lastIndexOf(" ", 75);
                if (spaceIndex == -1) {
                    spaceIndex = line.indexOf(" ");
                }
                if (spaceIndex == -1) {
                    spaceIndex = line.length() - 1;
                }
                if (!(start = line.substring(0, spaceIndex)).isEmpty()) {
                    splittedLines.add(start);
                }
                line = line.substring(spaceIndex + 1);
            }
            splittedLines.add(line);
        }
        if (((String)splittedLines.get(splittedLines.size() - 1)).isEmpty()) {
            splittedLines.remove(splittedLines.size() - 1);
        }
        StringBuilder formattedLines = new StringBuilder();
        if (!useLineStartInFirstLine && splittedLines.size() > 0) {
            formattedLines.append((String)splittedLines.remove(0));
            formattedLines.append('\n');
        }
        for (String line : splittedLines) {
            formattedLines.append(lineStart);
            formattedLines.append(line);
            formattedLines.append('\n');
        }
        return formattedLines.toString();
    }

    private static String getOptionName(Class<?> c, Field field) {
        Option option;
        Options classOption;
        String optionName = "";
        if (c.isAnnotationPresent(Options.class) && !(classOption = c.getAnnotation(Options.class)).prefix().isEmpty()) {
            optionName = optionName + classOption.prefix() + ".";
        }
        optionName = (option = field.getAnnotation(Option.class)).name().isEmpty() ? optionName + field.getName() : optionName + option.name();
        return optionName;
    }

    private static String getDefaultValue(Field field, String classSource) {
        String fieldString = Modifier.toString(field.getModifiers());
        String typeString = field.getGenericType().toString();
        if (typeString.matches(".*<.*>")) {
            typeString = typeString.replaceAll("^[^<]*\\.", "");
            typeString = typeString.replaceAll("<[^\\?][^<]*\\.", "<");
            typeString = typeString.replaceAll("<\\?[^<]*\\.", "<\\\\?\\\\s+extends\\\\s+");
        } else {
            typeString = field.getType().getSimpleName();
        }
        typeString = typeString.replaceAll("[^<>, ]*\\$([^<>, $]*)", "$1");
        fieldString = fieldString + "\\s+" + typeString;
        fieldString = fieldString + "\\s+" + field.getName();
        String defaultValue = OptionCollector.getDefaultValueFromContent(classSource, fieldString);
        if (field.getType().isEnum()) {
            if (defaultValue.isEmpty()) {
                String type = field.getType().toString();
                type = type.substring(type.lastIndexOf(".") + 1).replace("$", ".");
                fieldString = Modifier.toString(field.getModifiers()) + "\\s+" + type + "\\s+" + field.getName();
                defaultValue = OptionCollector.getDefaultValueFromContent(classSource, fieldString);
            }
            if (defaultValue.contains(".")) {
                defaultValue = defaultValue.substring(defaultValue.lastIndexOf(".") + 1);
            }
        }
        if (defaultValue.equals("null")) {
            defaultValue = "";
        }
        return defaultValue;
    }

    private String getContentOfFile(Class<?> cls) {
        String filename = cls.toString().substring(6).replace(".", "/");
        if (filename.contains("$")) {
            filename = filename.substring(0, filename.indexOf("$"));
        }
        filename = this.sourcePath + filename + ".java";
        try {
            return Files.toString(new File(filename), Charset.defaultCharset());
        }
        catch (IOException e) {
            this.errorMessages.add("INFO: Could not read sourcefiles for getting the default values.");
            return "";
        }
    }

    private static String getDefaultValueFromContent(String content, String fieldPattern) {
        String defaultValue = "";
        String[] splitted = content.split(fieldPattern);
        if (splitted.length > 1) {
            String rest = splitted[1];
            defaultValue = rest.substring(0, rest.indexOf(";")).trim();
            if (defaultValue.startsWith("=")) {
                defaultValue = defaultValue.substring(1).trim();
                while (defaultValue.contains("/*")) {
                    defaultValue = defaultValue.substring(0, defaultValue.indexOf("/*")) + defaultValue.substring(defaultValue.indexOf("*/") + 2);
                }
                if (defaultValue.contains("//")) {
                    defaultValue = defaultValue.substring(0, defaultValue.indexOf("//"));
                }
                defaultValue = OptionCollector.stripSurroundingFunctionCall(defaultValue, "new File");
                defaultValue = OptionCollector.stripSurroundingFunctionCall(defaultValue, "Paths.get");
                defaultValue = OptionCollector.stripSurroundingFunctionCall(defaultValue, "new Path");
                defaultValue = OptionCollector.stripSurroundingFunctionCall(defaultValue, "Pattern.compile");
                defaultValue = OptionCollector.stripSurroundingFunctionCall(defaultValue, "PathTemplate.ofFormatString");
                if ((defaultValue = OptionCollector.stripSurroundingFunctionCall(defaultValue, "PathCounterTemplate.ofFormatString")).startsWith("TimeSpan.ofNanos(")) {
                    defaultValue = defaultValue.substring("TimeSpan.ofNanos(".length(), defaultValue.length() - 1) + "ns";
                }
                if (defaultValue.startsWith("TimeSpan.ofMillis(")) {
                    defaultValue = defaultValue.substring("TimeSpan.ofMillis(".length(), defaultValue.length() - 1) + "ms";
                }
                if (defaultValue.startsWith("TimeSpan.ofSeconds(")) {
                    defaultValue = defaultValue.substring("TimeSpan.ofSeconds(".length(), defaultValue.length() - 1) + "s";
                }
                if (defaultValue.startsWith("ImmutableSet.of(")) {
                    defaultValue = "{" + defaultValue.substring("ImmutableSet.of(".length(), defaultValue.length() - 1) + "}";
                }
                if (defaultValue.startsWith("ImmutableList.of(")) {
                    defaultValue = "[" + defaultValue.substring("ImmutableList.of(".length(), defaultValue.length() - 1) + "]";
                }
            }
        } else {
            String stringSetFieldPattern = fieldPattern.replace("\\s+Set\\s+", "\\s+Set<String>\\s+");
            if (content.contains(stringSetFieldPattern)) {
                return OptionCollector.getDefaultValueFromContent(content, stringSetFieldPattern);
            }
        }
        return defaultValue.trim();
    }

    private static String stripSurroundingFunctionCall(String s, String partToBeStripped) {
        String toBeStripped = partToBeStripped + "(";
        if (s.startsWith(toBeStripped)) {
            return s.substring(toBeStripped.length(), s.length() - 1);
        }
        return s;
    }

    private static String getAllowedValues(Field field, boolean verbose) {
        String allowedValues = "";
        Class<?> type = field.getType();
        if (type.isEnum()) {
            ?[] enums = type.getEnumConstants();
            Object[] enumTitles = new String[enums.length];
            for (int i = 0; i < enums.length; ++i) {
                enumTitles[i] = ((Enum)enums[i]).name();
            }
            allowedValues = "  enum:     " + OptionCollector.formatText(Arrays.toString(enumTitles), "             ", false);
        }
        allowedValues = allowedValues + OptionCollector.getOptionValues(field, verbose);
        allowedValues = allowedValues + OptionCollector.getClassOptionValues(field, verbose);
        allowedValues = allowedValues + OptionCollector.getFileOptionValues(field, verbose);
        allowedValues = allowedValues + OptionCollector.getIntegerOptionValues(field, verbose);
        allowedValues = allowedValues + OptionCollector.getTimeSpanOptionValues(field, verbose);
        return allowedValues;
    }

    private static String getOptionValues(Field field, boolean verbose) {
        Option option = field.getAnnotation(Option.class);
        assert (option != null);
        String str = "";
        if (option.values().length != 0) {
            str = str + "  allowed values: " + Arrays.toString(option.values()) + "\n";
        }
        if (verbose && !option.regexp().isEmpty()) {
            str = str + "  regexp:   " + option.regexp() + "\n";
        }
        if (verbose && option.toUppercase()) {
            str = str + "  uppercase: true\n";
        }
        return str;
    }

    private static String getClassOptionValues(Field field, boolean verbose) {
        ClassOption classOption = field.getAnnotation(ClassOption.class);
        String str = "";
        if (classOption != null && verbose && classOption.packagePrefix().length != 0) {
            str = str + "  packagePrefix: " + Joiner.on(", ").join(classOption.packagePrefix()) + "\n";
        }
        return str;
    }

    private static String getFileOptionValues(Field field, boolean verbose) {
        FileOption fileOption = field.getAnnotation(FileOption.class);
        String str = "";
        if (fileOption != null && verbose) {
            str = str + "  type of file: " + (Object)((Object)fileOption.value()) + "\n";
        }
        return str;
    }

    private static String getIntegerOptionValues(Field field, boolean verbose) {
        IntegerOption intOption = field.getAnnotation(IntegerOption.class);
        String str = "";
        if (intOption != null && verbose) {
            str = intOption.min() == Long.MIN_VALUE ? str + "  min:      Long.MIN_VALUE\n" : str + "  min:      " + intOption.min() + "\n";
            str = intOption.max() == Long.MAX_VALUE ? str + "  max:      Long.MAX_VALUE\n" : str + "  max:      " + intOption.max() + "\n";
        }
        return str;
    }

    private static String getTimeSpanOptionValues(Field field, boolean verbose) {
        TimeSpanOption timeSpanOption = field.getAnnotation(TimeSpanOption.class);
        String str = "";
        if (timeSpanOption != null && verbose) {
            str = str + "  code unit:     " + (Object)((Object)timeSpanOption.codeUnit()) + "\n";
            str = str + "  default unit:  " + (Object)((Object)timeSpanOption.defaultUserUnit()) + "\n";
            str = timeSpanOption.min() == Long.MIN_VALUE ? str + "  time min:      Long.MIN_VALUE\n" : str + "  time min:      " + timeSpanOption.min() + "\n";
            str = timeSpanOption.max() == Long.MAX_VALUE ? str + "  time max:      Long.MAX_VALUE\n" : str + "  time max:      " + timeSpanOption.max() + "\n";
        }
        return str;
    }

    private List<Class<?>> getClasses() {
        Iterator<URL> resources = OptionCollector.getClassLoaderResources();
        ArrayList classes = new ArrayList();
        while (resources.hasNext()) {
            URL url = resources.next();
            try {
                File file = new File(url.toURI());
                this.collectClasses(file, "", classes);
            }
            catch (URISyntaxException e) {
                System.err.println("Ignoring files in " + url);
            }
        }
        return classes;
    }

    private void collectClasses(File directory, String packageName, List<Class<?>> classes) {
        if (directory.exists()) {
            Object[] files = directory.listFiles();
            Arrays.sort(files);
            for (Object file : files) {
                String nameOfClass;
                String fileName = ((File)file).getName();
                if (((File)file).isDirectory() && !fileName.startsWith(".svn")) {
                    String newPackage = packageName.isEmpty() ? fileName : packageName + "." + fileName;
                    this.collectClasses((File)file, newPackage, classes);
                    continue;
                }
                if (!fileName.endsWith(".class") || IGNORED_CLASSES.matcher(nameOfClass = packageName + '.' + fileName.substring(0, fileName.length() - 6)).matches()) continue;
                try {
                    Class<?> foundClass = Class.forName(nameOfClass);
                    if (Modifier.isInterface(foundClass.getModifiers())) continue;
                    classes.add(foundClass);
                }
                catch (ClassNotFoundException e) {
                }
                catch (UnsatisfiedLinkError e) {
                    this.errorMessages.add("INFO: Could not load '" + fileName + "' for getting Option annotations: " + e.getMessage());
                }
                catch (NoClassDefFoundError e) {
                    return;
                }
                catch (ExceptionInInitializerError e) {
                    this.errorMessages.add("INFO: Cloud not load '" + fileName + "' for getting Option annotations because of exception in class initializer: " + Throwables.getStackTraceAsString(e.getCause()));
                }
            }
        }
    }
}

