/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.CharSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;

class Parser {
    private static final Pattern OPTION_NAME = Pattern.compile("^[a-zA-Z0-9_+-]+(\\.[a-zA-Z0-9_+-]+)*$");

    private Parser() {
    }

    static Pair<Map<String, String>, Map<String, Path>> parse(Path file, @Nullable String basePath) throws IOException, InvalidConfigurationException {
        return Parser.parse(file, basePath, Collections.emptySet());
    }

    private static Pair<Map<String, String>, Map<String, Path>> parse(Path file, @Nullable String basePath, Set<String> includeStack) throws IOException, InvalidConfigurationException {
        if (!file.isAbsolute() && !Strings.isNullOrEmpty(basePath)) {
            file = Paths.get(basePath, file.getPath());
        }
        Files.checkReadableFile(file);
        includeStack = new HashSet<String>(includeStack);
        boolean newFile = includeStack.add(file.toAbsolutePath().getPath());
        if (!newFile) {
            throw new InvalidConfigurationFileException("Circular inclusion of file " + file.toAbsolutePath());
        }
        try (BufferedReader r = file.asCharSource(StandardCharsets.UTF_8).openBufferedStream();){
            Pair<Map<String, String>, Map<String, Path>> pair = Parser.parse(r, file.getParent().getPath(), file.getPath(), includeStack);
            return pair;
        }
    }

    static Pair<Map<String, String>, Map<String, Path>> parse(CharSource source, @Nullable String basePath, String sourceName) throws IOException, InvalidConfigurationException {
        try (BufferedReader r = source.openBufferedStream();){
            Pair<Map<String, String>, Map<String, Path>> pair = Parser.parse(r, basePath, sourceName, Collections.emptySet());
            return pair;
        }
    }

    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="performance irrelevant compared to I/O, String much more convenient")
    private static Pair<Map<String, String>, Map<String, Path>> parse(BufferedReader r, @Nullable String basePath, String source, Set<String> includeStack) throws IOException, InvalidConfigurationException {
        String line;
        Preconditions.checkNotNull(source);
        int lineno = 0;
        String currentPrefix = "";
        String currentOptionName = null;
        String currentValue = null;
        HashMap<String, String> definedOptions = new HashMap<String, String>();
        HashMap<String, String> includedOptions = new HashMap<String, String>();
        HashMap<String, Path> includedOptionsSources = new HashMap<String, Path>();
        while ((line = r.readLine()) != null) {
            ++lineno;
            String fullLine = line = line.trim();
            assert (currentValue == null == (currentOptionName == null));
            if (currentValue != null) {
                currentValue = currentValue + line;
            } else {
                if (line.isEmpty() || line.startsWith("# ") || line.startsWith("//")) continue;
                if (line.startsWith("#")) {
                    if (!line.startsWith("#include")) {
                        throw new InvalidConfigurationFileException("Illegal parser directive", lineno, source, fullLine);
                    }
                    if ((line = line.substring("#include".length()).trim()).isEmpty()) {
                        throw new InvalidConfigurationFileException("Include without filename", lineno, source, fullLine);
                    }
                    Pair<Map<String, String>, Map<String, Path>> includedContent = Parser.parse(Paths.get(line, new String[0]), basePath, includeStack);
                    includedOptions.putAll(includedContent.getFirst());
                    includedOptionsSources.putAll(includedContent.getSecond());
                    continue;
                }
                if (line.startsWith("[") && line.endsWith("]")) {
                    line = line.substring(1, line.length() - 1);
                    if ((line = line.trim()).isEmpty()) {
                        currentPrefix = "";
                        continue;
                    }
                    if (!OPTION_NAME.matcher(line).matches()) {
                        throw new InvalidConfigurationFileException("Invalid category \"" + line + "\"", lineno, source, fullLine);
                    }
                    currentPrefix = line + ".";
                    continue;
                }
                if (line.length() < 3) {
                    throw new InvalidConfigurationFileException("Illegal content", lineno, source, fullLine);
                }
                String[] bits = line.split("=", 2);
                if (bits.length != 2) {
                    throw new InvalidConfigurationFileException("Missing key-value separator", lineno, source, fullLine);
                }
                currentOptionName = bits[0].trim();
                if (!OPTION_NAME.matcher(currentOptionName).matches()) {
                    throw new InvalidConfigurationFileException("Invalid option \"" + currentOptionName + "\"", lineno, source, fullLine);
                }
                if (definedOptions.containsKey(currentPrefix + currentOptionName)) {
                    throw new InvalidConfigurationFileException("Duplicate option \"" + currentPrefix + currentOptionName + "\"", lineno, source, fullLine);
                }
                currentValue = bits[1].trim();
            }
            assert (currentValue != null && currentOptionName != null);
            if (currentValue.endsWith("\\")) {
                currentValue = currentValue.substring(0, currentValue.length() - 1);
                continue;
            }
            definedOptions.put(currentPrefix + currentOptionName, currentValue);
            currentValue = null;
            currentOptionName = null;
        }
        assert (currentValue == null == (currentOptionName == null));
        if (currentValue != null) {
            definedOptions.put(currentPrefix + currentOptionName, currentValue);
        }
        includedOptions.putAll(definedOptions);
        Path thisSource = Paths.get(source, new String[0]);
        for (String name : definedOptions.keySet()) {
            includedOptionsSources.put(name, thisSource);
        }
        return Pair.of(includedOptions, includedOptionsSources);
    }

    static class InvalidConfigurationFileException
    extends InvalidConfigurationException {
        private static final long serialVersionUID = 8146907093750189669L;

        private InvalidConfigurationFileException(String msg, int lineno, String source, String line) {
            super(msg + " in line " + lineno + " of " + source + ": " + line);
        }

        private InvalidConfigurationFileException(String msg) {
            super(msg);
        }
    }
}

