/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.configuration.converters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;

@Options
public class FileTypeConverter
implements TypeConverter {
    private static final ImmutableSet<Class<?>> SUPPORTED_TYPES = ImmutableSet.of(File.class, Path.class, PathTemplate.class, PathCounterTemplate.class);
    private static final String TEMP_DIR = StandardSystemProperty.JAVA_IO_TMPDIR.value() + File.separator;
    @Option(secure=true, name="output.path", description="directory to put all output files in")
    private String outputDirectory = "output/";
    private final Path outputPath;
    @Option(secure=true, name="output.disable", description="disable all default output files\n(any explicitly given file will still be written)")
    private boolean disableOutput = false;
    @Option(description="base directory for all input & output files\n(except for the configuration file itself)")
    private String rootDirectory = ".";
    private final Path rootPath;
    private final boolean safePathsOnly;

    @Deprecated
    public FileTypeConverter(Configuration config) throws InvalidConfigurationException {
        this(config, false);
    }

    protected FileTypeConverter(Configuration config, boolean pSafePathsOnly) throws InvalidConfigurationException {
        this.safePathsOnly = pSafePathsOnly;
        config.inject(this, FileTypeConverter.class);
        this.rootPath = this.checkSafePath(Paths.get(this.rootDirectory, new String[0]), "rootDirectory");
        this.outputPath = this.checkSafePath(this.rootPath.resolve(this.outputDirectory), "output.path");
    }

    public static FileTypeConverter create(Configuration config) throws InvalidConfigurationException {
        return new FileTypeConverter(config, false);
    }

    public static FileTypeConverter createWithSafePathsOnly(Configuration config) throws InvalidConfigurationException {
        return new FileTypeConverter(config, true);
    }

    @VisibleForTesting
    Path checkSafePath(Path pPath, String optionName) throws InvalidConfigurationException {
        if (!this.safePathsOnly) {
            return pPath;
        }
        String path = pPath.getPath();
        if (pPath.isAbsolute()) {
            if (pPath.getPath().startsWith(TEMP_DIR)) {
                path = path.substring(TEMP_DIR.length());
            } else {
                throw new InvalidConfigurationException("The option " + optionName + " specifies the path '" + pPath + "' that is forbidden in safe mode because it is absolute.");
            }
        }
        if (path.replaceAll("::", "").contains(File.pathSeparator)) {
            throw new InvalidConfigurationException("The option " + optionName + " specifies the path '" + pPath + "' that is forbidden in safe mode because it contains the character '" + File.pathSeparator + "'.");
        }
        int depth = 0;
        Iterator<String> i$ = Splitter.on(File.separator).split(path).iterator();
        while (i$.hasNext()) {
            String component;
            switch (component = i$.next()) {
                case "": 
                case ".": {
                    break;
                }
                case "..": {
                    --depth;
                    break;
                }
                default: {
                    ++depth;
                }
            }
            if (depth >= 0) continue;
            throw new InvalidConfigurationException("The option " + optionName + " specifies the path '" + pPath + "' that is forbidden in safe mode" + " because it is not below the current directory.");
        }
        return pPath;
    }

    public String getOutputDirectory() {
        return this.outputPath.toString();
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    private void checkApplicability(Class<?> type, @Nullable Annotation secondaryOption, String optionName) {
        if (!SUPPORTED_TYPES.contains(type) || !(secondaryOption instanceof FileOption)) {
            throw new UnsupportedOperationException("A FileTypeConverter can handle only options of type File and with a @FileOption annotation, but " + optionName + " does not fit.");
        }
    }

    @Override
    public Object convert(String optionName, String pValue, Class<?> pType, Type pGenericType, Annotation secondaryOption, Path pSource, LogManager logger) throws InvalidConfigurationException {
        this.checkApplicability(pType, secondaryOption, optionName);
        return this.handleFileOption(optionName, Paths.get(pValue, new String[0]), ((FileOption)secondaryOption).value(), pType, pSource);
    }

    @Override
    public <T> T convertDefaultValue(String optionName, T pDefaultValue, Class<T> pType, Type pGenericType, Annotation secondaryOption) throws InvalidConfigurationException {
        this.checkApplicability(pType, secondaryOption, optionName);
        FileOption.Type typeInfo = ((FileOption)secondaryOption).value();
        if (pDefaultValue == null) {
            if (typeInfo == FileOption.Type.REQUIRED_INPUT_FILE) {
                throw new UnsupportedOperationException("The option " + optionName + " specifies a required input file," + " but the option is neither required nor has a default value.");
            }
            return null;
        }
        if (this.disableOutput && typeInfo == FileOption.Type.OUTPUT_FILE) {
            return null;
        }
        Path defaultValue = pType.equals(File.class) ? Paths.get((File)pDefaultValue) : (pType.equals(PathTemplate.class) ? Paths.get(((PathTemplate)pDefaultValue).getTemplate(), new String[0]) : (pType.equals(PathCounterTemplate.class) ? Paths.get(((PathCounterTemplate)pDefaultValue).getTemplate(), new String[0]) : (Path)pDefaultValue));
        Object value = this.handleFileOption(optionName, defaultValue, typeInfo, pType, null);
        return (T)value;
    }

    private Object handleFileOption(String optionName, Path file, FileOption.Type typeInfo, Class<?> targetType, Path source) throws InvalidConfigurationException {
        if (typeInfo == FileOption.Type.OUTPUT_FILE) {
            file = this.outputPath.resolve(file);
        } else if (source != null) {
            Path baseDir = source.getParent();
            if (baseDir != null) {
                file = baseDir.resolve(file);
            }
        } else {
            file = this.rootPath.resolve(file);
        }
        this.checkSafePath(file, optionName);
        if (file.isDirectory()) {
            throw new InvalidConfigurationException("Option " + optionName + " specifies a directory instead of a file: " + file);
        }
        if (typeInfo == FileOption.Type.REQUIRED_INPUT_FILE) {
            try {
                Files.checkReadableFile(file);
            }
            catch (FileNotFoundException e) {
                throw new InvalidConfigurationException("Option " + optionName + " specifies an invalid input file: " + e.getMessage(), e);
            }
        }
        if (targetType.equals(File.class)) {
            return file.toFile();
        }
        if (targetType.equals(PathTemplate.class)) {
            return PathTemplate.ofFormatString(file.toString());
        }
        if (targetType.equals(PathCounterTemplate.class)) {
            return PathCounterTemplate.ofFormatString(file.toString());
        }
        assert (targetType.equals(Path.class));
        return file;
    }
}

