/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.Joiner;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;

public class FileSystemPath
implements Path {
    protected String path = "";
    @Nullable
    private File fileInstance = null;

    public FileSystemPath(@Nullable String path, String ... more) {
        if (path == null) {
            path = "";
        }
        if (more != null) {
            if (more.length == 0) {
                this.path = path;
            } else if (path.isEmpty() && more.length == 0) {
                this.path = "";
            } else {
                char separatorChar = File.separatorChar;
                Joiner joiner = Joiner.on(separatorChar).skipNulls();
                this.path = path.isEmpty() ? joiner.join(more) : path + separatorChar + joiner.join(more);
            }
        } else {
            this.path = path;
        }
    }

    @Override
    public File toFile() {
        if (this.fileInstance == null) {
            this.fileInstance = new File(this.path);
        }
        return this.fileInstance;
    }

    @Override
    public String getOriginalPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.toFile().getName();
    }

    @Override
    public Path toAbsolutePath() {
        return Paths.get(this.toFile().getAbsolutePath(), new String[0]);
    }

    @Override
    public String getAbsolutePath() {
        return this.toFile().getAbsolutePath();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.toFile().getCanonicalPath();
    }

    @Override
    public String[] list() {
        return this.toFile().list();
    }

    @Override
    public Path getParent() {
        return Paths.get(this.toFile().getParent(), new String[0]);
    }

    @Override
    public String getPath() {
        return this.toFile().getPath();
    }

    @Override
    public boolean isAbsolute() {
        return this.toFile().isAbsolute();
    }

    @Override
    public Path resolve(@Nullable String other) {
        return this.resolve(Paths.get(other, new String[0]));
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        return Paths.get(this.getOriginalPath(), other.getOriginalPath());
    }

    @Override
    public CharSource asCharSource(Charset charset) {
        return Files.asCharSource(this.toFile(), charset);
    }

    @Override
    public CharSink asCharSink(Charset charset, FileWriteMode ... writeModes) {
        return Files.asCharSink(this.toFile(), charset, writeModes);
    }

    @Override
    public ByteSource asByteSource() {
        return Files.asByteSource(this.toFile());
    }

    @Override
    public ByteSink asByteSink(FileWriteMode ... writeModes) {
        return Files.asByteSink(this.toFile(), writeModes);
    }

    @Override
    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    @Override
    public boolean exists() {
        return this.toFile().exists();
    }

    @Override
    public boolean isDirectory() {
        return this.toFile().isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.toFile().isFile();
    }

    @Override
    public boolean canRead() {
        return this.toFile().canRead();
    }

    @Override
    public boolean delete() {
        return this.toFile().delete();
    }

    @Override
    public void deleteOnExit() {
        this.toFile().deleteOnExit();
    }

    @Override
    public boolean mkdirs() {
        return this.toFile().mkdirs();
    }

    @Override
    public String toString() {
        return this.toFile().toString();
    }

    public int hashCode() {
        return this.toFile().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSystemPath other = (FileSystemPath)obj;
        return this.toFile().equals(other.toFile());
    }
}

