/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.FileWriteMode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;

public final class Files {
    private Files() {
    }

    public static Path createTempFile(String prefix, @Nullable String suffix, @Nullable String content) throws IOException {
        Path path = Paths.createTempPath(prefix, suffix);
        path.deleteOnExit();
        if (!Strings.isNullOrEmpty(content)) {
            try {
                Files.writeFile(path, content);
            }
            catch (IOException e) {
                Files.delete(path, e);
                throw e;
            }
        }
        return path;
    }

    public static DeleteOnCloseFile createTempFile(String prefix, @Nullable String suffix) throws IOException {
        Path tempFile = Paths.createTempPath(prefix, suffix);
        return new DeleteOnCloseFile(tempFile);
    }

    public static void delete(Path path, @Nullable IOException pendingException) throws IOException {
        boolean deletionSucceeded = path.delete();
        if (!deletionSucceeded) {
            IOException deleteException = new IOException("The file " + path + " could not be deleted.");
            if (pendingException != null) {
                pendingException.addSuppressed(deleteException);
            } else {
                throw deleteException;
            }
        }
    }

    public static void writeFile(Path file, Object content) throws IOException {
        Preconditions.checkNotNull(content);
        try (Writer w = Files.openOutputFile(file, new FileWriteMode[0]);){
            Appenders.appendTo(w, content);
        }
    }

    public static Writer openOutputFile(Path file, FileWriteMode ... options) throws IOException {
        return Files.openOutputFile(file, Charset.defaultCharset(), options);
    }

    public static Writer openOutputFile(Path file, Charset charset, FileWriteMode ... options) throws IOException {
        Preconditions.checkNotNull(charset);
        Preconditions.checkNotNull(options);
        Files.createParentDirs(file);
        return file.asCharSink(charset, options).openBufferedStream();
    }

    public static void appendToFile(Path file, Object content) throws IOException {
        Preconditions.checkNotNull(content);
        try (Writer w = Files.openOutputFile(file, FileWriteMode.APPEND);){
            Appenders.appendTo(w, content);
        }
    }

    public static void checkReadableFile(Path path) throws FileNotFoundException {
        Preconditions.checkNotNull(path);
        if (!path.exists()) {
            throw new FileNotFoundException("File " + path.toAbsolutePath() + " does not exist!");
        }
        if (!path.isFile()) {
            throw new FileNotFoundException("File " + path.toAbsolutePath() + " is not a normal file!");
        }
        if (!path.canRead()) {
            throw new FileNotFoundException("File " + path.toAbsolutePath() + " is not readable!");
        }
    }

    public static void createParentDirs(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent == null || parent.exists()) {
            return;
        }
        if (!parent.mkdirs()) {
            throw new IOException("Unable to create parent directories of " + path);
        }
    }

    public static class DeleteOnCloseFile
    implements AutoCloseable {
        private final Path path;

        private DeleteOnCloseFile(Path pFile) {
            this.path = pFile;
        }

        public Path toPath() {
            return this.path;
        }

        @Override
        public void close() throws IOException {
            this.path.delete();
        }
    }
}

