/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.io;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;

public final class PathTemplate {
    private final String template;

    private PathTemplate(String pTemplate) {
        Preconditions.checkArgument(!pTemplate.isEmpty());
        this.template = pTemplate;
    }

    public static PathTemplate ofFormatString(String pTemplate) {
        return new PathTemplate(pTemplate);
    }

    public Path getPath(Object ... args) {
        Preconditions.checkArgument(!Arrays.asList(args).contains(null), "Values for PathTemplate may not be null");
        return Paths.get(String.format(this.template, args), new String[0]);
    }

    public String getTemplate() {
        return this.template;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("template", this.template).toString();
    }
}

