/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.sosy_lab.common.AbstractMBean;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.ConsoleLogFormatter;
import org.sosy_lab.common.log.ExtendedLogRecord;
import org.sosy_lab.common.log.FileLogFormatter;
import org.sosy_lab.common.log.LogLevelFilter;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LoggingOptions;

public class BasicLogManager
implements LogManager {
    private static final int TRUNCATE_REMAINING_SIZE = 100;
    private static final Level EXCEPTION_DEBUG_LEVEL = Level.ALL;
    private static final Joiner MESSAGE_FORMAT = Joiner.on(' ').useForNull("null");
    protected final Logger logger;
    private final int truncateSize;
    @Nullable
    private final LogManagerBean mxBean;
    private final String componentName;

    public BasicLogManager(Configuration config) throws InvalidConfigurationException {
        this(config, null, null);
    }

    public BasicLogManager(Configuration config, @Nullable Handler consoleOutputHandler) throws InvalidConfigurationException {
        this(config, consoleOutputHandler, null);
    }

    public BasicLogManager(Configuration config, @Nullable Handler consoleOutputHandler, @Nullable Handler fileOutputHandler) throws InvalidConfigurationException {
        LoggingOptions options = new LoggingOptions(config);
        Level fileLevel = options.getFileLevel();
        Level consoleLevel = options.getConsoleLevel();
        this.truncateSize = options.getTruncateSize();
        this.componentName = "";
        this.logger = Logger.getAnonymousLogger();
        this.logger.setLevel(BasicLogManager.getMinimumLevel(fileLevel, consoleLevel));
        this.logger.setUseParentHandlers(false);
        if (!consoleLevel.equals(Level.OFF)) {
            if (consoleOutputHandler == null) {
                consoleOutputHandler = new ConsoleHandler();
            }
            this.setupHandler(consoleOutputHandler, new ConsoleLogFormatter(config), consoleLevel, options.getConsoleExclude());
        }
        if (fileOutputHandler == null) {
            Path outputFile = options.getOutputFile();
            if (!fileLevel.equals(Level.OFF) && outputFile != null) {
                try {
                    Files.createParentDirs(outputFile);
                    FileHandler outfileHandler = new FileHandler(outputFile.getAbsolutePath(), false);
                    this.setupHandler(outfileHandler, new FileLogFormatter(), fileLevel, options.getFileExclude());
                }
                catch (IOException e) {
                    if (consoleLevel.intValue() > fileLevel.intValue()) {
                        this.logger.getHandlers()[0].setLevel(fileLevel);
                    }
                    this.logger.log(Level.WARNING, "Could not open log file " + e.getMessage() + ", redirecting log output to console");
                }
            }
        } else {
            this.setupHandler(fileOutputHandler, new FileLogFormatter(), fileLevel, options.getFileExclude());
        }
        if (consoleOutputHandler != null) {
            this.mxBean = new LogManagerBean(consoleOutputHandler, fileLevel);
            this.mxBean.register();
        } else {
            this.mxBean = null;
        }
    }

    protected void setupHandler(Handler handler, Formatter formatter, Level level, List<Level> excludeLevels) {
        if (excludeLevels.size() > 0) {
            handler.setFilter(new LogLevelFilter(excludeLevels));
        } else {
            handler.setFilter(null);
        }
        handler.setFormatter(formatter);
        handler.setLevel(level);
        this.logger.addHandler(handler);
    }

    private BasicLogManager(BasicLogManager originalLogger, String pComponentName) {
        this.logger = originalLogger.logger;
        this.truncateSize = originalLogger.truncateSize;
        this.componentName = pComponentName;
        this.mxBean = null;
    }

    @Override
    public LogManager withComponentName(String pName) {
        Preconditions.checkArgument(!pName.isEmpty());
        String name = this.componentName.isEmpty() ? pName : this.componentName + ":" + pName;
        return new BasicLogManager(this, name);
    }

    @Override
    public boolean wouldBeLogged(Level priority) {
        return this.logger.isLoggable(priority);
    }

    @Override
    public void log(Level priority, Object ... args) {
        Preconditions.checkNotNull(args);
        if (this.wouldBeLogged(priority)) {
            this.log0(priority, this.findCallingMethod(), this.buildMessageText(args));
        }
    }

    @Override
    public void logf(Level priority, String format, Object ... args) {
        Preconditions.checkNotNull(format);
        Preconditions.checkNotNull(args);
        if (this.wouldBeLogged(priority)) {
            this.log0(priority, this.findCallingMethod(), String.format(format, args));
        }
    }

    private StackTraceElement findCallingMethod() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int traceIndex = 3;
        String methodName = trace[traceIndex].getMethodName();
        while (methodName.startsWith("log") || methodName.startsWith("access$")) {
            methodName = trace[++traceIndex].getMethodName();
        }
        return trace[traceIndex];
    }

    private void log0(Level priority, StackTraceElement stackElement, String msg) {
        ExtendedLogRecord record = new ExtendedLogRecord(priority, msg);
        record.setSourceClassName(stackElement.getClassName());
        record.setSourceMethodName(stackElement.getMethodName());
        record.setSourceComponentName(this.componentName);
        this.logger.log(record);
    }

    private String buildMessageText(Object ... args) {
        Object[] argsStr = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String o = MoreObjects.firstNonNull(args[i], "null");
            String arg = o instanceof Appender && this.truncateSize > 0 ? Appenders.toStringWithTruncation((Appender)((Object)o), this.truncateSize + 1) : o.toString();
            arg = MoreObjects.firstNonNull(arg, "null");
            if (this.truncateSize > 0 && arg.length() > this.truncateSize) {
                String length = o instanceof Appender ? ">= " + this.truncateSize : arg.length() + "";
                argsStr[i] = arg.substring(0, 100) + "... <REMAINING ARGUMENT OMITTED BECAUSE " + length + " CHARACTERS LONG>";
                continue;
            }
            argsStr[i] = arg;
        }
        String messageText = MESSAGE_FORMAT.join(argsStr);
        return messageText;
    }

    @Override
    public void logUserException(Level priority, Throwable e, @Nullable String additionalMessage) {
        if (this.wouldBeLogged(priority)) {
            String logMessage = "";
            if (priority.equals(Level.SEVERE)) {
                logMessage = "Error: ";
            } else if (priority.equals(Level.WARNING)) {
                logMessage = "Warning: ";
            }
            String exceptionMessage = Strings.nullToEmpty(e.getMessage());
            if (Strings.isNullOrEmpty(additionalMessage)) {
                logMessage = !exceptionMessage.isEmpty() ? logMessage + exceptionMessage : logMessage + e.getClass().getSimpleName() + " in " + e.getStackTrace()[0];
            } else {
                logMessage = logMessage + additionalMessage;
                if (!exceptionMessage.isEmpty()) {
                    logMessage = e instanceof IOException && logMessage.endsWith("file") && exceptionMessage.charAt(exceptionMessage.length() - 1) == ')' ? logMessage + " " + exceptionMessage : logMessage + " (" + exceptionMessage + ")";
                }
            }
            StackTraceElement[] trace = e.getStackTrace();
            int traceIndex = 0;
            if (e instanceof InvalidConfigurationException) {
                String confPackage = Configuration.class.getPackage().getName();
                while (trace[traceIndex].getClassName().startsWith(confPackage)) {
                    ++traceIndex;
                }
            }
            this.log0(priority, trace[traceIndex], logMessage);
        }
        this.logDebugException(e, additionalMessage);
    }

    @Override
    public void logDebugException(Throwable e, @Nullable String additionalMessage) {
        this.logException(EXCEPTION_DEBUG_LEVEL, e, additionalMessage);
    }

    @Override
    public void logDebugException(Throwable e) {
        this.logDebugException(e, null);
    }

    @Override
    public void logException(Level priority, Throwable e, @Nullable String additionalMessage) {
        Preconditions.checkNotNull(e);
        if (this.wouldBeLogged(priority)) {
            String logMessage = "";
            if (!Strings.isNullOrEmpty(additionalMessage)) {
                logMessage = additionalMessage + "\n";
            }
            logMessage = logMessage + Throwables.getStackTraceAsString(e);
            StackTraceElement[] trace = Thread.currentThread().getStackTrace();
            int traceIndex = 2;
            while (trace[traceIndex].getMethodName().startsWith("log")) {
                ++traceIndex;
            }
            LogRecord record = new LogRecord(priority, logMessage);
            record.setSourceClassName(trace[traceIndex].getClassName());
            record.setSourceMethodName(trace[traceIndex].getMethodName());
            this.logger.log(record);
        }
    }

    @Override
    public void flush() {
        for (Handler handler : this.logger.getHandlers()) {
            handler.flush();
        }
    }

    @Override
    public void close() {
        if (this.mxBean != null) {
            this.mxBean.unregister();
        }
        for (Handler handler : this.logger.getHandlers()) {
            handler.close();
        }
    }

    private static Level getMinimumLevel(Level level1, Level level2) {
        if (level1.intValue() > level2.intValue()) {
            return level2;
        }
        return level1;
    }

    private class LogManagerBean
    extends AbstractMBean
    implements LogManagerMXBean {
        private final Level fileLevel;
        private final Handler consoleHandler;

        public LogManagerBean(Handler pConsoleHandler, Level pFileLevel) {
            super("org.sosy_lab.common.log:type=LogManager", BasicLogManager.this);
            this.consoleHandler = Preconditions.checkNotNull(pConsoleHandler);
            this.fileLevel = Preconditions.checkNotNull(pFileLevel);
        }

        @Override
        public String getConsoleLevel() {
            return this.consoleHandler.getLevel().toString();
        }

        @Override
        public void setConsoleLevel(String pNewLevel) throws IllegalArgumentException {
            Level newLevel = Level.parse(pNewLevel.toUpperCase());
            try {
                this.consoleHandler.setLevel(newLevel);
                BasicLogManager.this.logger.setLevel(BasicLogManager.getMinimumLevel(this.fileLevel, newLevel));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static interface LogManagerMXBean {
        public String getConsoleLevel();

        public void setConsoleLevel(String var1);
    }
}

