/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.sosy_lab.common.log.ExtendedLogRecord;
import org.sosy_lab.common.log.LogUtils;

public class FileLogFormatter
extends Formatter {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    @Override
    public String format(LogRecord lr) {
        String component;
        StringBuffer sb = new StringBuffer();
        this.dateFormat.format(new Date(lr.getMillis()), sb, new FieldPosition(0));
        sb.append("\t ");
        sb.append("level: ");
        sb.append(lr.getLevel());
        sb.append("\t ");
        if (lr instanceof ExtendedLogRecord && !(component = ((ExtendedLogRecord)lr).getSourceComponentName()).isEmpty()) {
            sb.append(component);
            sb.append(":");
        }
        sb.append(LogUtils.extractSimpleClassName(lr));
        sb.append(".");
        sb.append(lr.getSourceMethodName());
        sb.append("\t ");
        sb.append(lr.getMessage());
        sb.append("\n\n");
        return sb.toString();
    }
}

