/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.log;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.ForwardingLogManager;
import org.sosy_lab.common.log.LogManager;

public class LogManagerWithoutDuplicates
extends ForwardingLogManager
implements LogManager {
    private final LogManager delegate;
    private final Set<ImmutableList<Object>> seenMessages = new HashSet<ImmutableList<Object>>();

    public LogManagerWithoutDuplicates(LogManager pDelegate) {
        this.delegate = Preconditions.checkNotNull(pDelegate);
    }

    @Override
    protected LogManager delegate() {
        return this.delegate;
    }

    @Override
    public LogManagerWithoutDuplicates withComponentName(String pName) {
        return new LogManagerWithoutDuplicates(this.delegate.withComponentName(pName));
    }

    public void logOnce(Level pPriority, Object ... pArgs) {
        Preconditions.checkNotNull(pArgs);
        if (this.wouldBeLogged(pPriority) && this.seenMessages.add(ImmutableList.copyOf(pArgs))) {
            this.log(pPriority, pArgs);
        }
    }

    public void logfOnce(Level pPriority, String pFormat, Object ... pArgs) {
        Preconditions.checkNotNull(pFormat);
        Preconditions.checkNotNull(pArgs);
        if (this.wouldBeLogged(pPriority)) {
            ImmutableList.Builder args = ImmutableList.builder();
            args.add(pFormat);
            args.add(pArgs);
            if (this.seenMessages.add((ImmutableList<Object>)args.build())) {
                this.logf(pPriority, pFormat, pArgs);
            }
        }
    }

    public void resetSeenMessages() {
        this.seenMessages.clear();
    }
}

