/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common.time;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sosy_lab.common.time.Tickers;
import org.sosy_lab.common.time.TimeSpan;

public final class Timer {
    private static final String DEFAULT_CLOCK_PROPERTY_NAME;
    @Nullable
    static final Tickers.TickerWithUnit DEFAULT_CLOCK;
    final Tickers.TickerWithUnit clock;
    private volatile boolean running = false;
    private long startTime = 0L;
    private long sumTime = 0L;
    private long maxTime = 0L;
    private int numberOfIntervals = 0;
    private long lastIntervalLength = 0L;

    public Timer() {
        if (DEFAULT_CLOCK == null) {
            throw new IllegalArgumentException("Invalid value '" + System.getProperty(DEFAULT_CLOCK_PROPERTY_NAME) + "'" + " for property " + DEFAULT_CLOCK_PROPERTY_NAME + ", cannot create Timer without explicitly specified clock.");
        }
        this.clock = DEFAULT_CLOCK;
    }

    Timer(Tickers.TickerWithUnit pClock) {
        this.clock = Preconditions.checkNotNull(pClock);
    }

    public void start() {
        this.start(this.clock.read());
    }

    void start(long newStartTime) {
        Preconditions.checkState(!this.running);
        this.startTime = newStartTime;
        ++this.numberOfIntervals;
        this.running = true;
    }

    public void stop() {
        this.stop(this.clock.read());
    }

    public void stopIfRunning() {
        if (this.isRunning()) {
            this.stop();
        }
    }

    void stop(long endTime) {
        Preconditions.checkState(this.running);
        this.lastIntervalLength = endTime - this.startTime;
        this.sumTime += this.lastIntervalLength;
        this.maxTime = Math.max(this.lastIntervalLength, this.maxTime);
        this.startTime = 0L;
        this.running = false;
    }

    TimeSpan export(long time) {
        return TimeSpan.of(time, this.clock.unit());
    }

    public boolean isRunning() {
        return this.running;
    }

    long currentInterval() {
        return this.running ? this.clock.read() - this.startTime : 0L;
    }

    public TimeSpan getSumTime() {
        return this.export(this.sumTime());
    }

    long sumTime() {
        return this.sumTime + this.currentInterval();
    }

    public TimeSpan getMaxTime() {
        return this.export(this.maxTime());
    }

    long maxTime() {
        return Math.max(this.maxTime, this.currentInterval());
    }

    public int getNumberOfIntervals() {
        return this.numberOfIntervals + (this.running ? 1 : 0);
    }

    public TimeSpan getLengthOfLastInterval() {
        return this.export(this.lengthOfLastInterval());
    }

    long lengthOfLastInterval() {
        return this.running ? this.currentInterval() : this.lastIntervalLength;
    }

    public TimeSpan getAvgTime() {
        int currentNumberOfIntervals = this.getNumberOfIntervals();
        if (currentNumberOfIntervals == 0) {
            return this.export(0L);
        }
        return this.export(this.sumTime() / (long)currentNumberOfIntervals);
    }

    public String toString() {
        return this.getSumTime().formatAs(TimeUnit.SECONDS);
    }

    static {
        String clockToUse;
        DEFAULT_CLOCK_PROPERTY_NAME = Timer.class.getCanonicalName() + ".timeSource";
        switch (clockToUse = System.getProperty(DEFAULT_CLOCK_PROPERTY_NAME, "WALLTIME_MILLIS").toUpperCase().trim()) {
            case "WALLTIME_MILLIS": {
                DEFAULT_CLOCK = Tickers.getWalltimeMillis();
                break;
            }
            case "WALLTIME_NANOS": {
                DEFAULT_CLOCK = Tickers.getWalltimeNanos();
                break;
            }
            case "THREAD_CPUTIME": {
                DEFAULT_CLOCK = Tickers.getCurrentThreadCputime();
                break;
            }
            case "PROCESS_CPUTIME": {
                DEFAULT_CLOCK = Tickers.getProcessCputime();
                break;
            }
            case "NONE": {
                DEFAULT_CLOCK = Tickers.getNullTicker();
                break;
            }
            default: {
                DEFAULT_CLOCK = null;
            }
        }
    }
}

