/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationTerm
extends Term {
    final FunctionSymbol mFunction;
    final Term[] mParameters;

    ApplicationTerm(FunctionSymbol function, Term[] parameters, int hash) {
        super(hash);
        function.typecheck(parameters);
        this.mFunction = function;
        this.mParameters = parameters;
    }

    public FunctionSymbol getFunction() {
        return this.mFunction;
    }

    public Term[] getParameters() {
        return this.mParameters;
    }

    @Override
    public Sort getSort() {
        return this.mFunction.mReturnSort.getRealSort();
    }

    static final int hashApplication(FunctionSymbol func, Term[] parameters) {
        return HashUtils.hashJenkins(func.hashCode(), parameters);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> m_Todo) {
        String func = this.getFunction().getApplicationString();
        Term[] args = this.getParameters();
        if (args.length == 0) {
            m_Todo.add(func);
        } else {
            m_Todo.addLast(")");
            for (int i = args.length - 1; i >= 0; --i) {
                m_Todo.addLast(args[i]);
                m_Todo.addLast(" ");
            }
            m_Todo.add(func);
            m_Todo.add("(");
        }
    }
}

