/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ComputeFreeVariables
extends NonRecursive.TermWalker {
    static final TermVariable[] NOFREEVARS = new TermVariable[0];

    public ComputeFreeVariables(Term term) {
        super(term);
    }

    public void walk(NonRecursive walker) {
        if (this.mTerm.mFreeVars != null) {
            return;
        }
        super.walk(walker);
    }

    public void walk(NonRecursive walker, final AnnotatedTerm annot) {
        walker.enqueueWalker(new NonRecursive.Walker(){

            public void walk(NonRecursive walker) {
                annot.mFreeVars = annot.getSubterm().mFreeVars;
            }
        });
        walker.enqueueWalker(new ComputeFreeVariables(annot.getSubterm()));
    }

    public void walk(NonRecursive walker, ApplicationTerm term) {
        walker.enqueueWalker(new AppTermWorker(term));
        for (Term param : ((ApplicationTerm)this.mTerm).getParameters()) {
            walker.enqueueWalker(new ComputeFreeVariables(param));
        }
    }

    public void walk(NonRecursive walker, ConstantTerm term) {
        term.mFreeVars = NOFREEVARS;
    }

    public void walk(NonRecursive walker, final LetTerm letTerm) {
        walker.enqueueWalker(new NonRecursive.Walker(){

            public void walk(NonRecursive walker) {
                TermVariable[] vars = letTerm.getVariables();
                Term[] vals = letTerm.getValues();
                HashSet<TermVariable> free = new HashSet<TermVariable>();
                free.addAll(Arrays.asList(letTerm.getSubTerm().getFreeVars()));
                free.removeAll(Arrays.asList(vars));
                for (Term v : vals) {
                    free.addAll(Arrays.asList(v.getFreeVars()));
                }
                letTerm.mFreeVars = free.isEmpty() ? NOFREEVARS : free.toArray(new TermVariable[free.size()]);
            }
        });
        walker.enqueueWalker(new ComputeFreeVariables(letTerm.getSubTerm()));
        for (Term value : letTerm.getValues()) {
            walker.enqueueWalker(new ComputeFreeVariables(value));
        }
    }

    public void walk(NonRecursive walker, final QuantifiedFormula quant) {
        walker.enqueueWalker(new NonRecursive.Walker(){

            public void walk(NonRecursive walker) {
                HashSet<TermVariable> free = new HashSet<TermVariable>();
                free.addAll(Arrays.asList(quant.getSubformula().getFreeVars()));
                free.removeAll(Arrays.asList(quant.getVariables()));
                quant.mFreeVars = free.isEmpty() ? NOFREEVARS : free.toArray(new TermVariable[free.size()]);
            }
        });
        walker.enqueueWalker(new ComputeFreeVariables(quant.getSubformula()));
    }

    public void walk(NonRecursive walker, TermVariable term) {
        term.mFreeVars = new TermVariable[]{term};
    }

    static class AppTermWorker
    implements NonRecursive.Walker {
        final ApplicationTerm mTerm;

        public AppTermWorker(ApplicationTerm term) {
            this.mTerm = term;
        }

        public void walk(NonRecursive walker) {
            Term[] params = this.mTerm.getParameters();
            if (params.length <= 1) {
                this.mTerm.mFreeVars = params.length == 1 ? params[0].mFreeVars : NOFREEVARS;
            } else {
                int biggestlen = 0;
                int biggestidx = -1;
                for (int i = 0; i < params.length; ++i) {
                    TermVariable[] free = params[i].mFreeVars;
                    if (free.length <= biggestlen) continue;
                    biggestlen = free.length;
                    biggestidx = i;
                }
                if (biggestidx < 0) {
                    this.mTerm.mFreeVars = NOFREEVARS;
                    return;
                }
                ArrayList<TermVariable> result = null;
                List<TermVariable> biggestAsList = Arrays.asList(params[biggestidx].getFreeVars());
                for (int i = 0; i < params.length; ++i) {
                    TermVariable[] free;
                    if (i == biggestidx) continue;
                    for (TermVariable tv : free = params[i].getFreeVars()) {
                        if (biggestAsList.contains(tv)) continue;
                        if (result == null) {
                            result = new ArrayList<TermVariable>();
                            result.addAll(biggestAsList);
                        }
                        if (result.contains(tv)) continue;
                        result.add(tv);
                    }
                }
                this.mTerm.mFreeVars = result == null ? params[biggestidx].getFreeVars() : result.toArray(new TermVariable[result.size()]);
            }
        }

        public String toString() {
            return "AppTermWalker:" + this.mTerm.toStringDirect();
        }
    }
}

