/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.math.BigInteger;

public class FunctionSymbol {
    public static final int INTERNAL = 1;
    public static final int LEFTASSOC = 2;
    public static final int RIGHTASSOC = 4;
    public static final int CHAINABLE = 6;
    public static final int PAIRWISE = 8;
    public static final int ASSOCMASK = 14;
    public static final int RETURNOVERLOAD = 16;
    public static final int MODELVALUE = 32;
    final String mName;
    final BigInteger[] mIndices;
    final Sort[] mParamSort;
    final Sort mReturnSort;
    final int mFlags;
    final TermVariable[] mDefinitionVars;
    final Term mDefinition;

    FunctionSymbol(String n, BigInteger[] i, Sort[] params, Sort result, TermVariable[] definitionVars, Term definition, int flags) {
        this.mName = n;
        this.mIndices = i;
        this.mParamSort = params;
        this.mReturnSort = result;
        this.mFlags = flags;
        this.mDefinition = definition;
        this.mDefinitionVars = definitionVars;
        if (this.isLeftAssoc() && (params.length != 2 || !params[0].equalsSort(result))) {
            throw new IllegalArgumentException("Wrong sorts for left-associative symbol");
        }
        if (this.isRightAssoc() && (params.length != 2 || !params[1].equalsSort(result))) {
            throw new IllegalArgumentException("Wrong sorts for right-associative symbol");
        }
        if (!(!this.isChainable() && !this.isPairwise() || params.length == 2 && params[0].equalsSort(params[1]) && result.equalsSort(this.getTheory().getBooleanSort()))) {
            throw new IllegalArgumentException("Wrong sorts for chainable symbol");
        }
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String getName() {
        return this.mName;
    }

    public BigInteger[] getIndices() {
        return this.mIndices;
    }

    public boolean isIntern() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isModelValue() {
        return (this.mFlags & 0x20) != 0;
    }

    public Theory getTheory() {
        return this.mReturnSort.mSymbol.mTheory;
    }

    public int getParameterCount() {
        return this.mParamSort.length;
    }

    public Sort getParameterSort(int i) {
        return this.mParamSort[i];
    }

    public TermVariable[] getDefinitionVars() {
        return this.mDefinitionVars;
    }

    public Term getDefinition() {
        return this.mDefinition;
    }

    public Sort getReturnSort() {
        return this.mReturnSort;
    }

    public Sort[] getParameterSorts() {
        return this.mParamSort;
    }

    private final void checkSort(Term arg, Sort sort, boolean mixRealInt) {
        Sort argSort = arg.getSort();
        if (!sort.equalsSort(argSort)) {
            if (argSort.toString().equals(sort.toString())) {
                throw new SMTLIBException("Argument " + arg + " comes from wrong theory.");
            }
            if (!mixRealInt || !argSort.getName().equals("Int")) {
                throw new SMTLIBException("Argument " + arg + " has type " + argSort + " but function " + this.mName + " expects " + sort);
            }
        }
    }

    public void typecheck(Term[] params) throws SMTLIBException {
        boolean mixRealInt = false;
        if (this.getTheory().getLogic() != null && this.getTheory().getLogic().isIRA() && this.mParamSort.length == 2 && this.mParamSort[0] == this.mParamSort[1] && this.mParamSort[0] == this.getTheory().getSort("Real", new Sort[0])) {
            mixRealInt = true;
        }
        if ((this.mFlags & 0xE) != 0) {
            if (params.length < 2) {
                throw new SMTLIBException("Function " + this.mName + " expects at least two arguments.");
            }
            this.checkSort(params[0], this.mParamSort[0], mixRealInt);
            this.checkSort(params[params.length - 1], this.mParamSort[1], mixRealInt);
            Sort otherSort = this.isLeftAssoc() ? this.mParamSort[1] : this.mParamSort[0];
            for (int i = 1; i < params.length - 1; ++i) {
                this.checkSort(params[i], otherSort, mixRealInt);
            }
        } else {
            if (params.length != this.mParamSort.length) {
                throw new SMTLIBException("Function " + this.mName + " expects " + this.mParamSort.length + " arguments.");
            }
            for (int i = 0; i < this.mParamSort.length; ++i) {
                this.checkSort(params[i], this.mParamSort[i], mixRealInt);
            }
        }
    }

    public boolean typecheck(Sort[] params) {
        boolean mixRealInt = false;
        if (this.getTheory().getLogic().isIRA() && this.mParamSort.length == 2 && this.mParamSort[0] == this.mParamSort[1] && this.mParamSort[0].getName().equals("Real")) {
            mixRealInt = true;
        }
        if ((this.mFlags & 0xE) != 0) {
            assert (this.mParamSort.length == 2);
            if (params.length < 2) {
                return false;
            }
            if (!(params[0].equalsSort(this.mParamSort[0]) || mixRealInt && params[0] == this.getTheory().getSort("Int", new Sort[0]))) {
                return false;
            }
            if (!(params[params.length - 1].equalsSort(this.mParamSort[1]) || mixRealInt && params[params.length - 1] == this.getTheory().getSort("Int", new Sort[0]))) {
                return false;
            }
            Sort otherSort = this.isLeftAssoc() ? this.mParamSort[1] : this.mParamSort[0];
            for (int i = 1; i < params.length - 1; ++i) {
                if (params[i].equalsSort(otherSort) || mixRealInt && params[i] == this.getTheory().getSort("Int", new Sort[0])) continue;
                return false;
            }
        } else {
            if (params.length != this.mParamSort.length) {
                return false;
            }
            for (int i = 0; i < this.mParamSort.length; ++i) {
                if (params[i].equalsSort(this.mParamSort[i]) || mixRealInt && params[i] == this.getTheory().getSort("Int", new Sort[0])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String name = PrintTerm.quoteIdentifier(this.mName);
        sb.append('(');
        if (this.mIndices == null) {
            sb.append(name);
        } else {
            sb.append("(_ ").append(name);
            for (BigInteger i : this.mIndices) {
                sb.append(' ').append(i);
            }
            sb.append(')');
        }
        for (Sort s : this.mParamSort) {
            sb.append(' ').append(s);
        }
        sb.append(' ').append(this.mReturnSort);
        sb.append(')');
        return sb.toString();
    }

    public final boolean isChainable() {
        return (this.mFlags & 0xE) == 6;
    }

    public final boolean isPairwise() {
        return (this.mFlags & 0xE) == 8;
    }

    public final boolean isLeftAssoc() {
        return (this.mFlags & 0xE) == 2;
    }

    public final boolean isRightAssoc() {
        return (this.mFlags & 0xE) == 4;
    }

    public final boolean isReturnOverload() {
        return (this.mFlags & 0x10) != 0;
    }

    public String getApplicationString() {
        String name = PrintTerm.quoteIdentifier(this.mName);
        if (this.mIndices == null && !this.isReturnOverload()) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        if (this.isReturnOverload()) {
            sb.append("(as ");
        }
        if (this.mIndices != null) {
            sb.append("(_ ");
        }
        sb.append(name);
        if (this.mIndices != null) {
            for (BigInteger i : this.mIndices) {
                sb.append(' ').append(i);
            }
            sb.append(')');
        }
        if (this.isReturnOverload()) {
            sb.append(' ').append(this.getReturnSort()).append(')');
        }
        return sb.toString();
    }

    public boolean isInterpreted() {
        return this.isModelValue() || this.isIntern() && (this.mName.charAt(0) != '@' || !this.mName.endsWith("0"));
    }
}

