/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.UnifyHash;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class FunctionSymbolFactory {
    String mFuncName;
    UnifyHash<FunctionSymbol> mInstances;

    public FunctionSymbolFactory(String name) {
        this.mFuncName = name;
        this.mInstances = new UnifyHash();
    }

    public abstract Sort getResultSort(BigInteger[] var1, Sort[] var2, Sort var3);

    public int getFlags(BigInteger[] indices, Sort[] paramSorts, Sort result) {
        return 1;
    }

    private static boolean isReal(Sort[] sorts) {
        for (Sort s : sorts) {
            if (s.getRealSort() == s) continue;
            return false;
        }
        return true;
    }

    public Term getDefinition(TermVariable[] tvs, Sort resultSort) {
        return null;
    }

    public FunctionSymbol getFunctionWithResult(Theory theory, BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
        Term definition;
        int i;
        assert (FunctionSymbolFactory.isReal(paramSorts));
        int flags = this.getFlags(indices, paramSorts, resultSort);
        if ((flags & 0xE) != 0) {
            if (paramSorts.length < 2) {
                return null;
            }
            Sort[] realParams = new Sort[]{paramSorts[0], paramSorts[paramSorts.length - 1]};
            Sort otherSort = (flags & 0xE) == 2 ? realParams[1] : realParams[0];
            for (i = 1; i < paramSorts.length - 1; ++i) {
                if (paramSorts[i] == otherSort) continue;
                return null;
            }
            paramSorts = realParams;
        }
        if ((flags & 0x10) == 0 != (resultSort == null)) {
            return null;
        }
        int hash = Arrays.hashCode(indices) ^ Arrays.hashCode(paramSorts) ^ (resultSort == null ? 0 : resultSort.hashCode());
        for (FunctionSymbol func : this.mInstances.iterateHashCode(hash)) {
            if (!Arrays.equals(func.mIndices, indices) || !Arrays.equals(func.mParamSort, paramSorts) || resultSort != null && func.mReturnSort != resultSort) continue;
            return func;
        }
        if ((resultSort = this.getResultSort(indices, paramSorts, resultSort)) == null) {
            return null;
        }
        Term[] defVars = new TermVariable[paramSorts.length];
        for (i = 0; i < paramSorts.length; ++i) {
            defVars[i] = theory.createTermVariable("x" + i, paramSorts[i]);
        }
        if ((flags & 0x10) != 0 && resultSort != resultSort.getRealSort()) {
            FunctionSymbol realFunc = this.getFunctionWithResult(theory, indices, paramSorts, resultSort.getRealSort());
            definition = theory.term(realFunc, defVars);
        } else {
            definition = this.getDefinition((TermVariable[])defVars, resultSort);
        }
        if (definition == null) {
            defVars = null;
        }
        FunctionSymbol func = new FunctionSymbol(this.mFuncName, indices, paramSorts, resultSort, (TermVariable[])defVars, definition, flags);
        this.mInstances.put(hash, func);
        return func;
    }

    public String toString() {
        return this.mFuncName;
    }
}

