/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingScript
implements Script {
    private final Script mScript;
    private final PrintWriter mPw;
    private final PrintTerm mTermPrinter = new PrintTerm();
    private final FormulaLet mLetter;

    public LoggingScript(String file, boolean autoFlush) throws FileNotFoundException {
        this(new NoopScript(), file, autoFlush);
    }

    public LoggingScript(Script script, String file, boolean autoFlush) throws FileNotFoundException {
        this(script, file, autoFlush, false);
    }

    public LoggingScript(Script script, String file, boolean autoFlush, boolean useCSE) throws FileNotFoundException {
        this.mScript = script;
        OutputStream out = file.equals("<stdout>") ? System.out : (file.equals("<stderr>") ? System.err : new FileOutputStream(file));
        this.mPw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(out)), autoFlush);
        this.mLetter = useCSE ? new FormulaLet() : null;
    }

    private final Term formatTerm(Term input) {
        return this.mLetter == null ? input : new FormulaLet().let(input);
    }

    @Override
    public void setLogic(String logic) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.println("(set-logic " + logic + ")");
        this.mScript.setLogic(logic);
    }

    @Override
    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.println("(set-logic " + logic.name() + ")");
        this.mScript.setLogic(logic);
    }

    @Override
    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.print("(set-option ");
        this.mPw.print(opt);
        this.mPw.print(' ');
        this.mPw.print(value);
        this.mPw.println(")");
        this.mScript.setOption(opt, value);
    }

    @Override
    public void setInfo(String info, Object value) {
        this.mPw.print("(set-info ");
        this.mPw.print(info);
        this.mPw.print(' ');
        this.mPw.print(value);
        this.mPw.println(")");
        this.mScript.setInfo(info, value);
    }

    @Override
    public void declareSort(String sort, int arity) throws SMTLIBException {
        this.mScript.declareSort(sort, arity);
        this.mPw.print("(declare-sort ");
        this.mPw.print(PrintTerm.quoteIdentifier(sort));
        this.mPw.print(' ');
        this.mPw.print(arity);
        this.mPw.println(")");
    }

    @Override
    public void defineSort(String sort, Sort[] sortParams, Sort definition) throws SMTLIBException {
        this.mScript.defineSort(sort, sortParams, definition);
        this.mPw.print("(define-sort ");
        this.mPw.print(PrintTerm.quoteIdentifier(sort));
        this.mPw.print(" (");
        String sep = "";
        for (Sort p : sortParams) {
            this.mPw.print(sep);
            this.mTermPrinter.append((Appendable)this.mPw, p);
            sep = " ";
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, definition);
        this.mPw.println(")");
    }

    @Override
    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        this.mScript.declareFun(fun, paramSorts, resultSort);
        this.mPw.print("(declare-fun ");
        this.mPw.print(PrintTerm.quoteIdentifier(fun));
        this.mPw.print(" (");
        String sep = "";
        for (Sort p : paramSorts) {
            this.mPw.print(sep);
            this.mTermPrinter.append((Appendable)this.mPw, p);
            sep = " ";
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, resultSort);
        this.mPw.println(")");
    }

    @Override
    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        this.mScript.defineFun(fun, params, resultSort, definition);
        this.mPw.print("(define-fun ");
        this.mPw.print(PrintTerm.quoteIdentifier(fun));
        this.mPw.print(" (");
        String sep = "(";
        for (TermVariable t : params) {
            this.mPw.print(sep);
            this.mPw.print(t);
            this.mPw.print(' ');
            this.mTermPrinter.append((Appendable)this.mPw, t.getSort());
            this.mPw.print(')');
            sep = " (";
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, resultSort);
        this.mPw.print(' ');
        this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(definition));
        this.mPw.println(")");
    }

    @Override
    public void push(int levels) throws SMTLIBException {
        this.mPw.println("(push " + levels + ")");
        this.mScript.push(levels);
    }

    @Override
    public void pop(int levels) throws SMTLIBException {
        this.mPw.println("(pop " + levels + ")");
        this.mScript.pop(levels);
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mPw.print("(assert ");
        this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(term));
        this.mPw.println(")");
        return this.mScript.assertTerm(term);
    }

    @Override
    public Script.LBool checkSat() throws SMTLIBException {
        this.mPw.println("(check-sat)");
        return this.mScript.checkSat();
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        this.mPw.println("(get-assertions)");
        return this.mScript.getAssertions();
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-proof)");
        return this.mScript.getProof();
    }

    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-unsat-core)");
        return this.mScript.getUnsatCore();
    }

    @Override
    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-value (");
        String sep = "";
        for (Term t : terms) {
            this.mPw.print(sep);
            this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(t));
            sep = " ";
        }
        this.mPw.println("))");
        return this.mScript.getValue(terms);
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-assignment)");
        return this.mScript.getAssignment();
    }

    @Override
    public Object getOption(String opt) throws UnsupportedOperationException {
        this.mPw.println("(get-option " + opt + ")");
        return this.mScript.getOption(opt);
    }

    @Override
    public Object getInfo(String info) throws UnsupportedOperationException {
        this.mPw.println("(get-info " + info + ")");
        return this.mScript.getInfo(info);
    }

    @Override
    public Term simplify(Term term) throws SMTLIBException {
        this.mPw.print("(simplify ");
        this.mTermPrinter.append((Appendable)this.mPw, term);
        this.mPw.println(")");
        return this.mScript.simplify(term);
    }

    @Override
    public void reset() {
        this.mPw.println("(reset)");
        this.mScript.reset();
    }

    @Override
    public Term[] getInterpolants(Term[] partition) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-interpolants");
        for (Term t : partition) {
            this.mPw.print(' ');
            this.mTermPrinter.append((Appendable)this.mPw, t);
        }
        this.mPw.println(')');
        return this.mScript.getInterpolants(partition);
    }

    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-interpolants ");
        this.mTermPrinter.append((Appendable)this.mPw, partition[0]);
        for (int i = 1; i < partition.length; ++i) {
            int prevStart = startOfSubtree[i - 1];
            while (startOfSubtree[i] < prevStart) {
                this.mPw.print(')');
                prevStart = startOfSubtree[prevStart - 1];
            }
            this.mPw.print(' ');
            if (startOfSubtree[i] == i) {
                this.mPw.print('(');
            }
            this.mTermPrinter.append((Appendable)this.mPw, partition[i]);
        }
        this.mPw.println(')');
        return this.mScript.getInterpolants(partition, startOfSubtree);
    }

    @Override
    public void exit() {
        this.mPw.println("(exit)");
        this.mPw.flush();
        this.mPw.close();
        this.mScript.exit();
    }

    @Override
    public Sort sort(String sortname, Sort ... params) throws SMTLIBException {
        return this.mScript.sort(sortname, params);
    }

    @Override
    public Sort sort(String sortname, BigInteger[] indices, Sort ... params) throws SMTLIBException {
        return this.mScript.sort(sortname, indices, params);
    }

    @Override
    public Term term(String funcname, Term ... params) throws SMTLIBException {
        return this.mScript.term(funcname, params);
    }

    @Override
    public Term term(String funcname, BigInteger[] indices, Sort returnSort, Term ... params) throws SMTLIBException {
        return this.mScript.term(funcname, indices, returnSort, params);
    }

    @Override
    public TermVariable variable(String varname, Sort sort) throws SMTLIBException {
        return this.mScript.variable(varname, sort);
    }

    @Override
    public Term quantifier(int quantor, TermVariable[] vars, Term body, Term[] ... patterns) throws SMTLIBException {
        return this.mScript.quantifier(quantor, vars, body, patterns);
    }

    @Override
    public Term let(TermVariable[] vars, Term[] values, Term body) throws SMTLIBException {
        return this.mScript.let(vars, values, body);
    }

    @Override
    public Term annotate(Term t, Annotation ... annotations) throws SMTLIBException {
        return this.mScript.annotate(t, annotations);
    }

    @Override
    public Term numeral(String num) throws SMTLIBException {
        return this.mScript.numeral(num);
    }

    @Override
    public Term numeral(BigInteger num) throws SMTLIBException {
        return this.mScript.numeral(num);
    }

    @Override
    public Term decimal(String decimal) throws SMTLIBException {
        return this.mScript.decimal(decimal);
    }

    @Override
    public Term decimal(BigDecimal decimal) throws SMTLIBException {
        return this.mScript.decimal(decimal);
    }

    @Override
    public Term string(String str) throws SMTLIBException {
        return this.mScript.string(str);
    }

    @Override
    public Term hexadecimal(String hex) throws SMTLIBException {
        return this.mScript.hexadecimal(hex);
    }

    @Override
    public Term binary(String bin) throws SMTLIBException {
        return this.mScript.binary(bin);
    }

    @Override
    public Sort[] sortVariables(String ... names) throws SMTLIBException {
        return this.mScript.sortVariables(names);
    }

    @Override
    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-model)");
        return this.mScript.getModel();
    }

    @Override
    public Iterable<Term[]> checkAllsat(Term[] predicates) throws SMTLIBException, UnsupportedOperationException {
        PrintTerm pt = new PrintTerm();
        this.mPw.print("(check-allsat (");
        String spacer = "";
        for (Term p : predicates) {
            this.mPw.print(spacer);
            pt.append((Appendable)this.mPw, p);
            spacer = " ";
        }
        this.mPw.println("))");
        return this.mScript.checkAllsat(predicates);
    }

    @Override
    public Term[] findImpliedEquality(Term[] x, Term[] y) {
        PrintTerm pt = new PrintTerm();
        this.mPw.print("(find-implied-equality (");
        String spacer = "";
        for (Term p : x) {
            this.mPw.print(spacer);
            pt.append((Appendable)this.mPw, p);
            spacer = " ";
        }
        this.mPw.print(") (");
        spacer = "";
        for (Term p : x) {
            this.mPw.print(spacer);
            pt.append((Appendable)this.mPw, p);
            spacer = " ";
        }
        this.mPw.println("))");
        return this.mScript.findImpliedEquality(x, y);
    }

    @Override
    public QuotedObject echo(QuotedObject msg) {
        this.mPw.print("(echo ");
        this.mPw.print(msg);
        this.mPw.println(')');
        return this.mScript.echo(msg);
    }

    public void comment(String comment) {
        this.mPw.print("; ");
        this.mPw.println(comment);
    }
}

