/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.IOException;
import java.util.ArrayDeque;

public class PrintTerm {
    private final ArrayDeque<Object> mTodo = new ArrayDeque();

    public void append(Appendable appender, Term term) {
        try {
            this.mTodo.push(term);
            this.run(appender);
        }
        catch (IOException ex) {
            throw new RuntimeException("Appender throws IOException", ex);
        }
    }

    public void append(Appendable appender, Sort sort) {
        try {
            this.mTodo.push(sort);
            this.run(appender);
        }
        catch (IOException ex) {
            throw new RuntimeException("Appender throws IOException", ex);
        }
    }

    public void append(Appendable appender, Object[] sexpr) {
        try {
            this.mTodo.push(sexpr);
            this.run(appender);
        }
        catch (IOException ex) {
            throw new RuntimeException("Appender throws IOException", ex);
        }
    }

    public static String quoteIdentifier(String id) {
        assert (id.indexOf(124) < 0 && id.indexOf(92) < 0);
        for (int idx = 0; idx < id.length(); ++idx) {
            char c = id.charAt(idx);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' && idx > 0 || "~!@$%^&*_+-=<>.?/".indexOf(c) >= 0) continue;
            return "|" + id + "|";
        }
        return id;
    }

    private void run(Appendable appender) throws IOException {
        while (!this.mTodo.isEmpty()) {
            Object next = this.mTodo.removeLast();
            if (next instanceof Term) {
                ((Term)next).toStringHelper(this.mTodo);
                continue;
            }
            if (next instanceof Sort) {
                ((Sort)next).toStringHelper(this.mTodo);
                continue;
            }
            if (next instanceof Object[]) {
                Object[] arr = (Object[])next;
                this.mTodo.addLast(")");
                for (int i = arr.length - 1; i >= 0; --i) {
                    this.mTodo.addLast(arr[i]);
                    if (i <= 0) continue;
                    this.mTodo.addLast(" ");
                }
                appender.append('(');
                continue;
            }
            appender.append(next.toString());
        }
    }

    public String toString() {
        return "[PrintTerm: " + this.mTodo + "]";
    }
}

