/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.PolymorphicFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import de.uni_freiburg.informatik.ultimate.util.ScopedHashMap;
import de.uni_freiburg.informatik.ultimate.util.UnifyHash;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class Theory {
    private SolverSetup mSolverSetup;
    private Logics mLogic;
    private Sort mNumericSort;
    private Sort mRealSort;
    private Sort mStringSort;
    private Sort mBooleanSort;
    private SortSymbol mBitVecSort;
    private final HashMap<String, FunctionSymbolFactory> mFunFactory = new HashMap();
    private final UnifyHash<FunctionSymbol> mModelValueCache = new UnifyHash();
    private final ScopedHashMap<String, SortSymbol> mDeclaredSorts = new ScopedHashMap();
    private final ScopedHashMap<String, FunctionSymbol> mDeclaredFuns = new ScopedHashMap();
    private final UnifyHash<QuantifiedFormula> mQfCache = new UnifyHash();
    private final UnifyHash<LetTerm> mLetCache = new UnifyHash();
    private final UnifyHash<Term> mTermCache = new UnifyHash();
    private final UnifyHash<TermVariable> mTvUnify = new UnifyHash();
    public final ApplicationTerm mTrue;
    public final ApplicationTerm mFalse;
    public final FunctionSymbol mAnd;
    public final FunctionSymbol mOr;
    public final FunctionSymbol mNot;
    public final FunctionSymbol mImplies;
    public final FunctionSymbol mXor;
    public final PolymorphicFunctionSymbol mEquals;
    public final PolymorphicFunctionSymbol mDistinct;
    public final PolymorphicFunctionSymbol mIte;
    private static final Sort[] EMPTY_SORT_ARRAY = new Sort[0];
    private static final String MODEL_VALUE_PATTERN = "^@\\d+$";
    private int mTvarCtr = 0;
    private int mSkolemCounter = 0;

    public Theory() {
        this.mFalse = null;
        this.mTrue = null;
        this.mXor = null;
        this.mImplies = null;
        this.mNot = null;
        this.mOr = null;
        this.mAnd = null;
        this.mIte = null;
        this.mDistinct = null;
        this.mEquals = null;
    }

    public Theory(Logics logic) {
        this(logic, null);
    }

    public Theory(Logics logic, SolverSetup solverSetup) {
        this.mSolverSetup = solverSetup;
        Sort[] noarg = new Sort[]{};
        this.mBooleanSort = this.declareInternalSort("Bool", 0, 0).getSort(null, noarg);
        Sort[] generic1 = this.createSortVariables("A");
        Sort[] bool1 = new Sort[]{this.mBooleanSort};
        Sort[] bool2 = new Sort[]{this.mBooleanSort, this.mBooleanSort};
        Sort[] generic2 = new Sort[]{generic1[0], generic1[0]};
        int leftassoc = 2;
        this.mNot = this.declareInternalFunction("not", bool1, this.mBooleanSort, 0);
        this.mAnd = this.declareInternalFunction("and", bool2, this.mBooleanSort, leftassoc);
        this.mOr = this.declareInternalFunction("or", bool2, this.mBooleanSort, leftassoc);
        this.mImplies = this.declareInternalFunction("=>", bool2, this.mBooleanSort, 4);
        this.mEquals = this.declareInternalPolymorphicFunction("=", generic1, generic2, this.mBooleanSort, 6);
        this.mDistinct = this.declareInternalPolymorphicFunction("distinct", generic1, generic2, this.mBooleanSort, 8);
        this.mXor = this.declareInternalFunction("xor", bool2, this.mBooleanSort, leftassoc);
        this.mIte = this.declareInternalPolymorphicFunction("ite", generic1, new Sort[]{this.mBooleanSort, generic1[0], generic1[0]}, generic1[0], 0);
        this.mTrue = this.term(this.declareInternalFunction("true", noarg, this.mBooleanSort, 0), new Term[0]);
        this.mFalse = this.term(this.declareInternalFunction("false", noarg, this.mBooleanSort, 0), new Term[0]);
        this.setLogic(logic);
    }

    private Term simplifyAndOr(FunctionSymbol connector, Term ... subforms) {
        ApplicationTerm neutral = connector == this.mAnd ? this.mTrue : this.mFalse;
        LinkedHashSet<Term> formulas = new LinkedHashSet<Term>();
        for (Term f : subforms) {
            if (f == this.mTrue || f == this.mFalse) {
                if (f == neutral) continue;
                return f;
            }
            if (f instanceof ApplicationTerm && ((ApplicationTerm)f).getFunction() == connector) {
                for (Term subf : ((ApplicationTerm)f).getParameters()) {
                    formulas.add(subf);
                }
                continue;
            }
            formulas.add(f);
        }
        if (formulas.size() <= 1) {
            if (formulas.isEmpty()) {
                return neutral;
            }
            return (Term)formulas.iterator().next();
        }
        Term[] arrforms = formulas.toArray(new Term[formulas.size()]);
        return this.term(connector, arrforms);
    }

    public Term not(Term f) {
        if (f == this.mTrue) {
            return this.mFalse;
        }
        if (f == this.mFalse) {
            return this.mTrue;
        }
        if (f instanceof ApplicationTerm && ((ApplicationTerm)f).getFunction() == this.mNot) {
            return ((ApplicationTerm)f).getParameters()[0];
        }
        return this.term(this.mNot, f);
    }

    public Term and(Term ... subforms) {
        return this.simplifyAndOr(this.mAnd, subforms);
    }

    public Term or(Term ... subforms) {
        return this.simplifyAndOr(this.mOr, subforms);
    }

    public Term implies(Term f, Term g) {
        if (g == this.mTrue || f == this.mTrue) {
            return g;
        }
        if (f == this.mFalse) {
            return this.mTrue;
        }
        if (g == this.mFalse) {
            return this.not(f);
        }
        if (f == g) {
            return this.mTrue;
        }
        return this.term(this.mImplies, f, g);
    }

    public Term xor(Term f, Term g) {
        if (f == this.mTrue) {
            return this.not(g);
        }
        if (g == this.mTrue) {
            return this.not(f);
        }
        if (f == this.mFalse) {
            return g;
        }
        if (g == this.mFalse) {
            return f;
        }
        if (f == g) {
            return this.mFalse;
        }
        return this.term(this.mXor, f, g);
    }

    public Term ifthenelse(Term c, Term t, Term e) {
        if (c == this.mTrue) {
            return t;
        }
        if (c == this.mFalse) {
            return e;
        }
        if (t == e) {
            return t;
        }
        if (t == this.mTrue && e == this.mFalse) {
            return c;
        }
        if (t == this.mFalse && e == this.mTrue) {
            return this.not(c);
        }
        if (t == this.mTrue) {
            return this.term(this.mOr, c, e);
        }
        if (t == this.mFalse) {
            return this.term(this.mAnd, this.term(this.mNot, c), e);
        }
        if (e == this.mTrue) {
            return this.term(this.mImplies, c, t);
        }
        if (e == this.mFalse) {
            return this.term(this.mAnd, c, t);
        }
        return this.term(this.mIte, c, t, e);
    }

    private Term quantify(int quant, TermVariable[] vars, Term f) {
        if (f == this.mTrue || f == this.mFalse) {
            return f;
        }
        int hash = QuantifiedFormula.hashQuantifier(quant, vars, f);
        for (QuantifiedFormula qf : this.mQfCache.iterateHashCode(hash)) {
            if (qf.getQuantifier() != quant || qf.getSubformula() != f || !Arrays.equals(vars, qf.getVariables())) continue;
            return qf;
        }
        QuantifiedFormula qf = new QuantifiedFormula(quant, vars, f, hash);
        this.mQfCache.put(hash, qf);
        return qf;
    }

    public Term exists(TermVariable[] vars, Term f) {
        return this.quantify(0, vars, f);
    }

    public Term forall(TermVariable[] vars, Term f) {
        return this.quantify(1, vars, f);
    }

    public Term let(TermVariable[] vars, Term[] values, Term subform) {
        assert (vars.length == values.length);
        if (vars.length == 0) {
            return subform;
        }
        int hash = LetTerm.hashLet(vars, values, subform);
        for (LetTerm lt : this.mLetCache.iterateHashCode(hash)) {
            if (lt.getSubTerm() != subform || !Arrays.equals(lt.getVariables(), vars) || !Arrays.equals(lt.getValues(), values)) continue;
            return lt;
        }
        LetTerm lf = new LetTerm(vars, values, subform, hash);
        this.mLetCache.put(hash, lf);
        return lf;
    }

    public Term let(TermVariable var, Term value, Term subform) {
        return this.let(new TermVariable[]{var}, new Term[]{value}, subform);
    }

    public Term distinct(Term ... terms) {
        if (terms.length < 2) {
            return null;
        }
        if (terms.length == 2) {
            if (terms[0] == terms[1]) {
                return this.mFalse;
            }
            if (terms[0].getSort() == this.mBooleanSort) {
                if (terms[0] == this.mFalse) {
                    return terms[1];
                }
                if (terms[1] == this.mFalse) {
                    return terms[0];
                }
                if (terms[0] == this.mTrue) {
                    return this.not(terms[1]);
                }
                if (terms[1] == this.mTrue) {
                    return this.not(terms[0]);
                }
            }
            return this.term(this.mDistinct, terms);
        }
        HashSet<Term> params = new HashSet<Term>(Arrays.asList(terms));
        if (params.size() != terms.length) {
            return this.mFalse;
        }
        return this.term(this.mDistinct, terms);
    }

    public Term equals(Term ... terms) {
        if (terms.length < 2) {
            return null;
        }
        if (terms.length == 2) {
            if (terms[0] == terms[1]) {
                return this.mTrue;
            }
            if (terms[0].getSort() == this.mBooleanSort) {
                if (terms[0] == this.mTrue) {
                    return terms[1];
                }
                if (terms[1] == this.mTrue) {
                    return terms[0];
                }
                if (terms[0] == this.mFalse) {
                    return this.not(terms[1]);
                }
                if (terms[1] == this.mFalse) {
                    return this.not(terms[0]);
                }
            }
            return this.term(this.mEquals, terms);
        }
        HashSet<Term> params = new HashSet<Term>(Arrays.asList(terms));
        if (params.size() == 1) {
            return this.mTrue;
        }
        return this.term(this.mEquals, terms);
    }

    public Term constant(Object value, Sort sort) {
        if (value instanceof Rational) {
            if (!sort.isNumericSort()) {
                throw new SMTLIBException("Not a numeric sort");
            }
            Rational v = (Rational)value;
            if (!v.isRational()) {
                throw new SMTLIBException("Infinite/NaN value");
            }
            if (sort.getName().equals("Int") && !v.isIntegral()) {
                throw new SMTLIBException("Non-integral value with integer sort");
            }
        }
        int hash = ConstantTerm.hashConstant(value, sort);
        for (Term t : this.mTermCache.iterateHashCode(hash)) {
            ConstantTerm nt;
            if (!(t instanceof ConstantTerm) || (nt = (ConstantTerm)t).getSort() != sort || !value.equals(nt.getValue())) continue;
            return nt;
        }
        ConstantTerm nt = new ConstantTerm(value, sort, hash);
        this.mTermCache.put(hash, nt);
        return nt;
    }

    public Term numeral(BigInteger num) {
        Term result = this.constant(num.abs(), this.mNumericSort);
        if (num.signum() < 0) {
            FunctionSymbol neg = this.getFunction("-", this.mNumericSort);
            result = this.term(neg, result);
        }
        return result;
    }

    public Term numeral(String num) {
        return this.numeral(new BigInteger(num));
    }

    public Term decimal(BigDecimal value) {
        if (value.scale() == 0) {
            value = value.setScale(1);
        }
        Term result = this.constant(value.abs(), this.mRealSort);
        if (value.signum() < 0) {
            FunctionSymbol neg = this.getFunction("-", this.mRealSort);
            result = this.term(neg, result);
        }
        return result;
    }

    public Term decimal(String value) {
        return this.decimal(new BigDecimal(value));
    }

    public Term rational(Rational c, Sort sort) {
        assert (c.denominator().signum() == 1);
        if (sort == this.mRealSort) {
            return this.rational(c.numerator(), c.denominator());
        }
        assert (c.isIntegral());
        return this.numeral(c.numerator());
    }

    public Term binary(String value) {
        assert (value.startsWith("#b"));
        if (this.mBitVecSort == null) {
            return null;
        }
        BigInteger bsize = BigInteger.valueOf(value.length() - 2);
        Sort sort = this.mBitVecSort.getSort(new BigInteger[]{bsize}, new Sort[0]);
        return new ConstantTerm(value, sort, ConstantTerm.hashConstant(value, sort));
    }

    public Term hexadecimal(String value) {
        assert (value.startsWith("#x"));
        if (this.mBitVecSort == null) {
            return null;
        }
        BigInteger bsize = BigInteger.valueOf(4 * (value.length() - 2));
        Sort sort = this.mBitVecSort.getSort(new BigInteger[]{bsize}, new Sort[0]);
        return new ConstantTerm(value, sort, ConstantTerm.hashConstant(value, sort));
    }

    public Term rational(BigInteger num, BigInteger denom) {
        BigInteger gcd = num.gcd(denom);
        if (denom.signum() * gcd.signum() < 0) {
            gcd = gcd.negate();
        }
        num = num.divide(gcd);
        if ((denom = denom.divide(gcd)).equals(BigInteger.ONE)) {
            return this.decimal(new BigDecimal(num));
        }
        FunctionSymbol div = this.getFunction("/", this.mNumericSort, this.mNumericSort);
        return this.term(div, this.numeral(num), this.numeral(denom));
    }

    public Term modelRational(Rational rat, Sort sort) {
        if (sort == this.mRealSort) {
            BigInteger num = rat.numerator();
            BigInteger denom = rat.denominator();
            if (denom.equals(BigInteger.ONE) && !this.mLogic.isIRA()) {
                return this.decimal(new BigDecimal(num));
            }
            if (this.mLogic.isIRA()) {
                FunctionSymbol div = this.getFunction("/", this.mRealSort, this.mRealSort);
                FunctionSymbol toreal = this.getFunction("to_real", this.mNumericSort);
                ApplicationTerm numeralTerm = this.term(toreal, this.numeral(num.abs()));
                if (num.signum() < 0) {
                    numeralTerm = this.term("-", numeralTerm);
                }
                return this.term(div, numeralTerm, this.term(toreal, this.numeral(denom)));
            }
            FunctionSymbol div = this.getFunction("/", this.mNumericSort, this.mNumericSort);
            return this.term(div, this.numeral(num), this.numeral(denom));
        }
        assert (rat.isIntegral());
        return this.numeral(rat.numerator());
    }

    public Term string(String value) {
        return this.constant(new QuotedObject(value), this.mStringSort);
    }

    public Logics getLogic() {
        return this.mLogic;
    }

    FunctionSymbol declareInternalFunction(String name, Sort[] paramTypes, Sort resultType, int flags) {
        return this.defineFunction(name, paramTypes, resultType, null, null, flags | 1);
    }

    FunctionSymbol declareInternalFunction(String name, Sort[] paramTypes, TermVariable[] defVars, Term definition, int flags) {
        return this.defineFunction(name, paramTypes, definition.getSort(), defVars, definition, flags | 1);
    }

    PolymorphicFunctionSymbol declareInternalPolymorphicFunction(String name, Sort[] sortParams, Sort[] paramTypes, Sort resultType, int flags) {
        assert (!this.mFunFactory.containsKey(name));
        PolymorphicFunctionSymbol f = new PolymorphicFunctionSymbol(name, sortParams, paramTypes, resultType, flags | 1);
        this.defineFunction(f);
        return f;
    }

    private void createNumericOperators(Sort sort, boolean isRational) {
        Sort[] sort1 = new Sort[]{sort};
        Sort[] sort2 = new Sort[]{sort, sort};
        this.declareInternalFunction("+", sort2, sort, 2);
        this.defineFunction(new MinusFunctionFactory(sort, sort));
        this.declareInternalFunction("*", sort2, sort, 2);
        if (isRational) {
            this.declareInternalFunction("/", sort2, sort, 2);
        } else {
            this.declareInternalFunction("div", sort2, sort, 2);
            this.declareInternalFunction("mod", sort2, sort, 0);
            this.defineFunction(new DivisibleFunctionFactory());
        }
        Sort sBool = this.mBooleanSort;
        this.declareInternalFunction(">", sort2, sBool, 6);
        this.declareInternalFunction(">=", sort2, sBool, 6);
        this.declareInternalFunction("<", sort2, sBool, 6);
        this.declareInternalFunction("<=", sort2, sBool, 6);
        TermVariable x = this.createTermVariable("x1", sort);
        Term zero = isRational ? this.decimal("0.0") : this.numeral("0");
        ApplicationTerm absx = this.term("ite", this.term(">=", x, zero), x, this.term("-", x));
        this.declareInternalFunction("abs", sort1, new TermVariable[]{x}, absx, 0);
    }

    private void createIRAOperators() {
        class BinArithFactory
        extends FunctionSymbolFactory {
            Sort mReturnSort;
            int mFlags;

            BinArithFactory(String name, Sort returnSort, int flags) {
                super(name);
                this.mReturnSort = returnSort;
                this.mFlags = flags | 1;
            }

            public int getFlags(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                return this.mFlags;
            }

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null && paramSorts.length == 2 && paramSorts[0] == paramSorts[1] && (paramSorts[0] == Theory.this.mNumericSort || paramSorts[0] == Theory.this.mRealSort) && resultSort == null) {
                    return this.mReturnSort == null ? paramSorts[0] : this.mReturnSort;
                }
                return null;
            }
        }
        this.defineFunction(new BinArithFactory("+", null, 2));
        this.defineFunction(new MinusFunctionFactory(this.mNumericSort, this.mRealSort));
        this.defineFunction(new BinArithFactory("*", null, 2));
        this.defineFunction(new BinArithFactory(">", this.mBooleanSort, 6));
        this.defineFunction(new BinArithFactory(">=", this.mBooleanSort, 6));
        this.defineFunction(new BinArithFactory("<", this.mBooleanSort, 6));
        this.defineFunction(new BinArithFactory("<=", this.mBooleanSort, 6));
        Sort[] int1 = new Sort[]{this.mNumericSort};
        Sort[] int2 = new Sort[]{this.mNumericSort, this.mNumericSort};
        Sort[] real1 = new Sort[]{this.mRealSort};
        Sort[] real2 = new Sort[]{this.mRealSort, this.mRealSort};
        this.declareInternalFunction("/", real2, this.mRealSort, 2);
        this.declareInternalFunction("div", int2, this.mNumericSort, 2);
        this.defineFunction(new DivisibleFunctionFactory());
        this.declareInternalFunction("to_real", int1, this.mRealSort, 0);
        this.declareInternalFunction("to_int", real1, this.mNumericSort, 0);
        this.declareInternalFunction("mod", int2, this.mNumericSort, 0);
        TermVariable xr = this.createTermVariable("x1", this.mRealSort);
        ApplicationTerm isintx = this.term("=", xr, this.term("to_real", this.term("to_int", xr)));
        this.declareInternalFunction("is_int", real1, new TermVariable[]{xr}, isintx, 0);
        this.defineFunction(new FunctionSymbolFactory("abs"){

            public Term getDefinition(TermVariable[] tvs, Sort resultSort) {
                Term zero = resultSort == Theory.this.mNumericSort ? Theory.this.numeral("0") : Theory.this.decimal("0.0");
                return Theory.this.term("ite", Theory.this.term(">=", tvs[0], zero), tvs[0], Theory.this.term("-", tvs[0]));
            }

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null && paramSorts.length == 1 && (paramSorts[0] == Theory.this.mNumericSort || paramSorts[0] == Theory.this.mRealSort) && resultSort == null) {
                    return paramSorts[0];
                }
                return null;
            }
        });
    }

    private void createArrayOperators() {
        Sort[] generic2 = this.createSortVariables("X", "Y");
        SortSymbol arraySort = this.declareInternalSort("Array", 2, 16);
        Sort array = arraySort.getSort(null, generic2);
        this.declareInternalPolymorphicFunction("select", generic2, new Sort[]{array, generic2[0]}, generic2[1], 0);
        this.declareInternalPolymorphicFunction("store", generic2, new Sort[]{array, generic2[0], generic2[1]}, array, 0);
    }

    private void createBitVecOperators() {
        this.mBitVecSort = new SortSymbol(this, "BitVec", 0, null, 5){

            public void checkArity(BigInteger[] indices, int arity) {
                if (indices == null || indices.length != 1) {
                    throw new IllegalArgumentException("BitVec needs one index");
                }
                if (indices[0].signum() <= 0) {
                    throw new IllegalArgumentException("BitVec index must be positive");
                }
                if (arity != 0) {
                    throw new IllegalArgumentException("BitVec has no parameters");
                }
            }
        };
        this.mDeclaredSorts.put("BitVec", this.mBitVecSort);
        this.defineFunction(new FunctionSymbolFactory("concat"){

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices != null || paramSorts.length != 2 || resultSort != null || paramSorts[0].getName() != "BitVec" || paramSorts[1].getName() != "BitVec") {
                    return null;
                }
                BigInteger size = paramSorts[0].getIndices()[0].add(paramSorts[1].getIndices()[0]);
                return Theory.this.mBitVecSort.getSort(new BigInteger[]{size}, new Sort[0]);
            }
        });
        this.defineFunction(new FunctionSymbolFactory("extract"){

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length < 2 || paramSorts.length != 1 || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                if (indices[0].compareTo(indices[1]) < 0 || paramSorts[0].getIndices()[0].compareTo(indices[0]) < 0) {
                    return null;
                }
                BigInteger size = indices[0].subtract(indices[1]).add(BigInteger.ONE);
                return Theory.this.mBitVecSort.getSort(new BigInteger[]{size}, new Sort[0]);
            }
        });
        Sort bitvec1 = this.mBitVecSort.getSort(new BigInteger[]{BigInteger.ONE}, new Sort[0]);
        class RegularBitVecFunction
        extends FunctionSymbolFactory {
            int mNumArgs;
            Sort mResult;

            public RegularBitVecFunction(String name, int numArgs, Sort result) {
                super(name);
                this.mNumArgs = numArgs;
                this.mResult = result;
            }

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices != null || paramSorts.length != this.mNumArgs || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                for (int i = 1; i < this.mNumArgs; ++i) {
                    if (paramSorts[i] == paramSorts[0]) continue;
                    return null;
                }
                return this.mResult == null ? paramSorts[0] : this.mResult;
            }
        }
        this.defineFunction(new RegularBitVecFunction("bvnot", 1, null));
        this.defineFunction(new RegularBitVecFunction("bvand", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvor", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvneg", 1, null));
        this.defineFunction(new RegularBitVecFunction("bvadd", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvmul", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvudiv", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvurem", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvshl", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvlshr", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvnand", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvnor", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvxor", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvxnor", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvcomp", 2, bitvec1));
        this.defineFunction(new RegularBitVecFunction("bvsub", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvsdiv", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvsrem", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvsmod", 2, null));
        this.defineFunction(new RegularBitVecFunction("bvashr", 2, null));
        this.defineFunction(new FunctionSymbolFactory("repeat"){

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 1 || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                BigInteger size = indices[0].multiply(paramSorts[0].getIndices()[0]);
                return Theory.this.mBitVecSort.getSort(new BigInteger[]{size}, new Sort[0]);
            }
        });
        class ExtendBitVecFunction
        extends FunctionSymbolFactory {
            public ExtendBitVecFunction(String name) {
                super(name);
            }

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 1 || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                BigInteger size = indices[0].add(paramSorts[0].getIndices()[0]);
                return Theory.this.mBitVecSort.getSort(new BigInteger[]{size}, new Sort[0]);
            }
        }
        this.defineFunction(new ExtendBitVecFunction("zero_extend"));
        this.defineFunction(new ExtendBitVecFunction("sign_extend"));
        class RotateBitVecFunction
        extends FunctionSymbolFactory {
            public RotateBitVecFunction(String name) {
                super(name);
            }

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices == null || indices.length != 1 || paramSorts.length != 1 || resultSort != null || paramSorts[0].getName() != "BitVec") {
                    return null;
                }
                return paramSorts[0];
            }
        }
        this.defineFunction(new RotateBitVecFunction("rotate_left"));
        this.defineFunction(new RotateBitVecFunction("rotate_right"));
        this.defineFunction(new RegularBitVecFunction("bvult", 2, this.mBooleanSort));
        this.defineFunction(new RegularBitVecFunction("bvule", 2, this.mBooleanSort));
        this.defineFunction(new RegularBitVecFunction("bvugt", 2, this.mBooleanSort));
        this.defineFunction(new RegularBitVecFunction("bvuge", 2, this.mBooleanSort));
        this.defineFunction(new RegularBitVecFunction("bvslt", 2, this.mBooleanSort));
        this.defineFunction(new RegularBitVecFunction("bvsle", 2, this.mBooleanSort));
        this.defineFunction(new RegularBitVecFunction("bvsgt", 2, this.mBooleanSort));
        this.defineFunction(new RegularBitVecFunction("bvsge", 2, this.mBooleanSort));
    }

    private void setLogic(Logics logic) {
        this.mLogic = logic;
        if (logic.isArray()) {
            this.createArrayOperators();
        }
        if (logic.isArithmetic()) {
            if (logic.hasReals()) {
                this.mRealSort = this.declareInternalSort("Real", 0, 8).getSort(null, new Sort[0]);
            }
            this.mNumericSort = logic.hasIntegers() ? this.declareInternalSort("Int", 0, 8).getSort(null, new Sort[0]) : this.mRealSort;
            if (logic.isIRA()) {
                this.createIRAOperators();
            } else {
                this.createNumericOperators(this.mNumericSort, logic.hasReals());
            }
        }
        if (logic.isBitVector()) {
            this.createBitVecOperators();
        }
        if (this.mSolverSetup != null) {
            this.mSolverSetup.setLogic(this, logic);
        }
    }

    private SortSymbol defineSort(String name, int paramCount, Sort definition, int flags) {
        if ((flags & 1) == 0 && definition == null && !this.mLogic.isUF() && !this.mLogic.isArray()) {
            throw new IllegalArgumentException("Free sorts are not allowed in this logic");
        }
        SortSymbol sortsym = this.mDeclaredSorts.get(name);
        if (sortsym != null) {
            throw new IllegalArgumentException("Sort " + name + " already exists.");
        }
        sortsym = new SortSymbol(this, name, paramCount, definition, flags);
        this.mDeclaredSorts.put(name, sortsym);
        return sortsym;
    }

    public SortSymbol declareSort(String name, int paramCount) {
        return this.defineSort(name, paramCount, null, 0);
    }

    public SortSymbol defineSort(String name, int paramCount, Sort definition) {
        return this.defineSort(name, paramCount, definition, 0);
    }

    public Sort[] createSortVariables(String ... names) {
        Sort[] sorts = new Sort[names.length];
        for (int i = 0; i < names.length; ++i) {
            sorts[i] = new SortSymbol(this, names[i], i, null, 2).getSort(null, new Sort[0]);
        }
        return sorts;
    }

    SortSymbol declareInternalSort(String name, int paramCount, int flags) {
        return this.defineSort(name, paramCount, null, flags | 1);
    }

    public Sort getSort(String id, Sort ... args) {
        return this.getSort(id, (BigInteger[])null, args);
    }

    public Sort getSort(String id, BigInteger[] indices, Sort ... args) {
        SortSymbol symbol2 = this.mDeclaredSorts.get(id);
        if (symbol2 == null) {
            return null;
        }
        return symbol2.getSort(indices, args);
    }

    public Sort getBooleanSort() {
        return this.mBooleanSort;
    }

    public Sort getNumericSort() {
        return this.mNumericSort;
    }

    public Sort getRealSort() {
        return this.mRealSort;
    }

    public Sort getStringSort() {
        return this.mStringSort;
    }

    private void defineFunction(FunctionSymbolFactory factory) {
        if (this.mFunFactory.put(factory.mFuncName, factory) != null) {
            throw new AssertionError();
        }
    }

    private FunctionSymbol defineFunction(String name, Sort[] paramTypes, Sort resultType, TermVariable[] definitionVars, Term definition, int flags) {
        if ((flags & 1) == 0) {
            if (this.mLogic == null) {
                throw new IllegalArgumentException("Call set-logic first!");
            }
            if (!this.mLogic.isUF() && paramTypes.length > 0 && definition == null) {
                throw new IllegalArgumentException("Free functions are not allowed in this logic!");
            }
        }
        if (name.charAt(0) == '@' && name.matches(MODEL_VALUE_PATTERN)) {
            throw new IllegalArgumentException("Function " + name + " is reserved for internal purposes.");
        }
        if (this.mFunFactory.get(name) != null || this.mDeclaredFuns.get(name) != null) {
            throw new IllegalArgumentException("Function " + name + " is already defined.");
        }
        FunctionSymbol f = new FunctionSymbol(name, null, paramTypes, resultType, definitionVars, definition, flags);
        this.mDeclaredFuns.put(name, f);
        return f;
    }

    public FunctionSymbol declareFunction(String name, Sort[] paramTypes, Sort resultType) {
        return this.defineFunction(name, paramTypes, resultType, null, null, 0);
    }

    public FunctionSymbol defineFunction(String name, TermVariable[] definitionVars, Term definition) {
        Sort[] paramTypes = new Sort[definitionVars.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = definitionVars[i].getSort();
        }
        Sort resultType = definition.getSort();
        return this.defineFunction(name, paramTypes, resultType, definitionVars, definition, 0);
    }

    public FunctionSymbol getFunction(String name, Sort ... paramTypes) {
        return this.getFunctionWithResult(name, null, null, paramTypes);
    }

    private FunctionSymbol getModelValueSymbol(String name, Sort sort) {
        int hash = HashUtils.hashJenkins(name.hashCode(), (Object)sort);
        for (FunctionSymbol symb : this.mModelValueCache.iterateHashCode(hash)) {
            if (!symb.getName().equals(name) || symb.getReturnSort() != sort) continue;
            return symb;
        }
        FunctionSymbol symb = new FunctionSymbol(name, null, EMPTY_SORT_ARRAY, sort, null, null, 49);
        this.mModelValueCache.put(hash, symb);
        return symb;
    }

    public FunctionSymbol getFunctionWithResult(String name, BigInteger[] indices, Sort resultType, Sort ... paramTypes) {
        if (resultType != null && indices == null && paramTypes.length == 0 && name.matches(MODEL_VALUE_PATTERN)) {
            return this.getModelValueSymbol(name, resultType);
        }
        FunctionSymbolFactory factory = this.mFunFactory.get(name);
        if (factory != null) {
            FunctionSymbol fsym = factory.getFunctionWithResult(this, indices, paramTypes, resultType);
            if (fsym != null) {
                return fsym;
            }
            if (this.mLogic.isIRA() && (fsym = factory.getFunctionWithResult(this, indices, new Sort[]{this.mRealSort, this.mRealSort}, resultType)) != null && fsym.typecheck(paramTypes)) {
                return fsym;
            }
            return null;
        }
        FunctionSymbol fsym = this.mDeclaredFuns.get(name);
        if (fsym != null && indices == null && resultType == null && fsym.typecheck(paramTypes)) {
            return fsym;
        }
        return null;
    }

    public ApplicationTerm term(FunctionSymbolFactory factory, Term ... parameters) {
        Sort[] sorts = new Sort[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            sorts[i] = parameters[i].getSort();
        }
        FunctionSymbol fsym = factory.getFunctionWithResult(this, null, sorts, null);
        if (fsym == null) {
            throw new IllegalArgumentException("Did not find overload for function " + factory);
        }
        return this.term(fsym, parameters);
    }

    public ApplicationTerm term(String func, Term ... parameters) {
        Sort[] paramSorts = new Sort[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            paramSorts[i] = parameters[i].getSort();
        }
        FunctionSymbol fsym = this.getFunctionWithResult(func, null, null, paramSorts);
        if (fsym == null) {
            return null;
        }
        return this.term(fsym, parameters);
    }

    public ApplicationTerm term(FunctionSymbol func, Term ... parameters) {
        int hash = ApplicationTerm.hashApplication(func, parameters);
        for (Term t : this.mTermCache.iterateHashCode(hash)) {
            ApplicationTerm app;
            if (!(t instanceof ApplicationTerm) || func != (app = (ApplicationTerm)t).getFunction() || !Arrays.equals(app.getParameters(), parameters)) continue;
            return app;
        }
        ApplicationTerm app = new ApplicationTerm(func, parameters, hash);
        this.mTermCache.put(hash, app);
        return app;
    }

    public TermVariable createFreshTermVariable(String prefix, Sort sort) {
        String name = "." + prefix + "." + this.mTvarCtr++;
        return new TermVariable(name, sort, TermVariable.hashVariable(name, sort));
    }

    public TermVariable createTermVariable(String name, Sort sort) {
        int hash = TermVariable.hashVariable(name, sort);
        for (TermVariable tv : this.mTvUnify.iterateHashCode(hash)) {
            if (!tv.getSort().equals(sort) || !tv.getName().equals(name)) continue;
            return tv;
        }
        TermVariable tv = new TermVariable(name, sort, hash);
        this.mTvUnify.put(hash, tv);
        return tv;
    }

    public Term term(TermVariable var) {
        return var;
    }

    public Term annotatedTerm(Annotation[] annots, Term sub) {
        int hash = AnnotatedTerm.hashAnnotations(annots, sub);
        for (Term t : this.mTermCache.iterateHashCode(hash)) {
            AnnotatedTerm annot;
            if (!(t instanceof AnnotatedTerm) || sub != (annot = (AnnotatedTerm)t).getSubterm() || !Arrays.equals(annot.getAnnotations(), annots)) continue;
            return annot;
        }
        AnnotatedTerm annot = new AnnotatedTerm(annots, sub, hash);
        this.mTermCache.put(hash, annot);
        return annot;
    }

    public void push() {
        this.mDeclaredFuns.beginScope();
        this.mDeclaredSorts.beginScope();
    }

    public void pop() {
        this.mDeclaredFuns.endScope();
        this.mDeclaredSorts.endScope();
    }

    public FunctionSymbol skolemize(TermVariable tv) {
        return new FunctionSymbol("@" + tv.getName() + "_skolem_" + this.mSkolemCounter++, null, EMPTY_SORT_ARRAY, tv.getSort(), null, null, 0);
    }

    class DivisibleFunctionFactory
    extends FunctionSymbolFactory {
        public DivisibleFunctionFactory() {
            super("divisible");
        }

        public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
            return indices != null && indices.length == 1 && indices[0].signum() > 0 && paramSorts.length == 1 && paramSorts[0] == Theory.this.mNumericSort && resultSort == null ? Theory.this.mBooleanSort : null;
        }
    }

    class MinusFunctionFactory
    extends FunctionSymbolFactory {
        Sort mSort1;
        Sort mSort2;

        public MinusFunctionFactory(Sort sort1, Sort sort2) {
            super("-");
            this.mSort1 = sort1;
            this.mSort2 = sort2;
        }

        public int getFlags(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
            return paramSorts.length == 1 ? 1 : 3;
        }

        public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
            if (indices != null || paramSorts.length == 0 || paramSorts.length > 2 || resultSort != null || paramSorts[0] != this.mSort1 && paramSorts[0] != this.mSort2) {
                return null;
            }
            if (paramSorts.length == 2 && paramSorts[0] != paramSorts[1]) {
                return null;
            }
            return paramSorts[0];
        }
    }

    public static abstract class SolverSetup {
        public abstract void setLogic(Theory var1, Logics var2);

        protected final void declareInternalSort(Theory theory, String name, int cardinality, int flags) {
            theory.declareInternalSort(name, cardinality, flags);
        }

        protected final void declareInternalFunction(Theory theory, String name, Sort[] paramSorts, Sort resultSort, int flags) {
            theory.declareInternalFunction(name, paramSorts, resultSort, flags);
        }

        protected final void declareInternalFunction(Theory theory, String name, Sort[] paramTypes, TermVariable[] defVars, Term definition, int flags) {
            theory.declareInternalFunction(name, paramTypes, defVars, definition, flags);
        }

        protected final void declareInternalPolymorphicFunction(Theory theory, String name, Sort[] sortParams, Sort[] paramTypes, Sort resultType, int flags) {
            theory.declareInternalPolymorphicFunction(name, sortParams, paramTypes, resultType, flags);
        }

        protected final void defineFunction(Theory theory, FunctionSymbolFactory factory) {
            theory.defineFunction(factory);
        }
    }
}

