/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.CollectionsHelper;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferencePreparation {
    private final Theory mTeory;
    private final Set<TermVariable> mVars;
    private final Stack<Term> mBoolTerms;
    private Term mSubst;
    private ApplicationTerm mIte;

    public InferencePreparation(Theory theory, Set<TermVariable> vars) {
        this.mTeory = theory;
        this.mVars = vars;
        this.mBoolTerms = new Stack();
    }

    public Term prepare(Term body) {
        assert (body.getSort() == this.mTeory.getBooleanSort()) : "Non-boolean term as quantifier sub?";
        FormulaUnLet unflet = new FormulaUnLet(FormulaUnLet.UnletType.EXPAND_DEFINITIONS);
        return this.recprepare(unflet.unlet(body));
    }

    private Term recprepare(Term subterm) {
        if (!CollectionsHelper.containsAny(subterm.getFreeVars(), this.mVars)) {
            return subterm;
        }
        while (subterm instanceof AnnotatedTerm) {
            subterm = ((AnnotatedTerm)subterm).getSubterm();
        }
        if (subterm instanceof ApplicationTerm) {
            ApplicationTerm app = (ApplicationTerm)subterm;
            if (app.getSort() == this.mTeory.getBooleanSort()) {
                this.mBoolTerms.push(subterm);
            } else if (app.getFunction().isIntern() && app.getFunction().getName().equals("ite")) {
                this.mIte = app;
                this.mSubst = this.mIte;
                return null;
            }
            Term[] params = app.getParameters();
            Term[] newparams = new Term[params.length];
            for (int i = 0; i < params.length; ++i) {
                newparams[i] = this.recprepare(params[i]);
                while (newparams[i] == null) {
                    if (this.mBoolTerms.peek() != subterm) {
                        return null;
                    }
                    if (this.mBoolTerms.peek() != subterm) continue;
                    this.mBoolTerms.pop();
                    return this.recprepare(this.generateIte(subterm));
                }
            }
            if (this.mBoolTerms.peek() == subterm) {
                this.mBoolTerms.pop();
            }
            return this.mTeory.term(app.getFunction(), newparams);
        }
        return subterm;
    }

    private Term generateIte(Term subterm) {
        Term trueCase = this.generateCase(subterm, true);
        Term falseCase = this.generateCase(subterm, false);
        Term res = this.mTeory.ifthenelse(this.mIte.getParameters()[0], trueCase, falseCase);
        this.mIte = null;
        this.mSubst = null;
        return res;
    }

    private Term generateCase(Term subterm, boolean which) {
        while (subterm instanceof AnnotatedTerm) {
            subterm = ((AnnotatedTerm)subterm).getSubterm();
        }
        if (subterm == this.mSubst) {
            return this.mIte.getParameters()[which ? 1 : 2];
        }
        if (subterm instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)subterm;
            Term[] params = at.getParameters();
            Term[] newparams = new Term[params.length];
            boolean changed = false;
            for (int i = 0; i < params.length; ++i) {
                newparams[i] = this.generateCase(params[i], which);
                changed |= params[i] != newparams[i];
            }
            return changed ? this.mTeory.term(at.getFunction(), newparams) : at;
        }
        return subterm;
    }
}

