/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;

public class SubtermChecker
extends NonRecursive {
    private final Term mSubTerm;
    private boolean mFound = false;

    public SubtermChecker(Term subterm) {
        this.mSubTerm = subterm;
    }

    public boolean findSubterm(Term where) {
        this.run(new IsSubterm(where));
        return this.mFound;
    }

    public void reset() {
        super.reset();
        this.mFound = false;
    }

    private void done() {
        super.reset();
    }

    private static final class IsSubterm
    extends NonRecursive.TermWalker {
        public IsSubterm(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker) {
            SubtermChecker sc = (SubtermChecker)walker;
            if (this.getTerm() == sc.mSubTerm) {
                sc.mFound = true;
                sc.done();
            } else if (this.getTerm() instanceof SMTAffineTerm) {
                SMTAffineTerm at = (SMTAffineTerm)this.getTerm();
                for (Term s : at.getSummands().keySet()) {
                    walker.enqueueWalker(new IsSubterm(s));
                }
            } else {
                super.walk(walker);
            }
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker(new IsSubterm(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            for (Term p : term.getParameters()) {
                walker.enqueueWalker(new IsSubterm(p));
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("LetTerms should not be present!");
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            walker.enqueueWalker(new IsSubterm(term.getSubformula()));
        }

        public void walk(NonRecursive walker, TermVariable term) {
        }
    }
}

