/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.InferencePreparation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.CollectionsHelper;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerCandidateMap {
    private final Logger mLogger;
    private final HashMap<FunctionSymbol, List<ApplicationTerm>> mFuncs;
    private final Set<ApplicationTerm> mUnitCandidates;
    private final Theory mTheory;
    private Set<TermVariable> mVars;

    public TriggerCandidateMap(Logger logger, Theory theory, Set<TermVariable> vars) {
        this.mLogger = logger;
        this.mFuncs = new HashMap();
        this.mUnitCandidates = new LinkedHashSet<ApplicationTerm>();
        this.mTheory = theory;
        this.mVars = vars;
    }

    public void insert(Term term) {
        assert (term.getSort() == this.mTheory.getBooleanSort()) : "Inserting non-boolean term";
        InferencePreparation ip = new InferencePreparation(this.mTheory, this.mVars);
        this.recinsert(ip.prepare(term));
    }

    private boolean recinsert(Term term) {
        if (term.getFreeVars() == null || term.getFreeVars().length == 0) {
            return false;
        }
        if (term instanceof AnnotatedTerm) {
            term = ((AnnotatedTerm)term).getSubterm();
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm fat = (ApplicationTerm)term;
            Term[] params = fat.getParameters();
            boolean internal = false;
            for (Term param : params) {
                internal |= this.recinsert(param);
            }
            if (internal) {
                return true;
            }
            FunctionSymbol fs = fat.getFunction();
            if (this.isFunctionAllowedInTrigger(fs)) {
                List<ApplicationTerm> fapps = this.mFuncs.get(fs);
                if (fapps == null) {
                    fapps = new ArrayList<ApplicationTerm>();
                    this.mFuncs.put(fs, fapps);
                }
                if (this.mVars.containsAll(Arrays.asList(term.getFreeVars()))) {
                    this.mUnitCandidates.add(fat);
                }
                fapps.add(fat);
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean isFunctionAllowedInTrigger(FunctionSymbol fs) {
        return !fs.isIntern() || fs.getName().equals("=") || fs.getName().equals("select") || fs.getName().equals("store");
    }

    public boolean isLoopingPattern(ApplicationTerm candidate) {
        List<ApplicationTerm> fapps = this.mFuncs.get(candidate.getFunction());
        assert (fapps != null) : "Pattern candidate does not occur in the sub";
        for (ApplicationTerm at : fapps) {
            if (at == candidate || !this.hasVarMatchError(candidate, at)) continue;
            this.mLogger.debug(new DebugMessage("Pattern candidate {0} dropped. It is looping against {1}...", candidate, at));
            return true;
        }
        return false;
    }

    private boolean hasVarMatchError(Term candidate, Term fat) {
        if (candidate instanceof TermVariable && !(fat instanceof TermVariable)) {
            return fat.getFreeVars() != null && Arrays.asList(fat.getFreeVars()).contains(candidate);
        }
        if (candidate instanceof ApplicationTerm && fat instanceof ApplicationTerm) {
            ApplicationTerm capp = (ApplicationTerm)candidate;
            ApplicationTerm fapp = (ApplicationTerm)fat;
            if (capp.getFunction() == fapp.getFunction()) {
                Term[] cparams = capp.getParameters();
                Term[] fparams = fapp.getParameters();
                assert (cparams.length == fparams.length);
                for (int i = 0; i < cparams.length; ++i) {
                    if (!this.hasVarMatchError(cparams[i], fparams[i])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Term[] getMultiTrigger() {
        for (int trigsize = 2; trigsize <= this.mVars.size(); ++trigsize) {
            Set<Term> trigs = this.getMultiTrigger(trigsize);
            if (trigs == null) continue;
            assert (trigs.size() == trigsize);
            return trigs.toArray(new Term[trigs.size()]);
        }
        return null;
    }

    private Set<Term> getMultiTrigger(int trigsize) {
        HashSet<TermVariable> uncovered = new HashSet<TermVariable>(this.mVars.size(), 1.0f);
        uncovered.addAll(this.mVars);
        HashSet<Term> candidate = new HashSet<Term>(trigsize, 1.0f);
        for (List<ApplicationTerm> fapps : this.mFuncs.values()) {
            for (ApplicationTerm fat : fapps) {
                candidate.add(fat);
                assert (fat.getFreeVars() != null && fat.getFreeVars().length != 0);
                List<TermVariable> termVars = Arrays.asList(fat.getFreeVars());
                uncovered.removeAll(termVars);
                if (this.completeMultiTrigger(candidate, uncovered, trigsize - 1)) {
                    return candidate;
                }
                uncovered.addAll(termVars);
                candidate.remove(fat);
            }
        }
        return null;
    }

    private boolean completeMultiTrigger(HashSet<Term> candidate, HashSet<TermVariable> uncovered, int trigsize) {
        if (trigsize == 0) {
            return uncovered.isEmpty();
        }
        for (List<ApplicationTerm> fapps : this.mFuncs.values()) {
            for (ApplicationTerm fat : fapps) {
                List<TermVariable> tvs = Arrays.asList(fat.getFreeVars());
                if (!CollectionsHelper.containsAny(uncovered, tvs) || !candidate.add(fat)) continue;
                uncovered.removeAll(tvs);
                if (this.completeMultiTrigger(candidate, uncovered, trigsize - 1)) {
                    return true;
                }
                uncovered.addAll(tvs);
                candidate.remove(fat);
            }
        }
        return false;
    }

    public Term[] getAllUnitTriggers() {
        HashSet<ApplicationTerm> unittrigs = new HashSet<ApplicationTerm>();
        HashSet<ApplicationTerm> considered = new HashSet<ApplicationTerm>();
        block0: for (ApplicationTerm c : this.mUnitCandidates) {
            for (Term t : c.getParameters()) {
                if (!considered.contains(t)) continue;
                considered.add(c);
                continue block0;
            }
            TermVariable[] fvars = c.getFreeVars();
            HashSet<TermVariable> vars = new HashSet<TermVariable>(fvars.length, 1.0f);
            for (TermVariable tv : fvars) {
                vars.add(tv);
            }
            if (!vars.equals(this.mVars) || this.isLoopingPattern(c)) continue;
            unittrigs.add(c);
            considered.add(c);
        }
        return unittrigs.isEmpty() ? null : unittrigs.toArray(new Term[unittrigs.size()]);
    }

    public void reinit(Set<TermVariable> vars) {
        this.mFuncs.clear();
        this.mUnitCandidates.clear();
        this.mVars = vars;
    }
}

