/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import java.util.LinkedHashSet;

public class Utils {
    private final IProofTracker mTracker;

    public Utils(IProofTracker tracker) {
        this.mTracker = tracker;
    }

    public Term createNot(Term arg) {
        Theory theory = arg.getTheory();
        if (arg == theory.mFalse) {
            this.mTracker.negation(arg, theory.mTrue, 14);
            return theory.mTrue;
        }
        if (arg == theory.mTrue) {
            this.mTracker.negation(arg, theory.mFalse, 14);
            return theory.mFalse;
        }
        if (arg instanceof ApplicationTerm && ((ApplicationTerm)arg).getFunction().getName().equals("not")) {
            Term res = ((ApplicationTerm)arg).getParameters()[0];
            this.mTracker.negation(arg, res, 14);
            return res;
        }
        return theory.term("not", arg);
    }

    public static Term createNotUntracked(Term arg) {
        Theory theory = arg.getTheory();
        if (arg == theory.mFalse) {
            return theory.mTrue;
        }
        if (arg == theory.mTrue) {
            return theory.mFalse;
        }
        if (arg instanceof ApplicationTerm && ((ApplicationTerm)arg).getFunction().getName().equals("not")) {
            return ((ApplicationTerm)arg).getParameters()[0];
        }
        return theory.term("not", arg);
    }

    public Term createOr(Term ... args) {
        Term res;
        LinkedHashSet<Term> ctx = new LinkedHashSet<Term>();
        Theory theory = args[0].getTheory();
        ApplicationTerm trueTerm = theory.mTrue;
        ApplicationTerm falseTerm = theory.mFalse;
        for (Term t : args) {
            if (t == trueTerm) {
                this.mTracker.or(args, t, 16);
                return t;
            }
            if (t == falseTerm) continue;
            if (ctx.contains(Utils.createNotUntracked(t))) {
                this.mTracker.or(args, trueTerm, 16);
                return trueTerm;
            }
            ctx.add(t);
        }
        if (ctx.isEmpty()) {
            this.mTracker.or(args, theory.mFalse, 15);
            return theory.mFalse;
        }
        if (ctx.size() == 1) {
            res = (Term)ctx.iterator().next();
            this.mTracker.or(args, res, 15);
            return res;
        }
        if (ctx.size() == args.length) {
            return theory.term(theory.mOr, args);
        }
        res = theory.term(theory.mOr, ctx.toArray(new Term[ctx.size()]));
        this.mTracker.or(args, res, 15);
        return res;
    }

    public Term createLeq0(Term arg) {
        SMTAffineTerm at;
        if (arg instanceof SMTAffineTerm && (at = (SMTAffineTerm)arg).isConstant()) {
            Theory t = arg.getTheory();
            if (at.getConstant().compareTo(Rational.ZERO) > 0) {
                this.mTracker.leqSimp(at, t.mFalse, 36);
                return t.mFalse;
            }
            this.mTracker.leqSimp(at, t.mTrue, 35);
            return t.mTrue;
        }
        return arg.getTheory().term("<=", arg, SMTAffineTerm.create(Rational.ZERO, arg.getSort()));
    }

    public Term createIte(Term cond, Term trueBranch, Term falseBranch) {
        Theory theory = cond.getTheory();
        if (cond == theory.mTrue) {
            this.mTracker.ite(cond, trueBranch, falseBranch, trueBranch, 17);
            return trueBranch;
        }
        if (cond == theory.mFalse) {
            this.mTracker.ite(cond, trueBranch, falseBranch, falseBranch, 18);
            return falseBranch;
        }
        if (trueBranch == falseBranch) {
            this.mTracker.ite(cond, trueBranch, falseBranch, trueBranch, 19);
            return trueBranch;
        }
        if (trueBranch == theory.mTrue && falseBranch == theory.mFalse) {
            this.mTracker.ite(cond, trueBranch, falseBranch, cond, 20);
            return cond;
        }
        if (trueBranch == theory.mFalse && falseBranch == theory.mTrue) {
            this.mTracker.ite(cond, trueBranch, falseBranch, null, 21);
            return this.createNot(cond);
        }
        if (trueBranch == theory.mTrue) {
            ApplicationTerm res = theory.term("or", cond, falseBranch);
            this.mTracker.ite(cond, trueBranch, falseBranch, res, 22);
            return this.createOr(cond, falseBranch);
        }
        if (trueBranch == theory.mFalse) {
            this.mTracker.ite(cond, trueBranch, falseBranch, null, 23);
            return this.createNot(this.createOr(cond, this.createNot(falseBranch)));
        }
        if (falseBranch == theory.mTrue) {
            this.mTracker.ite(cond, trueBranch, falseBranch, null, 24);
            return this.createOr(this.createNot(cond), trueBranch);
        }
        if (falseBranch == theory.mFalse) {
            this.mTracker.ite(cond, trueBranch, falseBranch, null, 25);
            return this.createNot(this.createOr(this.createNot(cond), this.createNot(trueBranch)));
        }
        return theory.term("ite", cond, trueBranch, falseBranch);
    }

    public Term createEq(Term ... args) {
        Term[] tmpArray;
        LinkedHashSet<Term> tmp = new LinkedHashSet<Term>();
        Theory theory = args[0].getTheory();
        if (args[0].getSort().isNumericSort()) {
            Rational lastConst = null;
            for (Term t : args) {
                SMTAffineTerm at;
                if ((t instanceof ConstantTerm || t instanceof SMTAffineTerm) && (at = SMTAffineTerm.create(t)).isConstant()) {
                    if (lastConst == null) {
                        lastConst = at.getConstant();
                    } else if (!lastConst.equals(at.getConstant())) {
                        this.mTracker.equality(args, theory.mFalse, 3);
                        return theory.mFalse;
                    }
                }
                tmp.add(t);
            }
        } else if (args[0].getSort() == theory.getBooleanSort()) {
            Term[] tmpArgs;
            boolean foundTrue = false;
            boolean foundFalse = false;
            for (Term t : args) {
                if (t == theory.mTrue) {
                    foundTrue = true;
                    if (!foundFalse) continue;
                    this.mTracker.equality(args, theory.mFalse, 2);
                    return theory.mFalse;
                }
                if (t == theory.mFalse) {
                    foundFalse = true;
                    if (!foundTrue) continue;
                    this.mTracker.equality(args, theory.mFalse, 2);
                    return theory.mFalse;
                }
                tmp.add(t);
            }
            if (foundTrue) {
                if (tmp.isEmpty()) {
                    this.mTracker.equality(args, theory.mTrue, 47);
                    return theory.mTrue;
                }
                tmpArgs = tmp.toArray(new Term[tmp.size()]);
                this.mTracker.equality(args, tmpArgs, 4);
                if (tmpArgs.length == 1) {
                    return tmpArgs[0];
                }
                return this.createAndInplace(tmpArgs);
            }
            if (foundFalse) {
                if (tmp.isEmpty()) {
                    this.mTracker.equality(args, theory.mTrue, 47);
                    return theory.mTrue;
                }
                tmpArgs = tmp.toArray(new Term[tmp.size()]);
                this.mTracker.equality(args, tmpArgs, 5);
                if (tmpArgs.length == 1) {
                    return this.createNot(tmpArgs[0]);
                }
                return this.createNot(this.createOr(tmpArgs));
            }
        } else {
            for (Term t : args) {
                tmp.add(t);
            }
        }
        if (tmp.size() == 1) {
            this.mTracker.equality(args, theory.mTrue, 47);
            return theory.mTrue;
        }
        Term[] termArray = tmpArray = tmp.size() == args.length ? args : tmp.toArray(new Term[tmp.size()]);
        if (args != tmpArray) {
            this.mTracker.equality(args, tmpArray, 6);
        }
        if (tmpArray.length == 2) {
            return this.makeBinaryEq(tmpArray);
        }
        Term[] conj = new Term[tmpArray.length - 1];
        for (int i = 0; i < conj.length; ++i) {
            conj[i] = theory.term("not", this.makeBinaryEq(tmpArray[i], tmpArray[i + 1]));
        }
        ApplicationTerm res = theory.term("not", theory.term("or", conj));
        this.mTracker.equality(tmpArray, res, 7);
        return res;
    }

    private Term storeRewrite(ApplicationTerm store, boolean arrayFirst) {
        assert (this.isStore(store)) : "Not a store in storeRewrite";
        Theory t = store.getTheory();
        Term[] args = store.getParameters();
        ApplicationTerm result = t.term("=", t.term("select", args[0], args[1]), args[2]);
        this.mTracker.storeRewrite(store, result, arrayFirst);
        return result;
    }

    private boolean isStore(Term t) {
        if (t instanceof ApplicationTerm) {
            FunctionSymbol fs = ((ApplicationTerm)t).getFunction();
            return fs.isIntern() && fs.getName().equals("store");
        }
        return false;
    }

    private Term makeBinaryEq(Term ... args) {
        assert (args.length == 2) : "Non-binary equality in makeBinaryEq";
        if (args[0].getSort().isArraySort()) {
            Term array;
            if (this.isStore(args[0]) && args[1] == (array = ((ApplicationTerm)args[0]).getParameters()[0])) {
                return this.storeRewrite((ApplicationTerm)args[0], false);
            }
            if (this.isStore(args[1]) && args[0] == (array = ((ApplicationTerm)args[1]).getParameters()[0])) {
                return this.storeRewrite((ApplicationTerm)args[1], true);
            }
        }
        return args[0].getTheory().term("=", args);
    }

    public Term createDistinct(Term ... args) {
        Theory theory = args[0].getTheory();
        if (args[0].getSort() == theory.getBooleanSort()) {
            if (args.length > 2) {
                this.mTracker.distinct(args, theory.mFalse, 8);
                return theory.mFalse;
            }
            Term t0 = args[0];
            Term t1 = args[1];
            if (t0 == t1) {
                this.mTracker.distinct(args, theory.mFalse, 9);
                return theory.mFalse;
            }
            if (t0 == Utils.createNotUntracked(t1)) {
                this.mTracker.distinct(args, theory.mTrue, 10);
                return theory.mTrue;
            }
            if (t0 == theory.mTrue) {
                this.mTracker.distinct(args, null, 11);
                return this.createNot(t1);
            }
            if (t0 == theory.mFalse) {
                this.mTracker.distinct(args, t1, 12);
                return t1;
            }
            if (t1 == theory.mTrue) {
                this.mTracker.distinct(args, null, 11);
                return this.createNot(t0);
            }
            if (t1 == theory.mFalse) {
                this.mTracker.distinct(args, t0, 12);
                return t0;
            }
            if (Utils.isNegation(t0)) {
                this.mTracker.distinctBoolEq(t0, t1, true);
                return theory.term("=", this.createNot(t0), t1);
            }
            this.mTracker.distinctBoolEq(t0, t1, false);
            return theory.term("=", t0, this.createNot(t1));
        }
        LinkedHashSet<Term> tmp = new LinkedHashSet<Term>();
        for (Term t : args) {
            if (tmp.add(t)) continue;
            this.mTracker.distinct(args, theory.mFalse, 9);
            return theory.mFalse;
        }
        tmp = null;
        if (args.length == 2) {
            ApplicationTerm res = theory.term("not", theory.term("=", args));
            this.mTracker.distinct(args, res, 13);
            return res;
        }
        Term[] nconjs = new Term[args.length * (args.length - 1) / 2];
        int pos = 0;
        for (int i = 0; i < args.length - 1; ++i) {
            for (int j = i + 1; j < args.length; ++j) {
                nconjs[pos++] = theory.term("=", args[i], args[j]);
            }
        }
        ApplicationTerm res = theory.term("not", theory.term("or", nconjs));
        this.mTracker.distinct(args, res, 13);
        return res;
    }

    public static boolean isNegation(Term t) {
        if (t instanceof ApplicationTerm) {
            return ((ApplicationTerm)t).getFunction() == t.getTheory().mNot;
        }
        return false;
    }

    public Term createAndInplace(Term ... args) {
        assert (args.length > 1) : "Invalid and in simplification";
        this.mTracker.removeConnective(args, null, 26);
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.createNot(args[i]);
        }
        return this.createNot(this.createOr(args));
    }

    public Term createAnd(Term ... args) {
        args = (Term[])args.clone();
        return this.createAndInplace(args);
    }
}

