/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;

public abstract class DPLLAtom
extends Literal {
    int mDecideLevel = -1;
    int mStackPosition = -1;
    Literal mDecideStatus;
    Literal mLastStatus;
    double mActivity;
    public Object mExplanation;
    Clause.WatchList mBacktrackWatchers = new Clause.WatchList();
    int mAtomQueueIndex = -1;
    final int mAssertionstacklevel;

    public DPLLAtom(int hash, int assertionstacklevel) {
        super(hash);
        this.mAtom = this;
        this.mNegated = new NegLiteral(this);
        this.mAssertionstacklevel = assertionstacklevel;
        this.mLastStatus = this.mNegated;
    }

    public final int compareActivityTo(DPLLAtom other) {
        return this.mActivity < other.mActivity ? 1 : (this.mActivity == other.mActivity ? 0 : -1);
    }

    public int getSign() {
        return 1;
    }

    public final int getDecideLevel() {
        return this.mDecideLevel;
    }

    public final int getStackPosition() {
        return this.mStackPosition;
    }

    public String toStringNegated() {
        return "!(" + this.toString() + ")";
    }

    public final Term getNegatedSMTFormula(Theory smtTheory, boolean useAuxVars) {
        return smtTheory.not(this.getSMTFormula(smtTheory, useAuxVars));
    }

    public Literal getDecideStatus() {
        return this.mDecideStatus;
    }

    public int getAssertionStackLevel() {
        return this.mAssertionstacklevel;
    }

    public void setPreferredStatus(Literal status) {
        this.mLastStatus = status;
    }

    public Literal getPreferredStatus() {
        return this.mLastStatus;
    }

    public static class NegLiteral
    extends Literal {
        public NegLiteral(DPLLAtom atom) {
            super(~atom.hashCode());
            this.mAtom = atom;
            this.mNegated = atom;
        }

        public int getSign() {
            return -1;
        }

        public String toString() {
            return this.mAtom.toStringNegated();
        }

        public Term getSMTFormula(Theory smtTheory, boolean quoted) {
            return this.mAtom.getNegatedSMTFormula(smtTheory, quoted);
        }
    }

    public static class TrueAtom
    extends DPLLAtom {
        public TrueAtom() {
            super(0, 0);
            this.mDecideStatus = this;
            this.mDecideLevel = 0;
        }

        public Term getSMTFormula(Theory smtTheory, boolean quoted) {
            return smtTheory.mTrue;
        }
    }
}

