/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArrayValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;

public class ModelEvaluator
extends NonRecursive {
    HashMap<Term, Integer> mCache = new HashMap();
    ArrayDeque<Integer> mEvaluated = new ArrayDeque();
    private final Model mModel;

    private Integer getConverted() {
        return this.mEvaluated.removeLast();
    }

    public int getValue(FunctionSymbol fs, int[] args, ApplicationTerm term) {
        if (fs.isInterpreted()) {
            return this.interpret(fs, args, term);
        }
        return this.evalFunction(fs, args);
    }

    public void pushTerms(Term[] terms) {
        for (int i = terms.length - 1; i >= 0; --i) {
            this.pushTerm(terms[i]);
        }
    }

    public int[] getConvertedArgs(int length) {
        int[] result = new int[length];
        while (--length >= 0) {
            result[length] = this.getConverted();
        }
        return result;
    }

    public void pushTerm(Term term) {
        this.enqueueWalker(new CachedEvaluator(term));
    }

    private void setResult(int res) {
        this.mEvaluated.addLast(res);
    }

    public ModelEvaluator(Model model) {
        this.mModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Term evaluate(Term input) {
        try {
            this.run(new CachedEvaluator(input));
            int res = this.getConverted();
            Term term = this.mModel.toModelTerm(res, input.getSort());
            return term;
        }
        finally {
            this.reset();
        }
    }

    private int evalFunction(FunctionSymbol fs, int ... args) {
        FunctionValue val = this.mModel.getFunctionValue(fs);
        if (val == null) {
            val = this.mModel.map(fs, 0);
        }
        return val.get(args, this.mModel.isPartialModel());
    }

    private int interpret(FunctionSymbol fun, int[] args, ApplicationTerm term) {
        int i;
        int i2;
        if (fun.isModelValue()) {
            return Integer.parseInt(fun.getName().substring(1));
        }
        Theory theory = this.mModel.getTheory();
        if (fun == theory.mTrue.getFunction()) {
            return this.mModel.getTrueIdx();
        }
        if (fun == theory.mFalse.getFunction()) {
            return this.mModel.getFalseIdx();
        }
        if (fun == theory.mAnd) {
            int res = args[0];
            for (int arg : args) {
                if (arg == -1) {
                    res = -1;
                } else if (arg == this.mModel.getFalseIdx()) {
                    return arg;
                }
                assert (arg == -1 || arg == this.mModel.getTrueIdx());
            }
            return res;
        }
        if (fun == theory.mOr) {
            int res = args[0];
            for (int arg : args) {
                if (arg == -1) {
                    res = arg;
                } else if (arg == this.mModel.getTrueIdx()) {
                    return arg;
                }
                assert (arg == -1 || arg == this.mModel.getFalseIdx());
            }
            return res;
        }
        if (fun == theory.mImplies) {
            int val = args[args.length - 1];
            for (int i3 = args.length - 2; i3 >= 0; --i3) {
                int argi = args[i3];
                if (val == this.mModel.getTrueIdx() || argi == this.mModel.getFalseIdx()) {
                    val = this.mModel.getTrueIdx();
                    continue;
                }
                if (argi == this.mModel.getTrueIdx() && val == this.mModel.getFalseIdx()) continue;
                val = -1;
            }
            return val;
        }
        for (int arg : args) {
            if (arg != -1) continue;
            return arg;
        }
        if (fun == theory.mNot) {
            return args[0] == this.mModel.getTrueIdx() ? this.mModel.getFalseIdx() : this.mModel.getTrueIdx();
        }
        if (fun == theory.mXor) {
            int val = args[0];
            for (i2 = 1; i2 < args.length; ++i2) {
                int argi = args[i2];
                val = argi == val ? this.mModel.getFalseIdx() : this.mModel.getTrueIdx();
            }
            return val;
        }
        String name = fun.getName();
        if (name.equals("=")) {
            for (i2 = 1; i2 < args.length; ++i2) {
                if (args[i2] == args[0]) continue;
                return this.mModel.getFalseIdx();
            }
            return this.mModel.getTrueIdx();
        }
        if (name.equals("distinct")) {
            HashSet<Integer> vals = new HashSet<Integer>();
            for (int arg : args) {
                if (vals.add(arg)) continue;
                return this.mModel.getFalseIdx();
            }
            return this.mModel.getTrueIdx();
        }
        if (name.equals("ite")) {
            assert (args.length == 3);
            int selector = args[0];
            return args[selector + 1];
        }
        if (name.equals("+")) {
            Rational val = this.rationalValue(args[0]);
            for (i = 1; i < args.length; ++i) {
                val = val.add(this.rationalValue(args[i]));
            }
            return this.mModel.getNumericSortInterpretation().extend(val);
        }
        if (name.equals("-")) {
            Rational val = this.rationalValue(args[0]);
            if (args.length == 1) {
                return this.mModel.getNumericSortInterpretation().extend(val.negate());
            }
            for (i = 1; i < args.length; ++i) {
                val = val.sub(this.rationalValue(args[i]));
            }
            return this.mModel.getNumericSortInterpretation().extend(val);
        }
        if (name.equals("*")) {
            Rational val = this.rationalValue(args[0]);
            for (i = 1; i < args.length; ++i) {
                val = val.mul(this.rationalValue(args[i]));
            }
            return this.mModel.getNumericSortInterpretation().extend(val);
        }
        if (name.equals("/")) {
            Rational val = this.rationalValue(args[0]);
            for (i = 1; i < args.length; ++i) {
                Rational divisor = this.rationalValue(args[i]);
                if (divisor.equals(Rational.ZERO)) {
                    int idx;
                    FunctionSymbol div0 = theory.getFunction("@/0", fun.getReturnSort());
                    int divval = this.evalFunction(div0, idx = this.mModel.getNumericSortInterpretation().extend(val));
                    if (divval == -1) {
                        return -1;
                    }
                    val = this.rationalValue(divval);
                    continue;
                }
                val = val.div(divisor);
            }
            return this.mModel.getNumericSortInterpretation().extend(val);
        }
        if (name.equals("<=")) {
            for (i2 = 1; i2 < args.length; ++i2) {
                Rational arg2;
                Rational arg1 = this.rationalValue(args[i2 - 1]);
                if (arg1.compareTo(arg2 = this.rationalValue(args[i2])) <= 0) continue;
                return this.mModel.getFalseIdx();
            }
            return this.mModel.getTrueIdx();
        }
        if (name.equals("<")) {
            for (i2 = 1; i2 < args.length; ++i2) {
                Rational arg2;
                Rational arg1 = this.rationalValue(args[i2 - 1]);
                if (arg1.compareTo(arg2 = this.rationalValue(args[i2])) < 0) continue;
                return this.mModel.getFalseIdx();
            }
            return this.mModel.getTrueIdx();
        }
        if (name.equals(">=")) {
            for (i2 = 1; i2 < args.length; ++i2) {
                Rational arg2;
                Rational arg1 = this.rationalValue(args[i2 - 1]);
                if (arg1.compareTo(arg2 = this.rationalValue(args[i2])) >= 0) continue;
                return this.mModel.getFalseIdx();
            }
            return this.mModel.getTrueIdx();
        }
        if (name.equals(">")) {
            for (i2 = 1; i2 < args.length; ++i2) {
                Rational arg2;
                Rational arg1 = this.rationalValue(args[i2 - 1]);
                if (arg1.compareTo(arg2 = this.rationalValue(args[i2])) > 0) continue;
                return this.mModel.getFalseIdx();
            }
            return this.mModel.getTrueIdx();
        }
        if (name.equals("div")) {
            Rational val = this.rationalValue(args[0]);
            for (i = 1; i < args.length; ++i) {
                Rational n = this.rationalValue(args[i]);
                if (n.equals(Rational.ZERO)) {
                    int idx;
                    FunctionSymbol div0 = theory.getFunction("@div0", fun.getReturnSort());
                    int divval = this.evalFunction(div0, idx = this.mModel.getNumericSortInterpretation().extend(val));
                    if (divval == -1) {
                        return -1;
                    }
                    val = this.rationalValue(divval);
                    continue;
                }
                Rational div = val.div(n);
                val = n.isNegative() ? div.ceil() : div.floor();
            }
            return this.mModel.getNumericSortInterpretation().extend(val);
        }
        if (name.equals("mod")) {
            assert (args.length == 2);
            Rational n = this.rationalValue(args[1]);
            if (n.equals(Rational.ZERO)) {
                FunctionSymbol div0 = theory.getFunction("@mod0", fun.getReturnSort());
                return this.evalFunction(div0, args[0]);
            }
            Rational m = this.rationalValue(args[0]);
            Rational div = m.div(n);
            div = n.isNegative() ? div.ceil() : div.floor();
            return this.mModel.getNumericSortInterpretation().extend(m.sub(div.mul(n)));
        }
        if (name.equals("abs")) {
            assert (args.length == 1);
            Rational arg = this.rationalValue(args[0]);
            return this.mModel.getNumericSortInterpretation().extend(arg.abs());
        }
        if (name.equals("divisible")) {
            assert (args.length == 1);
            Rational arg = this.rationalValue(args[0]);
            BigInteger[] indices = fun.getIndices();
            assert (indices.length == 1);
            Rational rdiv = Rational.valueOf(indices[0], BigInteger.ONE);
            return arg.div(rdiv).isIntegral() ? this.mModel.getTrueIdx() : this.mModel.getFalseIdx();
        }
        if (name.equals("to_int")) {
            assert (args.length == 1);
            Rational arg = this.rationalValue(args[0]);
            return this.mModel.getNumericSortInterpretation().extend(arg.floor());
        }
        if (name.equals("to_real")) {
            assert (args.length == 1);
            return args[0];
        }
        if (name.equals("is_int")) {
            assert (args.length == 1);
            Rational arg = this.rationalValue(args[0]);
            return arg.isIntegral() ? this.mModel.getTrueIdx() : this.mModel.getFalseIdx();
        }
        if (name.equals("store")) {
            ArraySortInterpretation array = (ArraySortInterpretation)this.mModel.provideSortInterpretation(fun.getParameterSorts()[0]);
            ArrayValue storeVal = array.getValue(args[0]);
            if (storeVal.select(args[1], false) == args[2]) {
                return args[0];
            }
            storeVal = storeVal.copy();
            storeVal.store(args[1], args[2]);
            return array.value2index(storeVal);
        }
        if (name.equals("select")) {
            ArraySortInterpretation array = (ArraySortInterpretation)this.mModel.provideSortInterpretation(fun.getParameterSorts()[0]);
            ArrayValue val = array.getValue(args[0]);
            return val.select(args[1], false);
        }
        if (name.equals("@diff")) {
            ArraySortInterpretation array = (ArraySortInterpretation)this.mModel.provideSortInterpretation(fun.getParameterSorts()[0]);
            ArrayValue left = array.getValue(args[0]);
            ArrayValue right = array.getValue(args[1]);
            return left.computeDiff(args[1], right);
        }
        throw new AssertionError((Object)"Unknown internal function!");
    }

    private Rational rationalValue(int idx) {
        return this.mModel.getNumericSortInterpretation().get(idx);
    }

    private static class CachedEvaluator
    extends NonRecursive.TermWalker {
        public CachedEvaluator(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker) {
            ModelEvaluator eval = (ModelEvaluator)walker;
            Integer cached = eval.mCache.get(this.mTerm);
            if (cached == null) {
                eval.enqueueWalker(new AddToCache(this.mTerm));
                super.walk(walker);
            } else {
                eval.setResult(cached);
            }
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
            Rational val;
            if (!term.getSort().isNumericSort()) {
                throw new InternalError("Don't know how to evaluate this: " + term);
            }
            ModelEvaluator eval = (ModelEvaluator)walker;
            NumericSortInterpretation numSorts = eval.mModel.getNumericSortInterpretation();
            if (term.getValue() instanceof BigInteger) {
                val = Rational.valueOf((BigInteger)term.getValue(), BigInteger.ONE);
            } else if (term.getValue() instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)term.getValue();
                if (decimal.scale() <= 0) {
                    BigInteger num = decimal.toBigInteger();
                    val = Rational.valueOf(num, BigInteger.ONE);
                } else {
                    BigInteger num = decimal.unscaledValue();
                    BigInteger denom = BigInteger.TEN.pow(decimal.scale());
                    val = Rational.valueOf(num, denom);
                }
            } else {
                assert (term.getValue() instanceof Rational);
                val = (Rational)term.getValue();
            }
            eval.setResult(numSorts.extend(val));
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            ModelEvaluator eval = (ModelEvaluator)walker;
            eval.enqueueWalker(new CachedEvaluator(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            ModelEvaluator eval = (ModelEvaluator)walker;
            if (term.getFunction().getName().equals("ite")) {
                eval.enqueueWalker(new ITESelector(term));
                eval.pushTerm(term.getParameters()[0]);
            } else {
                eval.enqueueWalker(new Evaluator(term));
                eval.pushTerms(term.getParameters());
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Let-Terms should not be in model evaluation");
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            throw new SMTLIBException("Quantifiers not supported in model evaluation");
        }

        public void walk(NonRecursive walker, TermVariable term) {
            throw new SMTLIBException("Terms to evaluate must be closed");
        }
    }

    private static class Evaluator
    implements NonRecursive.Walker {
        private final ApplicationTerm mTerm;

        public Evaluator(ApplicationTerm term) {
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            ModelEvaluator eval = (ModelEvaluator)engine;
            int[] args = eval.getConvertedArgs(this.mTerm.getParameters().length);
            eval.setResult(eval.getValue(this.mTerm.getFunction(), args, this.mTerm));
        }
    }

    private static class AddToCache
    implements NonRecursive.Walker {
        private final Term mTerm;

        public AddToCache(Term t) {
            this.mTerm = t;
        }

        public void walk(NonRecursive engine) {
            ModelEvaluator eval = (ModelEvaluator)engine;
            eval.mCache.put(this.mTerm, eval.mEvaluated.peekLast());
        }
    }

    private static class ITESelector
    implements NonRecursive.Walker {
        private final ApplicationTerm mIte;

        public ITESelector(ApplicationTerm ite) {
            this.mIte = ite;
        }

        public void walk(NonRecursive engine) {
            ModelEvaluator eval = (ModelEvaluator)engine;
            int selector = eval.getConverted();
            if (selector == -1) {
                eval.setResult(-1);
            } else {
                eval.pushTerm(this.mIte.getParameters()[selector == eval.mModel.getBoolSortInterpretation().getTrueIdx() ? 1 : 2]);
            }
        }
    }
}

