/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixProofDAG {
    private final Deque<Worker> mTodo = new ArrayDeque<Worker>();
    private HashMap<Clause, Clause> mTransformed = new HashMap();
    private Map<Clause, Set<Literal>> mDeletedNodes;

    public void reset() {
        this.mTransformed = new HashMap();
    }

    public Clause fix(Clause rt, Map<Clause, Set<Literal>> deletedNodes) {
        this.mDeletedNodes = deletedNodes;
        this.mTodo.push(new ExpandClause(rt));
        this.run();
        return this.mTransformed.get(rt);
    }

    private final void run() {
        while (!this.mTodo.isEmpty()) {
            Worker w = this.mTodo.pop();
            w.process(this);
        }
    }

    private static class ExpandClause
    implements Worker {
        private final Clause mCls;

        public ExpandClause(Clause cls) {
            this.mCls = cls;
        }

        public void process(FixProofDAG engine) {
            if (engine.mTransformed.containsKey(this.mCls)) {
                return;
            }
            Set removed = (Set)engine.mDeletedNodes.get(this.mCls);
            ProofNode pn = this.mCls.getProof();
            if (pn.isLeaf()) {
                engine.mTransformed.put(this.mCls, this.mCls);
            } else {
                ResolutionNode rn = (ResolutionNode)pn;
                engine.mTodo.push(new CollectClause(this.mCls));
                ResolutionNode.Antecedent[] antes = rn.getAntecedents();
                boolean deleted = false;
                for (int i = antes.length - 1; !deleted && i >= 0; --i) {
                    if (removed != null) {
                        if (removed.contains(antes[i].mPivot)) continue;
                        deleted = removed.contains(antes[i].mPivot.negate());
                    }
                    engine.mTodo.push(new ExpandClause(antes[i].mAntecedent));
                }
                if (!deleted) {
                    engine.mTodo.push(new ExpandClause(rn.getPrimary()));
                }
            }
        }

        public String toString() {
            return "Expand: " + this.mCls.toString();
        }
    }

    private static class CollectClause
    implements Worker {
        private final Clause mCls;

        public CollectClause(Clause cls) {
            this.mCls = cls;
        }

        public void process(FixProofDAG engine) {
            Clause primary;
            boolean changed;
            ArrayDeque<ResolutionNode.Antecedent> newAntes;
            block13: {
                ResolutionNode rn = (ResolutionNode)this.mCls.getProof();
                Set removed = (Set)engine.mDeletedNodes.get(this.mCls);
                ResolutionNode.Antecedent[] antes = rn.getAntecedents();
                newAntes = new ArrayDeque<ResolutionNode.Antecedent>();
                boolean deleted = false;
                changed = false;
                primary = null;
                for (int i = antes.length - 1; i >= 0; --i) {
                    if (removed != null) {
                        if (removed.contains(antes[i].mPivot)) {
                            changed = true;
                            continue;
                        }
                        deleted = removed.contains(antes[i].mPivot.negate());
                    }
                    Clause cls = (Clause)engine.mTransformed.get(antes[i].mAntecedent);
                    if (deleted || !cls.contains(antes[i].mPivot)) {
                        primary = cls;
                        changed = true;
                        break block13;
                    }
                    if (cls == antes[i].mAntecedent) {
                        newAntes.addFirst(antes[i]);
                        continue;
                    }
                    newAntes.addFirst(new ResolutionNode.Antecedent(antes[i].mPivot, cls));
                    changed = true;
                }
                primary = (Clause)engine.mTransformed.get(rn.getPrimary());
                changed |= primary != rn.getPrimary();
            }
            if (changed) {
                Clause result;
                HashSet<Literal> lits = new HashSet<Literal>();
                for (int i = 0; i < primary.getSize(); ++i) {
                    lits.add(primary.getLiteral(i));
                }
                Iterator it = newAntes.iterator();
                while (it.hasNext()) {
                    ResolutionNode.Antecedent a = (ResolutionNode.Antecedent)it.next();
                    boolean resolutionStepUsed = lits.remove(a.mPivot.negate());
                    if (!resolutionStepUsed) {
                        it.remove();
                        continue;
                    }
                    for (int j = 0; j < a.mAntecedent.getSize(); ++j) {
                        Literal lit = a.mAntecedent.getLiteral(j);
                        if (lit == a.mPivot) continue;
                        lits.add(lit);
                    }
                }
                if (newAntes.isEmpty()) {
                    result = primary;
                } else {
                    ResolutionNode.Antecedent[] nantes = newAntes.toArray(new ResolutionNode.Antecedent[newAntes.size()]);
                    result = new Clause(lits.toArray(new Literal[lits.size()]), new ResolutionNode(primary, nantes));
                }
                engine.mTransformed.put(this.mCls, result);
            } else {
                engine.mTransformed.put(this.mCls, this.mCls);
            }
        }

        public String toString() {
            return "Collect: " + this.mCls.toString();
        }
    }

    private static interface Worker {
        public void process(FixProofDAG var1);
    }
}

