/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProofChecker
extends NonRecursive {
    HashSet<Term> mAssertions;
    Script mSkript;
    Logger mLogger;
    int mError;
    HashSet<String> mDebug = new HashSet();
    HashMap<Term, Term> mCacheConv;
    Stack<Term> mStackResults = new Stack();
    Stack<Term> mStackResultsDebug = new Stack();
    Stack<Annotation[]> mStackAnnots = new Stack();
    SMTAffineTermTransformer mAffineConverter = new SMTAffineTermTransformer();

    public ProofChecker(Script script, Logger logger) {
        this.mSkript = script;
        Term[] assertions = script.getAssertions();
        FormulaUnLet unletter = new FormulaUnLet();
        this.mAssertions = new HashSet(assertions.length);
        for (Term ass : assertions) {
            this.mAssertions.add(unletter.transform(ass));
        }
        this.mLogger = logger;
    }

    public boolean check(Term proof) {
        this.mCacheConv = new HashMap();
        this.mError = 0;
        proof = new FormulaUnLet().unlet(proof);
        this.run(new ProofWalker(proof));
        assert (this.mStackResults.size() == 1);
        Term resCalc = this.stackPopCheck(proof);
        if (resCalc != this.mSkript.term("false", new Term[0])) {
            this.reportError("The proof did not yield a contradiction but " + resCalc);
        }
        return this.mError == 0;
    }

    private void reportError(String msg) {
        this.mLogger.error(msg);
        ++this.mError;
    }

    private void reportWarning(String msg) {
        this.mLogger.warn(msg);
    }

    public Term negate(Term formula) {
        ApplicationTerm appFormula;
        if (formula instanceof ApplicationTerm && (appFormula = (ApplicationTerm)formula).getFunction().getName() == "not") {
            return appFormula.getParameters()[0];
        }
        return this.mSkript.term("not", formula);
    }

    public void walk(ApplicationTerm proofTerm) {
        if (this.mCacheConv.containsKey(proofTerm)) {
            if (this.mDebug.contains("CacheRuntimeCheck")) {
                this.mLogger.debug("Cache-RT: K: " + proofTerm.toString() + " (known)");
            }
            if (this.mDebug.contains("cacheUsed")) {
                this.mLogger.debug("Calculation of the term " + proofTerm.toString() + " is known: " + this.mCacheConv.get(proofTerm).toString());
            }
            if (this.mDebug.contains("cacheUsedSmall")) {
                this.mLogger.debug("Calculation known.");
            }
            this.stackPush(this.mCacheConv.get(proofTerm), proofTerm);
            return;
        }
        if (this.mDebug.contains("CacheRuntimeCheck")) {
            this.mLogger.debug("Cache-RT: U: " + proofTerm.toString() + " (unknown)");
        }
        String rulename = proofTerm.getFunction().getName();
        Term[] params = proofTerm.getParameters();
        if (this.mDebug.contains("currently")) {
            this.mLogger.debug("Currently looking at: " + rulename + " \t (function)");
        }
        if (rulename == "@res") {
            this.enqueueWalker(new ResolutionWalker(proofTerm));
            for (int i = params.length - 1; i >= 1; --i) {
                AnnotatedTerm pivotClause = (AnnotatedTerm)params[i];
                this.enqueueWalker(new ProofWalker(pivotClause.getSubterm()));
            }
            this.enqueueWalker(new ProofWalker(params[0]));
        } else if (rulename == "@eq") {
            this.enqueueWalker(new EqualityWalker(proofTerm));
            for (int i = params.length - 1; i >= 0; --i) {
                this.enqueueWalker(new ProofWalker(params[i]));
            }
        } else if (rulename == "@lemma") {
            this.walkLemma(proofTerm);
        } else if (rulename == "@tautology") {
            this.walkTautology(proofTerm);
        } else if (rulename == "@asserted") {
            this.walkAsserted(proofTerm);
        } else if (rulename == "@rewrite") {
            this.walkRewrite(proofTerm);
        } else if (rulename == "@intern") {
            this.walkIntern(proofTerm);
        } else if (rulename == "@split") {
            this.enqueueWalker(new SplitWalker(proofTerm));
            this.enqueueWalker(new ProofWalker(((AnnotatedTerm)params[0]).getSubterm()));
        } else if (rulename == "@clause") {
            this.enqueueWalker(new ClauseWalker(proofTerm));
            this.enqueueWalker(new ProofWalker(params[0]));
        } else {
            throw new AssertionError((Object)("Unknown proof rule " + rulename + "."));
        }
    }

    public void walkLemma(ApplicationTerm lemmaApp) {
        AnnotatedTerm annTerm = (AnnotatedTerm)lemmaApp.getParameters()[0];
        String lemmaType = annTerm.getAnnotations()[0].getKey();
        Object lemmaAnnotation = annTerm.getAnnotations()[0].getValue();
        Term lemma = annTerm.getSubterm();
        if (this.mDebug.contains("currently")) {
            this.mLogger.debug("Lemma-type: " + lemmaType);
        }
        if (lemmaType == ":LA") {
            this.checkLALemma(this.termToClause(lemma), (Term[])lemmaAnnotation);
        } else if (lemmaType == ":CC" || lemmaType == ":read-over-weakeq" || lemmaType == ":weakeq-ext") {
            this.checkArrayLemma(lemmaType, this.termToClause(lemma), (Object[])lemmaAnnotation);
        } else if (lemmaType == ":trichotomy") {
            this.checkTrichotomy(this.termToClause(lemma));
        } else if (lemmaType == ":store") {
            this.checkStore(this.termToClause(lemma), (ApplicationTerm)lemmaAnnotation);
        } else {
            this.reportError("Cannot deal with lemma " + lemmaType);
            this.mLogger.error(lemma.toStringDirect());
            StringBuilder sb = new StringBuilder();
            new PrintTerm().append((Appendable)sb, (Object[])lemmaAnnotation);
            this.mLogger.error(sb);
        }
        this.stackPush(lemma, lemmaApp);
    }

    private void checkArrayLemma(String type, Term[] clause, Object[] ccAnnotation) {
        Term goalEquality;
        int startSubpathAnnot = 0;
        if (ccAnnotation[0] instanceof Term) {
            ++startSubpathAnnot;
            goalEquality = (Term)ccAnnotation[0];
        } else {
            goalEquality = this.mSkript.term("false", new Term[0]);
        }
        HashMap<SymmetricPair<Term>, HashSet<Term>> weakPaths = new HashMap<SymmetricPair<Term>, HashSet<Term>>();
        HashSet<SymmetricPair<Term>> strongPaths = new HashSet<SymmetricPair<Term>>();
        HashSet<SymmetricPair<Term>> indexDiseqs = new HashSet<SymmetricPair<Term>>();
        boolean foundDiseq = false;
        for (Term literal : clause) {
            Term[] sides;
            Term atom;
            if (this.isApplication("not", literal)) {
                atom = ((ApplicationTerm)literal).getParameters()[0];
                if (!this.isApplication("=", atom = this.unquote(atom))) {
                    this.reportError("Unknown literal in CC lemma.");
                    return;
                }
                sides = ((ApplicationTerm)atom).getParameters();
                if (sides.length != 2) {
                    this.reportError("Expected binary equality, found " + atom);
                    return;
                }
                strongPaths.add(new SymmetricPair<Term>(sides[0], sides[1]));
                continue;
            }
            atom = this.unquote(literal);
            if (!this.isApplication("=", atom)) {
                this.reportError("Unknown literal in CC lemma.");
                return;
            }
            if (this.unquote(literal) != goalEquality) {
                if (type == ":CC") {
                    this.reportError("Unexpected positive literal in CC lemma.");
                }
                sides = ((ApplicationTerm)atom).getParameters();
                indexDiseqs.add(new SymmetricPair<Term>(sides[0], sides[1]));
            }
            foundDiseq = true;
        }
        SymmetricPair<Term> lastPath = null;
        for (int i = ccAnnotation.length - 2; i >= startSubpathAnnot; i -= 2) {
            if (!(ccAnnotation[i] instanceof String) || !(ccAnnotation[i + 1] instanceof Object[])) {
                this.reportError("Malformed Array subpath");
                return;
            }
            Object[] annot = (Object[])ccAnnotation[i + 1];
            if (ccAnnotation[i] == ":weakpath") {
                if (annot.length != 2 || !(annot[0] instanceof Term) || !(annot[1] instanceof Term[])) {
                    this.reportError("Malformed Array weakpath");
                    return;
                }
                Term idx = (Term)annot[0];
                Term[] path = (Term[])annot[1];
                this.checkArrayPath(idx, path, strongPaths, null, indexDiseqs);
                SymmetricPair<Term> endPoints = new SymmetricPair<Term>(path[0], path[path.length - 1]);
                HashSet<Term> weakIdxs = (HashSet<Term>)weakPaths.get(endPoints);
                if (weakIdxs == null) {
                    weakIdxs = new HashSet<Term>();
                    weakPaths.put(endPoints, weakIdxs);
                }
                weakIdxs.add(idx);
                continue;
            }
            if (ccAnnotation[i] == ":subpath" && annot instanceof Term[]) {
                Term[] path = (Term[])annot;
                SymmetricPair<Term> endPoints = new SymmetricPair<Term>(path[0], path[path.length - 1]);
                this.checkArrayPath(null, path, strongPaths, (HashSet)weakPaths.get(endPoints), indexDiseqs);
                strongPaths.add(endPoints);
                lastPath = endPoints;
                continue;
            }
            this.reportError("Unknown subpath annotation");
        }
        if (startSubpathAnnot == 0) {
            SMTAffineTerm diff = this.convertAffineTerm((Term)lastPath.getFirst()).add(this.convertAffineTerm((Term)lastPath.getSecond()).negate());
            if (!diff.isConstant() || diff.getConstant().equals(Rational.ZERO)) {
                this.reportError("No diseq, but main path is " + lastPath);
            }
        } else {
            HashSet weakPs;
            Term[] p2;
            Term[] p1;
            if (!foundDiseq) {
                this.reportError("Did not find goal equality in CC lemma");
            }
            if (!this.isApplication("=", goalEquality)) {
                this.reportError("Goal equality is not an equality in CC lemma");
                return;
            }
            Term[] sides = ((ApplicationTerm)goalEquality).getParameters();
            if (sides.length != 2) {
                this.reportError("Expected binary equality in CC lemma");
                return;
            }
            SymmetricPair<Term> endPoints = new SymmetricPair<Term>(sides[0], sides[1]);
            if (strongPaths.contains(endPoints)) {
                return;
            }
            if (this.isApplication("select", sides[0]) && this.isApplication("select", sides[1]) && ((p1 = ((ApplicationTerm)sides[0]).getParameters())[1] == (p2 = ((ApplicationTerm)sides[1]).getParameters())[1] || strongPaths.contains(new SymmetricPair<Term>(p1[1], p2[1]))) && (weakPs = (HashSet)weakPaths.get(new SymmetricPair<Term>(p1[0], p2[0]))) != null && (weakPs.contains(p1[1]) || weakPs.contains(p2[1]))) {
                return;
            }
            this.reportError("Cannot explain main equality " + goalEquality);
        }
    }

    void checkArrayPath(Term weakIdx, Term[] path, HashSet<SymmetricPair<Term>> strongPaths, HashSet<Term> weakPaths, HashSet<SymmetricPair<Term>> indexDiseqs) {
        if (path.length < 2) {
            this.reportError("Short path in ArrayLemma");
            return;
        }
        for (int i = 0; i < path.length - 1; ++i) {
            Term storeIndex;
            Term sel2;
            Term sel1;
            SymmetricPair<Term> selPair;
            SymmetricPair<Term> pair = new SymmetricPair<Term>(path[i], path[i + 1]);
            if (strongPaths.contains(pair) || weakIdx != null && strongPaths.contains(selPair = new SymmetricPair<Term>(sel1 = this.mSkript.term("select", path[i], weakIdx), sel2 = this.mSkript.term("select", path[i + 1], weakIdx))) || (storeIndex = this.checkStoreIndex(path[i], path[i + 1])) != null && (weakIdx != null && indexDiseqs.contains(new SymmetricPair<Term>(weakIdx, storeIndex)) || weakPaths != null && weakPaths.contains(storeIndex))) continue;
            if (path[i] instanceof ApplicationTerm && path[i + 1] instanceof ApplicationTerm) {
                ApplicationTerm app1 = (ApplicationTerm)path[i];
                ApplicationTerm app2 = (ApplicationTerm)path[i];
                if (app1.getFunction() == app2.getFunction()) {
                    Term[] p1 = app1.getParameters();
                    Term[] p2 = app2.getParameters();
                    for (int j = 0; j < p1.length; ++j) {
                        if (p1[j] == p2[j] || strongPaths.contains(new SymmetricPair<Term>(p1[j], p2[j]))) continue;
                        this.reportError("unexplained equality");
                    }
                    continue;
                }
            }
            this.reportError("unexplained equality " + path[i] + " == " + path[i + 1]);
        }
    }

    private Term checkStoreIndex(Term term1, Term term2) {
        Term[] storeArgs;
        if (this.isApplication("store", term1) && (storeArgs = ((ApplicationTerm)term1).getParameters())[1] == term2) {
            return storeArgs[2];
        }
        if (this.isApplication("store", term2) && (storeArgs = ((ApplicationTerm)term2).getParameters())[1] == term1) {
            return storeArgs[2];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkLALemma(Term[] clause, Term[] coefficients) {
        int signum;
        if (clause.length != coefficients.length) {
            this.reportError("Clause and coefficients have different length");
            return;
        }
        boolean sumHasStrict = false;
        SMTAffineTerm sum = null;
        for (int i = 0; i < clause.length; ++i) {
            Term[] params;
            boolean isStrict;
            boolean isNegated;
            Term literal;
            Rational coeff;
            block20: {
                block21: {
                    block22: {
                        coeff = this.convertAffineTerm(coefficients[i]).getConstant();
                        if (coeff.equals(Rational.ZERO)) {
                            this.reportWarning("Coefficient in LA lemma is zero.");
                            continue;
                        }
                        literal = clause[i];
                        isNegated = false;
                        if (this.isApplication("not", literal)) {
                            literal = ((ApplicationTerm)literal).getParameters()[0];
                            isNegated = true;
                        }
                        literal = this.unquote(literal);
                        if (!isNegated) break block21;
                        if (!this.isApplication("<=", literal)) break block22;
                        isStrict = false;
                        if (coeff.isNegative()) {
                            this.reportError("Negative coefficient for <=");
                        }
                        break block20;
                    }
                    if (this.isApplication("=", literal)) {
                        isStrict = false;
                        break block20;
                    } else if (this.isApplication("<", literal)) {
                        isStrict = true;
                        if (coeff.isNegative()) {
                            this.reportError("Negative coefficient for <");
                        }
                        break block20;
                    } else {
                        this.reportError("Unknown atom in LA lemma: " + literal);
                        continue;
                    }
                }
                if (this.isApplication("<=", literal)) {
                    isStrict = true;
                    if (!coeff.isNegative()) {
                        this.reportError("Positive coefficient for negated <=");
                    }
                } else if (this.isApplication("<", literal)) {
                    isStrict = false;
                    if (!coeff.isNegative()) {
                        this.reportError("Positive coefficient for negated <");
                    }
                } else {
                    this.reportError("Unknown atom in LA lemma: " + literal);
                    continue;
                }
            }
            if ((params = ((ApplicationTerm)literal).getParameters()).length != 2) {
                this.reportError("not a binary comparison in LA lemma");
                continue;
            }
            SMTAffineTerm affine = this.convertAffineTerm(params[1]);
            if (!affine.isConstant() || !affine.getConstant().equals(Rational.ZERO)) {
                this.reportError("Right hand side is not zero");
            }
            affine = this.convertAffineTerm(params[0]);
            if (isStrict && params[0].getSort().getName().equals("Int")) {
                affine = affine.add(isNegated ? Rational.ONE : Rational.MONE);
                isStrict = false;
            }
            affine = affine.mul(coeff);
            sum = sum == null ? affine : sum.add(affine);
            sumHasStrict |= isStrict;
        }
        Rational sumConstant = sum.getConstant();
        if (sum.isConstant() && ((signum = sumConstant.signum()) > 0 || sumHasStrict && signum == 0)) {
            return;
        }
        this.reportError("LA lemma sums up to " + sum + (sumHasStrict ? " < 0" : " <= 0"));
    }

    private void checkTrichotomy(Term[] clause) {
        if (clause.length != 3) {
            this.reportError("Malformed Trichotomy clause: " + Arrays.toString(clause));
            return;
        }
        SMTAffineTerm trichotomyTerm = null;
        boolean NEQ = true;
        int LEQ = 2;
        int GEQ = 4;
        int foundlits = 0;
        for (Term lit : clause) {
            boolean isNegated = this.isApplication("not", lit);
            if (isNegated) {
                lit = ((ApplicationTerm)lit).getParameters()[0];
            }
            lit = this.unquote(lit);
            Rational offset = Rational.ZERO;
            if (this.isApplication("=", lit)) {
                if (isNegated) {
                    this.reportError("Equality in trichotomy has wrong polarity");
                    return;
                }
                if ((foundlits & 1) != 0) {
                    this.reportError("Two Disequalities in trichotomy");
                    return;
                }
                foundlits |= 1;
            } else if (this.isApplication("<=", lit)) {
                if (isNegated) {
                    if ((foundlits & 4) != 0) {
                        this.reportError("Two > in trichotomy");
                        return;
                    }
                    foundlits |= 4;
                } else {
                    if ((foundlits & 2) != 0) {
                        this.reportError("Two <= in trichotomy");
                        return;
                    }
                    foundlits |= 2;
                    offset = Rational.MONE;
                }
            } else if (this.isApplication("<", lit)) {
                if (isNegated) {
                    if ((foundlits & 4) != 0) {
                        this.reportError("Two >= in trichotomy");
                        return;
                    }
                    foundlits |= 4;
                    offset = Rational.ONE;
                } else {
                    if ((foundlits & 2) != 0) {
                        this.reportError("Two < in trichotomy");
                        return;
                    }
                    foundlits |= 2;
                }
            } else {
                this.reportError("Unknown literal in trichotomy " + lit);
                return;
            }
            Term[] params = ((ApplicationTerm)lit).getParameters();
            if (params.length != 2) {
                this.reportError("not a binary comparison in LA lemma");
                return;
            }
            SMTAffineTerm affine = this.convertAffineTerm(params[1]);
            if (!affine.isConstant() || !affine.getConstant().equals(Rational.ZERO)) {
                this.reportError("Right hand side is not zero");
            }
            if (offset != Rational.ZERO && !params[1].getSort().getName().equals("Int")) {
                this.reportError("<= or >= in non-integer trichotomy");
            }
            affine = this.convertAffineTerm(params[0]).add(offset);
            if (trichotomyTerm == null) {
                trichotomyTerm = affine;
                continue;
            }
            if (trichotomyTerm.equals(affine)) continue;
            this.reportError("Invalid trichotomy");
        }
        assert (foundlits == 7);
    }

    private void checkStore(Term[] clause, Term store) {
        Term[] storeArgs;
        ApplicationTerm select;
        Term[] sides;
        Term eqlit;
        if (clause.length == 1 && this.isApplication("=", eqlit = this.unquote(clause[0])) && this.isApplication("select", (sides = ((ApplicationTerm)eqlit).getParameters())[0]) && store == (select = (ApplicationTerm)sides[0]).getParameters()[0] && this.isApplication("store", store) && (storeArgs = ((ApplicationTerm)store).getParameters())[1] == select.getParameters()[1] && storeArgs[2] == sides[1]) {
            return;
        }
        this.reportError("Malformed store clause: " + Arrays.toString(clause));
    }

    public void walkTautology(ApplicationTerm tautologyApp) {
        AnnotatedTerm annTerm = (AnnotatedTerm)tautologyApp.getParameters()[0];
        String tautType = annTerm.getAnnotations()[0].getKey();
        Term tautology = annTerm.getSubterm();
        Term[] clause = this.termToClause(tautology);
        this.stackPush(tautology, tautologyApp);
        if (tautType == ":eq") {
            if (clause.length != 2) {
                this.reportError("Tautology :eq must have two literals");
            }
            boolean term1Negated = false;
            Term term1 = clause[0];
            Term term2 = clause[1];
            if (term1 instanceof ApplicationTerm && this.pm_func_weak(this.convertApp(term1), "not")) {
                term1Negated = true;
            }
            ApplicationTerm termNegApp = null;
            ApplicationTerm termPosApp = null;
            if (term1Negated) {
                termNegApp = this.convertApp_hard(this.convertApp(term1).getParameters()[0]);
                termPosApp = this.convertApp_hard(term2);
            } else {
                this.pm_func(term2, "not");
                termNegApp = this.convertApp_hard(this.convertApp(term2).getParameters()[0]);
                termPosApp = this.convertApp_hard(term1);
            }
            String funcSymb = termNegApp.getFunction().getName();
            this.pm_func(termPosApp, funcSymb);
            ApplicationTerm termNegUnif = this.uniformizeInEquality(termNegApp);
            ApplicationTerm termPosUnif = this.uniformizeInEquality(termPosApp);
            if (!this.uniformedSame(termNegUnif, termPosUnif)) {
                throw new AssertionError((Object)"Error in @taut_eq");
            }
        } else if (tautType == ":or+") {
            Term[] split = this.termToClause(this.unquote(this.negate(clause[0])));
            if (split.length < 2) {
                this.reportError("Expected or-term in rule :or+ but got " + clause[0]);
            } else {
                boolean problem = false;
                for (int i = 1; i < clause.length; ++i) {
                    if (split[i - 1] == clause[i]) continue;
                    problem = true;
                }
                if (problem) {
                    this.reportError("Malformed tautology " + tautologyApp);
                }
            }
        } else if (tautType == ":or-") {
            if (clause.length != 2 || !this.checkOrMinus(this.unquote(clause[0]), clause[1])) {
                this.reportError("Invalid application of rule :or-");
            }
        } else if (tautType == ":termITE") {
            try {
                ApplicationTerm termAppTemp;
                ApplicationTerm termOr = this.convertApp(tautology);
                this.pm_func(termOr, "or");
                this.checkNumber(termOr, 2);
                Term termNotEq = null;
                ApplicationTerm equalityApp = null;
                ApplicationTerm equalityIteApp = null;
                Term equalityNotIte = null;
                boolean foundEq = false;
                if (termOr.getParameters()[0] instanceof ApplicationTerm && this.pm_func_weak(termAppTemp = this.convertApp(termOr), "=") && this.pm_func_weak(termAppTemp.getParameters()[0], "ite")) {
                    foundEq = true;
                    equalityApp = this.convertApp(termOr.getParameters()[0]);
                    termNotEq = termOr.getParameters()[1];
                }
                if (!foundEq) {
                    equalityApp = this.convertApp(termOr.getParameters()[1]);
                    termNotEq = termOr.getParameters()[0];
                }
                if (equalityApp.getParameters()[0] instanceof ApplicationTerm) {
                    ApplicationTerm termAppTemp2 = this.convertApp(equalityApp.getParameters()[0]);
                    if (this.pm_func_weak(termAppTemp2, "ite")) {
                        equalityIteApp = this.convertApp(equalityApp.getParameters()[0]);
                        equalityNotIte = equalityApp.getParameters()[1];
                    } else {
                        equalityIteApp = this.convertApp(equalityApp.getParameters()[1]);
                        equalityNotIte = equalityApp.getParameters()[0];
                    }
                }
                this.pm_func(equalityApp, "=");
                this.pm_func(equalityIteApp, "ite");
                this.checkNumber(equalityApp, 2);
                this.checkNumber(equalityIteApp, 3);
                if (this.termITEHelper_isEqual(termNotEq, equalityIteApp.getParameters()[0])) {
                    if (equalityNotIte != equalityIteApp.getParameters()[2]) {
                        throw new AssertionError((Object)"Error 1 in @taut_termITE");
                    }
                }
                if (equalityNotIte != equalityIteApp.getParameters()[1]) {
                    throw new AssertionError((Object)"Error 2 in @taut_termITE");
                }
            }
            catch (RuntimeException ex) {
                this.reportError("Invalid application of rule :termIte");
                return;
            }
        } else {
            if (tautType == ":excludedMiddle1") {
                if (clause.length == 2) {
                    Term falseEq = this.unquote(clause[1]);
                    if (this.isApplication("not", clause[0]) && this.isApplication("=", falseEq)) {
                        Term negClause0 = ((ApplicationTerm)clause[0]).getParameters()[0];
                        Term[] ps = ((ApplicationTerm)falseEq).getParameters();
                        if (this.isApplication("true", ps[1]) && negClause0 == ps[0]) {
                            return;
                        }
                    }
                }
                this.reportError("Invalid application of rule :excludedMiddle1");
                return;
            }
            if (tautType == ":excludedMiddle2") {
                Term[] ps;
                Term falseEq;
                if (clause.length == 2 && this.isApplication("=", falseEq = this.unquote(clause[1])) && this.isApplication("false", (ps = ((ApplicationTerm)falseEq).getParameters())[1]) && clause[0] == ps[0]) {
                    return;
                }
                this.reportError("Invalid application of rule :excludedMiddle2");
                return;
            }
            this.reportError("Unknown tautology rule " + tautologyApp);
        }
    }

    void walkAsserted(ApplicationTerm assertedApp) {
        Term assertedTerm = assertedApp.getParameters()[0];
        if (!this.mAssertions.contains(assertedTerm)) {
            this.reportError("Could not find asserted term " + assertedTerm);
        }
        this.stackPush(assertedTerm, assertedApp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void walkRewrite(ApplicationTerm rewriteApp) {
        AnnotatedTerm termAppInnerAnn = this.convertAnn(rewriteApp.getParameters()[0]);
        ApplicationTerm termEqApp = this.convertApp(termAppInnerAnn.getSubterm());
        this.pm_func(termEqApp, "=");
        this.stackPush(termEqApp, rewriteApp);
        this.checkNumber(termEqApp, 2);
        String rewriteRule = termAppInnerAnn.getAnnotations()[0].getKey();
        if (this.mDebug.contains("currently")) {
            System.out.println("Rewrite-Rule: " + rewriteRule);
        }
        if (this.mDebug.contains("hardTerm")) {
            System.out.println("Term: " + rewriteApp.toStringDirect());
        }
        if (rewriteRule == ":trueNotFalse") {
            if (termEqApp.getParameters()[1] != this.mSkript.term("false", new Term[0])) {
                throw new AssertionError((Object)("Error: The second argument of a rewrite of the rule " + rewriteRule + " should be true, but isn't.\n" + "The term was " + termEqApp.toString()));
            }
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "=");
            boolean foundTrue = false;
            boolean foundFalse = false;
            Term[] arr$ = termOldApp.getParameters();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                Term subterm = arr$[i$];
                if (subterm == this.mSkript.term("false", new Term[0])) {
                    foundFalse = true;
                }
                if (subterm == this.mSkript.term("true", new Term[0])) {
                    foundTrue = true;
                }
                if (foundFalse && foundTrue) {
                    return;
                }
                ++i$;
            }
            throw new AssertionError((Object)("Error at the end of rule " + rewriteRule + "!\n The term was " + rewriteApp.toStringDirect()));
        }
        if (rewriteRule == ":constDiff") {
            if (termEqApp.getParameters()[1] != this.mSkript.term("false", new Term[0])) {
                throw new AssertionError((Object)("Error: The second argument of a rewrite of the rule " + rewriteRule + " should be false, but isn't.\n" + "The term was " + termEqApp.toString()));
            }
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "=");
            HashSet<Term> constTerms = new HashSet<Term>();
            for (Term subterm : termOldApp.getParameters()) {
                ApplicationTerm subtermApp;
                if (subterm instanceof ConstantTerm) {
                    constTerms.add(subterm);
                    continue;
                }
                if (!(subterm instanceof ApplicationTerm) || !this.pm_func_weak(subtermApp = this.convertApp(subterm), "-") || !(subtermApp.getParameters()[0] instanceof ConstantTerm)) continue;
                constTerms.add(subterm);
            }
            if (this.mDebug.contains("newRules")) {
                System.out.println("The constant terms are:");
                for (Term termC : constTerms) {
                    System.out.println(termC.toStringDirect());
                }
            }
            if (constTerms.size() > 1) return;
            throw new AssertionError((Object)("Error at the end of rule " + rewriteRule + "!\n The term was " + rewriteApp.toStringDirect()));
        }
        if (rewriteRule == ":eqTrue") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "=");
            boolean multiconjunct = false;
            ApplicationTerm termNewApp = null;
            if (termEqApp.getParameters()[1] instanceof ApplicationTerm && this.pm_func_weak(this.convertApp(termEqApp.getParameters()[1]), "and")) {
                termNewApp = this.convertApp(termEqApp.getParameters()[1]);
                multiconjunct = true;
            }
            HashSet<Term> oldTerms = new HashSet<Term>();
            HashSet<Term> newTerms = new HashSet<Term>();
            oldTerms.addAll(Arrays.asList(termOldApp.getParameters()));
            if (multiconjunct) {
                newTerms.addAll(Arrays.asList(termNewApp.getParameters()));
            } else {
                newTerms.add(termEqApp.getParameters()[1]);
            }
            if (!oldTerms.contains(this.mSkript.term("true", new Term[0]))) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule + ".\n The term was " + termEqApp.toString()));
            }
            newTerms.add(this.mSkript.term("true", new Term[0]));
            if (oldTerms.equals(newTerms)) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule + ".\n The term was " + termEqApp.toString()));
        }
        if (rewriteRule == ":eqFalse") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.pm_func(termOldApp, "=");
            this.pm_func(termNewApp, "not");
            boolean multidisjunct = false;
            ApplicationTerm termNewAppInnerApp = null;
            if (termNewApp.getParameters()[0] instanceof ApplicationTerm && this.pm_func_weak(this.convertApp(termNewApp.getParameters()[0]), "or")) {
                termNewAppInnerApp = this.convertApp(termNewApp.getParameters()[0]);
                multidisjunct = true;
            }
            HashSet<Term> oldTerms = new HashSet<Term>();
            HashSet<Term> newTerms = new HashSet<Term>();
            oldTerms.addAll(Arrays.asList(termOldApp.getParameters()));
            if (multidisjunct) {
                newTerms.addAll(Arrays.asList(termNewAppInnerApp.getParameters()));
            } else {
                newTerms.add(termNewApp.getParameters()[0]);
            }
            if (!oldTerms.contains(this.mSkript.term("false", new Term[0]))) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule + ".\n The term was " + termEqApp.toString()));
            }
            newTerms.add(this.mSkript.term("false", new Term[0]));
            if (oldTerms.equals(newTerms)) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule + ".\n The term was " + termEqApp.toString()));
        }
        if (rewriteRule == ":eqSame") {
            if (termEqApp.getParameters()[1] != this.mSkript.term("true", new Term[0])) {
                throw new AssertionError((Object)("Error: The second argument of a rewrite of the rule " + rewriteRule + " should be true, but isn't.\n" + "The term was " + termEqApp.toString()));
            }
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "=");
            Term termComp = termOldApp.getParameters()[0];
            Term[] arr$ = termOldApp.getParameters();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                Term subterm = arr$[i$];
                if (subterm != termComp) {
                    throw new AssertionError((Object)("Error 2 at rule " + rewriteRule + "!\n The term was " + rewriteApp.toStringDirect()));
                }
                ++i$;
            }
            return;
        }
        if (rewriteRule == ":eqSimp") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.pm_func(termOldApp, "=");
            this.pm_func(termNewApp, "=");
            HashSet<Term> oldTerms = new HashSet<Term>();
            HashSet<Term> newTerms = new HashSet<Term>();
            oldTerms.addAll(Arrays.asList(termOldApp.getParameters()));
            newTerms.addAll(Arrays.asList(termNewApp.getParameters()));
            if (oldTerms.equals(newTerms)) return;
            throw new AssertionError((Object)("Error 1 at " + rewriteRule + ".\n The term was " + termEqApp.toString()));
        }
        if (rewriteRule == ":eqBinary") {
            int i;
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            ApplicationTerm termNewAppInnerApp = this.convertApp(termNewApp.getParameters()[0]);
            this.pm_func(termOldApp, "=");
            this.pm_func(termNewApp, "not");
            if (termOldApp.getParameters().length == 2) {
                this.pm_func(termNewAppInnerApp, "not");
                if (termOldApp == termNewAppInnerApp.getParameters()[0]) return;
                throw new AssertionError((Object)("Error A in " + rewriteRule));
            }
            this.pm_func(termNewAppInnerApp, "or");
            ApplicationTerm[] arrayNewEqApp = new ApplicationTerm[termNewAppInnerApp.getParameters().length];
            Term[] arrayOldTerm = termOldApp.getParameters();
            for (int i2 = 0; i2 < termNewAppInnerApp.getParameters().length; ++i2) {
                ApplicationTerm termIneqApp = this.convertApp(termNewAppInnerApp.getParameters()[i2]);
                this.pm_func(termIneqApp, "not");
                arrayNewEqApp[i2] = this.convertApp(termIneqApp.getParameters()[0]);
                this.pm_func(arrayNewEqApp[i2], "=");
            }
            boolean[] eqFound = new boolean[arrayNewEqApp.length];
            for (i = 0; i < eqFound.length; ++i) {
                eqFound[i] = false;
            }
            for (i = 0; i < arrayOldTerm.length; ++i) {
                for (int j = i + 1; j < arrayOldTerm.length; ++j) {
                    for (int k = 0; k < arrayNewEqApp.length; ++k) {
                        if (eqFound[k]) continue;
                        this.checkNumber(arrayNewEqApp[k], 2);
                        if (arrayNewEqApp[k].getParameters()[0] == arrayOldTerm[i] && arrayNewEqApp[k].getParameters()[1] == arrayOldTerm[j]) {
                            eqFound[k] = true;
                        }
                        if (arrayNewEqApp[k].getParameters()[1] != arrayOldTerm[i] || arrayNewEqApp[k].getParameters()[0] != arrayOldTerm[j]) continue;
                        eqFound[k] = true;
                    }
                }
            }
            i = 0;
            while (i < eqFound.length) {
                if (!eqFound[i]) {
                    throw new AssertionError((Object)("Error: Coulnd't associate the equality " + arrayNewEqApp[i] + "\n. The term was " + rewriteApp.toStringDirect()));
                }
                ++i;
            }
            return;
        }
        if (rewriteRule == ":distinctBool") {
            if (termEqApp.getParameters()[1] != this.mSkript.term("false", new Term[0])) {
                throw new AssertionError((Object)("Error: The second argument of a rewrite of the rule " + rewriteRule + " should be false, but it isn't.\n" + "The term was " + termEqApp.toString()));
            }
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "distinct");
            if (termOldApp.getParameters().length < 3) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            Term[] arr$ = termOldApp.getParameters();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                Term subterm = arr$[i$];
                if (subterm.getSort() != this.mSkript.sort("Bool", new Sort[0])) {
                    throw new AssertionError((Object)("Error 2 at " + rewriteRule));
                }
                ++i$;
            }
            return;
        }
        if (rewriteRule == ":distinctSame") {
            if (termEqApp.getParameters()[1] != this.mSkript.term("false", new Term[0])) {
                throw new AssertionError((Object)("Error: The second argument of a rewrite of the rule " + rewriteRule + " should be false, but it isn't.\n" + "The term was " + termEqApp.toString()));
            }
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "distinct");
            int i = 0;
            while (i < termOldApp.getParameters().length) {
                for (int j = i + 1; j < termOldApp.getParameters().length; ++j) {
                    if (termOldApp.getParameters()[i] != termOldApp.getParameters()[j]) continue;
                    return;
                }
                ++i;
            }
            throw new AssertionError((Object)("Error at the end of rule " + rewriteRule + "!\n The term was " + rewriteApp.toStringDirect()));
        }
        if (rewriteRule == ":distinctNeg") {
            Term term2;
            if (termEqApp.getParameters()[1] != this.mSkript.term("true", new Term[0])) {
                throw new AssertionError((Object)("Error: The second argument of a rewrite of the rule " + rewriteRule + " should be true, but it isn't.\n" + "The term was " + termEqApp.toString()));
            }
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "distinct");
            if (termOldApp.getParameters().length != 2) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            Term term1 = termOldApp.getParameters()[0];
            if (term1 == this.negate(term2 = termOldApp.getParameters()[1])) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":distinctTrue") {
            Term termNotTrue;
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "distinct");
            this.pm_func(termNewApp, "not");
            if (termOldApp.getParameters().length != 2) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            Term term1 = termOldApp.getParameters()[0];
            Term term2 = termOldApp.getParameters()[1];
            if (term1.equals(this.mSkript.term("true", new Term[0]))) {
                termNotTrue = term2;
            } else {
                if (!term2.equals(this.mSkript.term("true", new Term[0]))) throw new AssertionError((Object)("Error 1 at " + rewriteRule));
                termNotTrue = term1;
            }
            if (termNewApp.getParameters()[0] == termNotTrue) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":distinctFalse") {
            Term termNotFalse;
            Term termNew = termEqApp.getParameters()[1];
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "distinct");
            if (termOldApp.getParameters().length != 2) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            Term term1 = termOldApp.getParameters()[0];
            Term term2 = termOldApp.getParameters()[1];
            if (term1.equals(this.mSkript.term("false", new Term[0]))) {
                termNotFalse = term2;
            } else {
                if (!term2.equals(this.mSkript.term("false", new Term[0]))) throw new AssertionError((Object)("Error 1 at " + rewriteRule));
                termNotFalse = term1;
            }
            if (termNew == termNotFalse) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":distinctBinary") {
            int i;
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            ApplicationTerm termNewAppInnerApp = this.convertApp(termNewApp.getParameters()[0]);
            this.pm_func(termOldApp, "distinct");
            if (this.pm_func_weak(termNewApp, "=")) {
                this.checkNumber(termOldApp, 2);
                this.checkNumber(termNewApp, 2);
                Term termP1 = termOldApp.getParameters()[0];
                Term termP2 = termOldApp.getParameters()[1];
                if (termP1.getSort() != this.mSkript.sort("Bool", new Sort[0])) throw new AssertionError((Object)"Error 1 in :distinctBinary_distinctBoolEq");
                if (termP2.getSort() != this.mSkript.sort("Bool", new Sort[0])) {
                    throw new AssertionError((Object)"Error 1 in :distinctBinary_distinctBoolEq");
                }
                boolean correctRightSide = false;
                if (termNewApp.getParameters()[0].equals(termP1) && termNewApp.getParameters()[1].equals(this.negate(termP2))) {
                    correctRightSide = true;
                }
                if (termNewApp.getParameters()[0].equals(termP2) && termNewApp.getParameters()[1].equals(this.negate(termP1))) {
                    correctRightSide = true;
                }
                if (termNewApp.getParameters()[1].equals(termP1) && termNewApp.getParameters()[0].equals(this.negate(termP2))) {
                    correctRightSide = true;
                }
                if (termNewApp.getParameters()[1].equals(termP2) && termNewApp.getParameters()[0].equals(this.negate(termP1))) {
                    return;
                }
                if (correctRightSide) return;
                throw new AssertionError((Object)"Error at the end of :distinctBinary_distinctBoolEq");
            }
            this.pm_func(termNewApp, "not");
            Term[] arrayNewEq = null;
            Term[] arrayOldTerm = termOldApp.getParameters();
            arrayNewEq = this.pm_func_weak(termNewAppInnerApp, "or") ? termNewAppInnerApp.getParameters() : termNewApp.getParameters();
            boolean[] eqFound = new boolean[arrayNewEq.length];
            for (i = 0; i < eqFound.length; ++i) {
                eqFound[i] = false;
            }
            for (i = 0; i < arrayOldTerm.length; ++i) {
                for (int j = i + 1; j < arrayOldTerm.length; ++j) {
                    boolean found = false;
                    for (int k = 0; k < arrayNewEq.length; ++k) {
                        if (eqFound[k]) continue;
                        ApplicationTerm termAppTemp = this.convertApp(arrayNewEq[k]);
                        this.pm_func(termAppTemp, "=");
                        this.checkNumber(termAppTemp, 2);
                        if (termAppTemp.getParameters()[0] == arrayOldTerm[i] && termAppTemp.getParameters()[1] == arrayOldTerm[j]) {
                            found = true;
                            eqFound[k] = true;
                        }
                        if (termAppTemp.getParameters()[1] != arrayOldTerm[i] || termAppTemp.getParameters()[0] != arrayOldTerm[j]) continue;
                        found = true;
                        eqFound[k] = true;
                    }
                    if (!found) {
                        throw new AssertionError((Object)("Error: Couldn't find the equality that corresponds to " + arrayOldTerm[i].toStringDirect() + " and " + arrayOldTerm[j].toStringDirect() + ".\n" + "The term was " + rewriteApp.toStringDirect()));
                    }
                }
            }
            i = 0;
            while (i < eqFound.length) {
                if (!eqFound[i]) {
                    throw new AssertionError((Object)("Error: Coulnd't associate the equality " + arrayNewEq[i] + "\n. The term was " + rewriteApp.toStringDirect()));
                }
                ++i;
            }
            return;
        }
        if (rewriteRule == ":notSimp") {
            ApplicationTerm innerAppTermFirstNeg = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(innerAppTermFirstNeg, "not");
            if (innerAppTermFirstNeg.getParameters()[0] == this.mSkript.term("false", new Term[0])) {
                if (termEqApp.getParameters()[1] == this.mSkript.term("true", new Term[0])) return;
            }
            if (innerAppTermFirstNeg.getParameters()[0] == this.mSkript.term("true", new Term[0]) && termEqApp.getParameters()[1] == this.mSkript.term("false", new Term[0])) {
                return;
            }
            ApplicationTerm innerAppTermSecondNeg = this.convertApp(innerAppTermFirstNeg.getParameters()[0]);
            this.pm_func(innerAppTermSecondNeg, "not");
            if (innerAppTermSecondNeg.getParameters()[0] == termEqApp.getParameters()[1]) return;
            throw new AssertionError((Object)("Error: The rule \"notSimp\" couldn't be verified, because the following two terms aren't the same: " + innerAppTermSecondNeg.getParameters()[0].toString() + " and " + termEqApp.getParameters()[1].toStringDirect() + ".\n" + "The original term was: " + rewriteApp.toStringDirect()));
        }
        if (rewriteRule == ":orSimp") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            boolean multidisjunct = true;
            Term termNew = termEqApp.getParameters()[1];
            ApplicationTerm termNewApp = null;
            this.pm_func(termOldApp, "or");
            HashSet<Term> oldDisjuncts = new HashSet<Term>();
            HashSet<Term> newDisjuncts = new HashSet<Term>();
            oldDisjuncts.addAll(Arrays.asList(termOldApp.getParameters()));
            oldDisjuncts.remove(this.mSkript.term("false", new Term[0]));
            if (oldDisjuncts.size() <= 1) {
                multidisjunct = false;
            }
            if (multidisjunct) {
                termNewApp = this.convertApp(termNew);
                this.pm_func(termNewApp, "or");
            }
            if (multidisjunct) {
                newDisjuncts.addAll(Arrays.asList(termNewApp.getParameters()));
            } else {
                newDisjuncts.add(termNew);
            }
            if (oldDisjuncts.equals(newDisjuncts)) return;
            newDisjuncts.remove(this.mSkript.term("false", new Term[0]));
            if (oldDisjuncts.equals(newDisjuncts)) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule + ".\n The term was " + termEqApp.toStringDirect()));
        }
        if (rewriteRule == ":orTaut") {
            if (termEqApp.getParameters()[1] != this.mSkript.term("true", new Term[0])) {
                throw new AssertionError((Object)("Error: The second argument of a rewrite of the rule " + rewriteRule + " should be true, but it isn't.\n" + "The term was " + termEqApp.toString()));
            }
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "or");
            for (Term disjunct : termOldApp.getParameters()) {
                if (disjunct != this.mSkript.term("true", new Term[0])) continue;
                return;
            }
            Term[] arr$ = termOldApp.getParameters();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                Term disjunct1 = arr$[i$];
                for (Term disjunct2 : termOldApp.getParameters()) {
                    if (disjunct1 != this.negate(disjunct2)) continue;
                    return;
                }
                ++i$;
            }
            throw new AssertionError((Object)("Error at the end of rule " + rewriteRule + "!\n The term was " + rewriteApp.toStringDirect()));
        }
        if (rewriteRule == ":iteTrue") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "ite");
            this.checkNumber(termOldApp.getParameters(), 3);
            if (termOldApp.getParameters()[0] != this.mSkript.term("true", new Term[0])) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (termOldApp.getParameters()[1] == termEqApp.getParameters()[1]) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":iteFalse") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "ite");
            this.checkNumber(termOldApp.getParameters(), 3);
            if (termOldApp.getParameters()[0] != this.mSkript.term("false", new Term[0])) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (termOldApp.getParameters()[2] == termEqApp.getParameters()[1]) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":iteSame") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "ite");
            this.checkNumber(termOldApp.getParameters(), 3);
            if (termOldApp.getParameters()[1] != termEqApp.getParameters()[1]) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (termOldApp.getParameters()[2] == termEqApp.getParameters()[1]) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":iteBool1") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "ite");
            this.checkNumber(termOldApp.getParameters(), 3);
            if (termOldApp.getParameters()[0] != termEqApp.getParameters()[1]) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (termOldApp.getParameters()[1] != this.mSkript.term("true", new Term[0])) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (termOldApp.getParameters()[2] == this.mSkript.term("false", new Term[0])) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":iteBool2") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "ite");
            this.checkNumber(termOldApp.getParameters(), 3);
            if (this.mSkript.term("not", termOldApp.getParameters()[0]) != termEqApp.getParameters()[1]) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (termOldApp.getParameters()[1] != this.mSkript.term("false", new Term[0])) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (termOldApp.getParameters()[2] == this.mSkript.term("true", new Term[0])) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":iteBool3") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.pm_func(termOldApp, "ite");
            this.pm_func(termNewApp, "or");
            this.checkNumber(termOldApp, 3);
            this.checkNumber(termNewApp, 2);
            Term t0 = termOldApp.getParameters()[0];
            Term t1 = termOldApp.getParameters()[1];
            Term t2 = termOldApp.getParameters()[2];
            if (t1 != this.mSkript.term("true", new Term[0])) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (termNewApp.getParameters()[0] != t0 && termNewApp.getParameters()[1] != t0) {
                throw new AssertionError((Object)("Error 4 at " + rewriteRule));
            }
            if (termNewApp.getParameters()[0] == t2) return;
            if (termNewApp.getParameters()[1] == t2) return;
            throw new AssertionError((Object)("Error 5 at " + rewriteRule));
        }
        if (rewriteRule == ":iteBool4") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            ApplicationTerm termNewAppInnerApp = this.convertApp(termNewApp.getParameters()[0]);
            this.checkNumber(termOldApp, 3);
            this.checkNumber(termNewAppInnerApp, 2);
            Term t0 = termOldApp.getParameters()[0];
            Term t1 = termOldApp.getParameters()[1];
            Term t2 = termOldApp.getParameters()[2];
            this.pm_func(termOldApp, "ite");
            this.pm_func(termNewApp, "not");
            this.pm_func(termNewAppInnerApp, "or");
            if (t1 != this.mSkript.term("false", new Term[0])) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (termNewAppInnerApp.getParameters()[0] != t0 && termNewAppInnerApp.getParameters()[1] != t0) {
                throw new AssertionError((Object)("Error 4 at " + rewriteRule));
            }
            if (termNewAppInnerApp.getParameters()[0] == this.mSkript.term("not", t2)) return;
            if (termNewAppInnerApp.getParameters()[1] == this.mSkript.term("not", t2)) return;
            throw new AssertionError((Object)("Error 5 at " + rewriteRule));
        }
        if (rewriteRule == ":iteBool5") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.pm_func(termOldApp, "ite");
            this.pm_func(termNewApp, "or");
            this.checkNumber(termOldApp, 3);
            this.checkNumber(termNewApp, 2);
            Term t0 = termOldApp.getParameters()[0];
            Term t1 = termOldApp.getParameters()[1];
            Term t2 = termOldApp.getParameters()[2];
            if (t2 != this.mSkript.term("true", new Term[0])) {
                throw new AssertionError((Object)("Error 3 at " + rewriteRule));
            }
            if (termNewApp.getParameters()[0] != t1 && termNewApp.getParameters()[1] != t1) {
                throw new AssertionError((Object)("Error 4 at " + rewriteRule));
            }
            if (termNewApp.getParameters()[0] == this.mSkript.term("not", t0)) return;
            if (termNewApp.getParameters()[1] == this.mSkript.term("not", t0)) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":iteBool6") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            ApplicationTerm termNewAppInnerApp = this.convertApp(termNewApp.getParameters()[0]);
            this.pm_func(termOldApp, "ite");
            this.pm_func(termNewApp, "not");
            this.pm_func(termNewAppInnerApp, "or");
            this.checkNumber(termOldApp, 3);
            this.checkNumber(termNewAppInnerApp, 2);
            Term t0 = termOldApp.getParameters()[0];
            Term t1 = termOldApp.getParameters()[1];
            Term t2 = termOldApp.getParameters()[2];
            if (t2 != this.mSkript.term("false", new Term[0])) {
                throw new AssertionError((Object)("Error 3 at " + rewriteRule));
            }
            if (termNewAppInnerApp.getParameters()[0] != this.mSkript.term("not", t0) && termNewAppInnerApp.getParameters()[1] != this.mSkript.term("not", t0)) {
                throw new AssertionError((Object)("Error 4 at " + rewriteRule));
            }
            if (termNewAppInnerApp.getParameters()[0] == this.mSkript.term("not", t1)) return;
            if (termNewAppInnerApp.getParameters()[1] == this.mSkript.term("not", t1)) return;
            throw new AssertionError((Object)("Error 5 at " + rewriteRule));
        }
        if (rewriteRule == ":andToOr") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            ApplicationTerm termNewAppInnerApp = this.convertApp(termNewApp.getParameters()[0]);
            this.pm_func(termOldApp, "and");
            this.pm_func(termNewApp, "not");
            this.pm_func(termNewAppInnerApp, "or");
            HashSet<Term> oldTerms = new HashSet<Term>();
            HashSet<Term> newTermsInner = new HashSet<Term>();
            oldTerms.addAll(Arrays.asList(termOldApp.getParameters()));
            for (int i = 0; i < termNewAppInnerApp.getParameters().length; ++i) {
                ApplicationTerm termAppTemp = this.convertApp(termNewAppInnerApp.getParameters()[i]);
                this.pm_func(termAppTemp, "not");
                newTermsInner.add(termAppTemp.getParameters()[0]);
            }
            if (oldTerms.equals(newTermsInner)) return;
            throw new AssertionError((Object)("Error at rule " + rewriteRule + "!\n The term was " + rewriteApp.toStringDirect()));
        }
        if (rewriteRule == ":xorToDistinct") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.pm_func(termOldApp, "xor");
            this.pm_func(termNewApp, "distinct");
            if (termOldApp.getParameters().length != termNewApp.getParameters().length) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            int i = 0;
            while (i < termOldApp.getParameters().length) {
                if (!termOldApp.getParameters()[i].equals(termNewApp.getParameters()[i])) {
                    throw new AssertionError((Object)("Error 2 at " + rewriteRule));
                }
                ++i;
            }
            return;
        }
        if (rewriteRule == ":impToOr") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.pm_func(termOldApp, "=>");
            this.pm_func(termNewApp, "or");
            HashSet<Term> oldTerms = new HashSet<Term>();
            HashSet<Term> newTerms = new HashSet<Term>();
            for (int i = 0; i < termOldApp.getParameters().length - 1; ++i) {
                oldTerms.add(termOldApp.getParameters()[i]);
            }
            Term termImp = termOldApp.getParameters()[termOldApp.getParameters().length - 1];
            if (termImp != termNewApp.getParameters()[0]) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            for (int i = 1; i < termNewApp.getParameters().length; ++i) {
                ApplicationTerm termAppTemp = this.convertApp(termNewApp.getParameters()[i]);
                this.pm_func(termAppTemp, "not");
                newTerms.add(termAppTemp.getParameters()[0]);
            }
            if (oldTerms.equals(newTerms)) return;
            throw new AssertionError((Object)("Error at rule " + rewriteRule + "!\n The term was " + rewriteApp.toStringDirect()));
        }
        if (rewriteRule == ":strip") {
            AnnotatedTerm stripAnnTerm = this.convertAnn(termEqApp.getParameters()[0]);
            if (stripAnnTerm.getSubterm() == termEqApp.getParameters()[1]) return;
            throw new AssertionError((Object)("Error: Couldn't verify a strip-rewrite. Those two terms should be the same but arent" + stripAnnTerm.getSubterm() + "vs. " + termEqApp.getParameters()[1] + "."));
        }
        if (rewriteRule == ":canonicalSum") {
            Term termOld = termEqApp.getParameters()[0];
            Term termNew = termEqApp.getParameters()[1];
            if (this.convertAffineTerm(termOld).equals(this.convertAffineTerm(termNew))) return;
            throw new AssertionError((Object)("Error at " + rewriteRule));
        }
        if (rewriteRule == ":gtToLeq0" || rewriteRule == ":geqToLeq0" || rewriteRule == ":ltToLeq0" || rewriteRule == ":leqToLeq0") {
            ApplicationTerm termNewIneqApp;
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.checkNumber(termOldApp, 2);
            this.checkNumber(termNewApp, 1);
            if (!(rewriteRule == ":gtToLeq0" && this.pm_func_weak(termOldApp, ">") || rewriteRule == ":geqToLeq0" && this.pm_func_weak(termOldApp, ">=") || rewriteRule == ":ltToLeq0" && this.pm_func_weak(termOldApp, "<"))) {
                if (rewriteRule != ":leqToLeq0") throw new AssertionError((Object)("Expected not the function symbol " + termOldApp.getFunction().getName() + " for the rule " + rewriteRule + ". \n The term is: " + termEqApp.toString()));
                if (!this.pm_func_weak(termOldApp, "<=")) {
                    throw new AssertionError((Object)("Expected not the function symbol " + termOldApp.getFunction().getName() + " for the rule " + rewriteRule + ". \n The term is: " + termEqApp.toString()));
                }
            }
            Term termT1 = termOldApp.getParameters()[0];
            Term termT2 = termOldApp.getParameters()[1];
            if (rewriteRule == ":ltToLeq0" || rewriteRule == ":gtToLeq0") {
                this.pm_func(termNewApp, "not");
                termNewIneqApp = this.convertApp(termNewApp.getParameters()[0]);
            } else {
                termNewIneqApp = termNewApp;
            }
            this.pm_func(termNewIneqApp, "<=");
            this.checkNumber(termNewIneqApp, 2);
            SMTAffineTerm termAffTemp = this.convertAffineTerm(termNewIneqApp.getParameters()[1]);
            this.isConstant(termAffTemp, Rational.ZERO);
            SMTAffineTerm leftside = this.convertAffineTerm(termNewIneqApp.getParameters()[0]);
            SMTAffineTerm termT1Aff = this.convertAffineTerm(termT1);
            SMTAffineTerm termT2Aff = this.convertAffineTerm(termT2);
            if (rewriteRule == ":gtToLeq0" || rewriteRule == ":leqToLeq0") {
                if (leftside.equals(termT1Aff.add(termT2Aff.negate()))) return;
                throw new AssertionError((Object)("Error: Wrong term on the left side of the new inequality. The term was: " + rewriteApp.toStringDirect() + "\n" + "Same should be " + leftside.toStringDirect() + " and " + termT1Aff.add(termT2Aff.negate()).toStringDirect() + "\n" + "Random number: 02653"));
            }
            if (leftside.equals(termT2Aff.add(termT1Aff.negate()))) return;
            throw new AssertionError((Object)("Error: Wrong term on the left side of the new inequality. The term was: " + termEqApp.toStringDirect() + "\n" + "Same should be " + leftside.toStringDirect() + " and " + termT2Aff.add(termT1Aff.negate()).toStringDirect() + "\n" + "Random number: 20472"));
        }
        if (rewriteRule == ":leqTrue") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.checkNumber(termOldApp, 2);
            this.pm_func(termOldApp, "<=");
            SMTAffineTerm constant = this.convertAffineTerm(this.convertConst_Neg(termOldApp.getParameters()[0]));
            if (constant.negate().getConstant().isNegative()) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            SMTAffineTerm termTemp = this.convertAffineTerm(termOldApp.getParameters()[1]);
            this.isConstant(termTemp, Rational.ZERO);
            if (termEqApp.getParameters()[1] == this.mSkript.term("true", new Term[0])) return;
            throw new AssertionError((Object)("Error 4 at " + rewriteRule));
        }
        if (rewriteRule == ":leqFalse") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "<=");
            this.checkNumber(termOldApp, 2);
            SMTAffineTerm constant = this.convertAffineTerm(this.convertConst_Neg(termOldApp.getParameters()[0]));
            if (constant.getConstant().isNegative()) throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            if (this.isConstant_weak(constant, Rational.ZERO)) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            SMTAffineTerm termTemp = this.convertAffineTerm(termOldApp.getParameters()[1]);
            this.isConstant(termTemp, Rational.ZERO);
            if (termEqApp.getParameters()[1] == this.mSkript.term("false", new Term[0])) return;
            throw new AssertionError((Object)("Error 4 at " + rewriteRule));
        }
        if (rewriteRule == ":desugar") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.pm_func(termOldApp, termNewApp.getFunction().getName());
            if (termOldApp.getParameters().length != termNewApp.getParameters().length) {
                throw new AssertionError((Object)"Error 1 in :desugar");
            }
            int i = 0;
            while (i < termNewApp.getParameters().length) {
                Term paramINew;
                Term paramIOld = termOldApp.getParameters()[i];
                if (!paramIOld.equals(paramINew = termNewApp.getParameters()[i])) {
                    SMTAffineTerm diffZero;
                    ApplicationTerm paramINewApp;
                    if (!this.convertAffineTerm(paramIOld).isIntegral()) {
                        throw new AssertionError((Object)"Error 2 in :desugar");
                    }
                    boolean correct = false;
                    if (paramINew instanceof ApplicationTerm && this.pm_func_weak(paramINewApp = this.convertApp(paramINew), "to_real")) {
                        if (!paramIOld.equals(paramINewApp.getParameters()[0])) throw new AssertionError((Object)"Error 4 in :desugar");
                        correct = true;
                    }
                    if (this.convertAffineTerm(paramINew).getSort() == this.mSkript.sort("Real", new Sort[0]) && (diffZero = this.convertAffineTerm(paramINew).add(this.convertAffineTerm(paramIOld).negate())).isConstant() && diffZero.getConstant() == Rational.ZERO) {
                        correct = true;
                    }
                    if (!correct) {
                        throw new AssertionError((Object)"Error 5 in :desugar");
                    }
                }
                ++i;
            }
            return;
        }
        if (rewriteRule == ":divisible") {
            Rational constN;
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.checkNumber(termOldApp, 1);
            Term termNew = termEqApp.getParameters()[1];
            Term termT = termOldApp.getParameters()[0];
            BigInteger bigIN = termOldApp.getFunction().getIndices()[0];
            this.pm_func(termOldApp, "divisible");
            if (!termNew.equals(this.mSkript.term("true", new Term[0])) && !termNew.equals(this.mSkript.term("false", new Term[0]))) {
                ApplicationTerm termNewAppProd;
                ApplicationTerm termNewApp = this.convertApp(termNew);
                this.pm_func(termNewApp, "=");
                this.checkNumber(termNewApp, 2);
                if (termNewApp.getParameters()[0].equals(termT)) {
                    termNewAppProd = this.convertApp(termNewApp.getParameters()[1]);
                } else {
                    if (!termNewApp.getParameters()[1].equals(termT)) throw new AssertionError((Object)"Error 1 in divisible");
                    termNewAppProd = this.convertApp(termNewApp.getParameters()[0]);
                }
                ApplicationTerm termNewAppDiv = null;
                boolean found = false;
                this.checkNumber(termNewAppProd, 2);
                if (termNewAppProd.getParameters()[0] instanceof ConstantTerm && this.convertConst(termNewAppProd.getParameters()[0]).getValue().equals(bigIN)) {
                    termNewAppDiv = this.convertApp(termNewAppProd.getParameters()[1]);
                    found = true;
                }
                if (termNewAppProd.getParameters()[1] instanceof ConstantTerm && this.convertConst(termNewAppProd.getParameters()[1]).getValue().equals(bigIN)) {
                    termNewAppDiv = this.convertApp(termNewAppProd.getParameters()[0]);
                    found = true;
                }
                this.checkNumber(termNewAppDiv, 2);
                if (!found) {
                    throw new AssertionError((Object)"Error 2 in divisible");
                }
                this.pm_func(termNewAppProd, "*");
                if (!this.pm_func_weak(termNewAppDiv, "div") && !this.pm_func_weak(termNewAppDiv, "/")) {
                    throw new AssertionError((Object)"Error 3 in divisible");
                }
                if (!termNewAppDiv.getParameters()[0].equals(termT)) {
                    throw new AssertionError((Object)"Error 4 in divisible");
                }
                if (this.convertConst(termNewAppDiv.getParameters()[1]).getValue().equals(bigIN)) return;
                throw new AssertionError((Object)"Error 5 in divisible");
            }
            Rational constT = this.convertAffineTerm(this.convertConst_Neg(termT)).getConstant();
            if (constT.div(constN = Rational.valueOf(bigIN, BigInteger.ONE)).isIntegral() && !termNew.equals(this.mSkript.term("true", new Term[0]))) {
                throw new AssertionError((Object)"Error 6 in divisible");
            }
            if (constT.div(constN).isIntegral()) return;
            if (termNew.equals(this.mSkript.term("false", new Term[0]))) return;
            throw new AssertionError((Object)"Error 7 in divisible");
        }
        if (rewriteRule == ":div1") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "div");
            this.checkNumber(termOldApp, 2);
            SMTAffineTerm constant = this.convertAffineTerm(this.convertConst_Neg(termOldApp.getParameters()[1]));
            if (!constant.isConstant()) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (!constant.getConstant().equals(Rational.ONE)) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (termEqApp.getParameters()[1] == termOldApp.getParameters()[0]) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":div-1") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "div");
            this.checkNumber(termOldApp, 2);
            this.convertConst_Neg(termOldApp.getParameters()[1]);
            SMTAffineTerm constant = this.convertAffineTerm(termOldApp.getParameters()[1]);
            if (!constant.negate().isConstant()) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (!constant.negate().getConstant().equals(Rational.ONE)) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (this.convertAffineTerm(termEqApp.getParameters()[1]).negate().equals(this.convertAffineTerm(termOldApp.getParameters()[0]))) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":divConst") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "div");
            this.checkNumber(termOldApp, 2);
            this.convertConst_Neg(termOldApp.getParameters()[0]);
            this.convertConst_Neg(termOldApp.getParameters()[1]);
            SMTAffineTerm c1 = this.convertAffineTerm(termOldApp.getParameters()[0]);
            SMTAffineTerm c2 = this.convertAffineTerm(termOldApp.getParameters()[1]);
            SMTAffineTerm d = this.convertAffineTerm(termEqApp.getParameters()[1]);
            if (!c1.isConstant()) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (!c2.isConstant()) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (c2.getConstant().equals(Rational.ZERO)) {
                throw new AssertionError((Object)("Error 3 at " + rewriteRule));
            }
            if (!c1.isIntegral()) throw new AssertionError((Object)("Error 4 at " + rewriteRule));
            if (!c2.isIntegral()) throw new AssertionError((Object)("Error 4 at " + rewriteRule));
            if (!d.isIntegral()) {
                throw new AssertionError((Object)("Error 4 at " + rewriteRule));
            }
            if (c2.getConstant().isNegative() && !d.getConstant().equals(c1.getConstant().div(c2.getConstant()).ceil())) {
                throw new AssertionError((Object)("Error 5 at " + rewriteRule));
            }
            if (c2.getConstant().isNegative()) return;
            if (d.getConstant().equals(c1.getConstant().div(c2.getConstant()).floor())) return;
            throw new AssertionError((Object)("Error 6 at " + rewriteRule));
        }
        if (rewriteRule == ":modulo1") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "mod");
            this.checkNumber(termOldApp, 2);
            if (!(termOldApp.getParameters()[0] instanceof ConstantTerm) && !this.checkInt_weak(termOldApp.getParameters()[0])) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            this.convertConst(termOldApp.getParameters()[1]);
            this.convertConst(termEqApp.getParameters()[1]);
            SMTAffineTerm constant1 = this.convertAffineTerm(termOldApp.getParameters()[1]);
            SMTAffineTerm constant0 = this.convertAffineTerm(termEqApp.getParameters()[1]);
            if (!constant1.getConstant().equals(Rational.ONE)) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (constant0.getConstant().equals(Rational.ZERO)) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":modulo-1") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "mod");
            this.checkNumber(termOldApp, 2);
            if (!(termOldApp.getParameters()[0] instanceof ConstantTerm) && !this.checkInt_weak(termOldApp.getParameters()[0])) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            this.convertConst_Neg(termOldApp.getParameters()[1]);
            this.convertConst(termEqApp.getParameters()[1]);
            SMTAffineTerm constantm1 = this.convertAffineTerm(termOldApp.getParameters()[1]);
            SMTAffineTerm constant0 = this.convertAffineTerm(termEqApp.getParameters()[1]);
            if (!constantm1.getConstant().negate().equals(Rational.ONE)) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (constant0.getConstant().equals(Rational.ZERO)) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":moduloConst") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "mod");
            this.checkNumber(termOldApp, 2);
            if (!(termOldApp.getParameters()[0] instanceof ConstantTerm) && !this.checkInt_weak(termOldApp.getParameters()[0])) {
                throw new AssertionError((Object)("Error 1a at " + rewriteRule));
            }
            if (!(termOldApp.getParameters()[1] instanceof ConstantTerm) && !this.checkInt_weak(termOldApp.getParameters()[1])) {
                throw new AssertionError((Object)("Error 1b at " + rewriteRule));
            }
            if (!(termEqApp.getParameters()[1] instanceof ConstantTerm) && !this.checkInt_weak(termEqApp.getParameters()[1])) {
                throw new AssertionError((Object)("Error 1c at " + rewriteRule));
            }
            SMTAffineTerm c1 = this.convertAffineTerm(termOldApp.getParameters()[0]);
            SMTAffineTerm c2 = this.convertAffineTerm(termOldApp.getParameters()[1]);
            SMTAffineTerm d = this.convertAffineTerm(termEqApp.getParameters()[1]);
            if (c2.getConstant().equals(Rational.ZERO)) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (!c1.isIntegral()) throw new AssertionError((Object)("Error 3 at " + rewriteRule));
            if (!c2.isIntegral()) throw new AssertionError((Object)("Error 3 at " + rewriteRule));
            if (!d.isIntegral()) {
                throw new AssertionError((Object)("Error 3 at " + rewriteRule));
            }
            if (c2.getConstant().isNegative()) {
                if (d.equals(c1.add(c2.mul(c1.div(c2.getConstant()).getConstant().ceil()).negate()))) return;
                throw new AssertionError((Object)("Error 4 at " + rewriteRule));
            }
            if (d.equals(c1.add(c2.mul(c1.div(c2.getConstant()).getConstant().floor()).negate()))) return;
            throw new AssertionError((Object)("Error 5 at " + rewriteRule));
        }
        if (rewriteRule == ":modulo") {
            Term termNewNotDiv;
            ApplicationTerm termNewDiv;
            Term termNewNotProd;
            ApplicationTerm termNewProd;
            ApplicationTerm termOldMod = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewSum = this.convertApp(termEqApp.getParameters()[1]);
            this.checkNumber(termOldMod, 2);
            this.checkNumber(termNewSum, 2);
            Term termOldX = termOldMod.getParameters()[0];
            Term termOldY = termOldMod.getParameters()[1];
            if (termNewSum.getParameters()[0] instanceof ApplicationTerm) {
                if (this.pm_func_weak(termNewSum.getParameters()[0], "*")) {
                    termNewProd = this.convertApp(termNewSum.getParameters()[0]);
                    termNewNotProd = termNewSum.getParameters()[1];
                } else {
                    termNewProd = this.convertApp(termNewSum.getParameters()[1]);
                    termNewNotProd = termNewSum.getParameters()[0];
                }
            } else {
                termNewProd = this.convertApp(termNewSum.getParameters()[1]);
                termNewNotProd = termNewSum.getParameters()[0];
            }
            this.checkNumber(termNewProd, 2);
            if (termNewProd.getParameters()[0] instanceof ApplicationTerm) {
                if (this.pm_func_weak(termNewProd.getParameters()[0], "/") || this.pm_func_weak(termNewProd.getParameters()[0], "div")) {
                    termNewDiv = this.convertApp(termNewProd.getParameters()[0]);
                    termNewNotDiv = termNewProd.getParameters()[1];
                } else {
                    termNewDiv = this.convertApp(termNewProd.getParameters()[1]);
                    termNewNotDiv = termNewProd.getParameters()[0];
                }
            } else {
                termNewDiv = this.convertApp(termNewProd.getParameters()[1]);
                termNewNotDiv = termNewProd.getParameters()[0];
            }
            this.checkNumber(termNewDiv, 2);
            this.pm_func(termOldMod, "mod");
            this.pm_func(termNewSum, "+");
            this.pm_func(termNewProd, "*");
            if (!this.pm_func_weak(termNewDiv, "div") && !this.pm_func_weak(termNewDiv, "/")) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (termNewNotProd != termOldX) throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            if (!this.convertAffineTerm(termNewNotDiv).equals(this.convertAffineTerm(termOldY).negate())) throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            if (termNewDiv.getParameters()[0] != termOldX) throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            if (termNewDiv.getParameters()[1] == termOldY) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":toInt") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "to_int");
            Term termV = this.convertConst_Neg(termEqApp.getParameters()[1]);
            Term termR = termOldApp.getParameters()[0];
            if (termR instanceof ApplicationTerm) {
                ApplicationTerm termRApp = this.convertApp(termR);
                if (this.pm_func_weak(termRApp, "-") && termRApp.getParameters()[0] instanceof ApplicationTerm) {
                    ApplicationTerm termRInnerApp = this.convertApp(termRApp.getParameters()[0]);
                    this.pm_func(termRInnerApp, "/");
                    this.checkNumber(termRInnerApp, 2);
                    this.convertConst_Neg(termRInnerApp.getParameters()[0]);
                    this.convertConst_Neg(termRInnerApp.getParameters()[1]);
                } else if (this.pm_func_weak(termRApp, "/")) {
                    this.pm_func(termRApp, "/");
                    this.checkNumber(termRApp, 2);
                    this.convertConst_Neg(termRApp.getParameters()[0]);
                    this.convertConst_Neg(termRApp.getParameters()[1]);
                } else {
                    this.pm_func(termRApp, "-");
                    this.convertConst(termRApp.getParameters()[0]);
                }
            } else {
                this.convertConst(termR);
            }
            if (this.convertAffineTerm(termR).getConstant().floor().equals(this.convertAffineTerm(termV).getConstant())) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":toReal") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            this.pm_func(termOldApp, "to_real");
            Term termOldC = this.convertConst_Neg(termOldApp.getParameters()[0]);
            Term termNewC = this.convertConst_Neg(termEqApp.getParameters()[1]);
            if (this.convertAffineTerm(termOldC).getConstant().equals(this.convertAffineTerm(termNewC).getConstant())) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":storeOverStore") {
            System.out.println("\n \n \n Now finally tested: " + rewriteRule);
            this.checkNumber(termEqApp.getParameters(), 2);
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            ApplicationTerm termOldAppInnerApp = this.convertApp(termOldApp.getParameters()[0]);
            this.checkNumber(termOldApp.getParameters(), 3);
            this.checkNumber(termOldAppInnerApp.getParameters(), 3);
            this.checkNumber(termNewApp.getParameters(), 3);
            this.pm_func(termOldApp, "store");
            this.pm_func(termOldAppInnerApp, "store");
            this.pm_func(termNewApp, "store");
            if (termOldApp.getParameters()[1] != termOldAppInnerApp.getParameters()[1]) throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            if (termOldApp.getParameters()[1] != termNewApp.getParameters()[1]) {
                throw new AssertionError((Object)("Error 1 at " + rewriteRule));
            }
            if (termOldApp.getParameters()[2] != termNewApp.getParameters()[2]) {
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            if (termOldAppInnerApp.getParameters()[0] == termNewApp.getParameters()[0]) return;
            throw new AssertionError((Object)("Error 3 at " + rewriteRule));
        }
        if (rewriteRule == ":selectOverStore") {
            System.out.println("\n \n \n Now finally tested: " + rewriteRule);
            this.checkNumber(termEqApp.getParameters(), 2);
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            Term termNew = termEqApp.getParameters()[1];
            ApplicationTerm termOldAppInnerApp = this.convertApp(termOldApp.getParameters()[0]);
            this.checkNumber(termOldApp, 2);
            this.checkNumber(termOldAppInnerApp, 3);
            this.pm_func(termOldApp, "select");
            this.pm_func(termOldAppInnerApp, "store");
            if (termOldApp.getParameters()[1] == termOldAppInnerApp.getParameters()[1]) {
                if (termOldAppInnerApp.getParameters()[2] == termNew) return;
                throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            }
            ApplicationTerm termNewApp = this.convertApp(termNew);
            this.checkNumber(termNewApp.getParameters(), 2);
            this.pm_func(termNewApp, "select");
            Term c1 = this.convertConst_Neg(termOldAppInnerApp.getParameters()[1]);
            Term c2 = this.convertConst_Neg(termOldApp.getParameters()[1]);
            if (c1 == c2) {
                throw new AssertionError((Object)("Error 3 at " + rewriteRule));
            }
            if (c2 == termNewApp.getParameters()[1]) throw new AssertionError((Object)"selectOverStore with distinct indices");
            throw new AssertionError((Object)("Error 4 at " + rewriteRule));
        }
        if (rewriteRule == ":storeRewrite") {
            System.out.println("\n \n \n Now finally tested: " + rewriteRule);
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            ApplicationTerm termNewAppInnerApp = this.convertApp(termNewApp.getParameters()[0]);
            ApplicationTerm termOldAppInnerApp = null;
            this.checkNumber(termNewApp.getParameters(), 2);
            this.checkNumber(termNewAppInnerApp.getParameters(), 2);
            this.checkNumber(termOldApp.getParameters(), 2);
            Term termA = termNewAppInnerApp.getParameters()[0];
            Term termI = termNewAppInnerApp.getParameters()[1];
            Term termV = termNewApp.getParameters()[1];
            if (termOldApp.getParameters()[0] == termA) {
                termOldAppInnerApp = this.convertApp(termOldApp.getParameters()[1]);
            } else {
                if (termOldApp.getParameters()[1] != termA) throw new AssertionError((Object)("Error 1 in " + rewriteRule));
                termOldAppInnerApp = this.convertApp(termOldApp.getParameters()[0]);
            }
            this.checkNumber(termOldAppInnerApp.getParameters(), 3);
            this.pm_func(termOldApp, "=");
            this.pm_func(termOldAppInnerApp, "store");
            this.pm_func(termNewApp, "=");
            this.pm_func(termNewAppInnerApp, "select");
            if (termOldAppInnerApp.getParameters()[0] != termA) throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            if (termOldAppInnerApp.getParameters()[1] != termI) throw new AssertionError((Object)("Error 2 at " + rewriteRule));
            if (termOldAppInnerApp.getParameters()[2] == termV) return;
            throw new AssertionError((Object)("Error 2 at " + rewriteRule));
        }
        if (rewriteRule == ":expand") {
            Term termOld = termEqApp.getParameters()[0];
            Term termNew = termEqApp.getParameters()[1];
            if (this.convertAffineTerm(termOld).equals(this.convertAffineTerm(termNew))) return;
            throw new AssertionError((Object)("Error in " + rewriteRule));
        }
        if (rewriteRule == ":flatten") {
            ApplicationTerm termOldApp = this.convertApp(termEqApp.getParameters()[0]);
            ApplicationTerm termNewApp = this.convertApp(termEqApp.getParameters()[1]);
            this.pm_func(termOldApp, "or");
            this.pm_func(termNewApp, "or");
            HashSet<Term> oldDisjuncts = new HashSet<Term>();
            HashSet<Term> newDisjuncts = new HashSet<Term>();
            ArrayList<Term> disjuncts = new ArrayList<Term>();
            disjuncts.addAll(Arrays.asList(termOldApp.getParameters()));
            while (disjuncts.size() > 0) {
                Term currentDisjunct = (Term)disjuncts.remove(disjuncts.size() - 1);
                boolean currentIsDisjunction = false;
                if (currentDisjunct instanceof ApplicationTerm) {
                    currentIsDisjunction = this.pm_func_weak(currentDisjunct, "or");
                }
                if (currentIsDisjunction) {
                    ApplicationTerm currentDisjunctApp = this.convertApp(currentDisjunct);
                    disjuncts.addAll(Arrays.asList(currentDisjunctApp.getParameters()));
                    continue;
                }
                oldDisjuncts.add(currentDisjunct);
            }
            newDisjuncts.addAll(Arrays.asList(termNewApp.getParameters()));
            if (oldDisjuncts.equals(newDisjuncts)) return;
            throw new AssertionError((Object)("Error in the rule " + rewriteRule + "!\n The term was " + rewriteApp.toStringDirect()));
        }
        System.out.println("Can't handle the following rule " + termAppInnerAnn.getAnnotations()[0].getKey() + ", therefore...");
        System.out.println("...believed as alright to be rewritten: " + rewriteApp.getParameters()[0].toStringDirect() + " .");
    }

    public void walkIntern(ApplicationTerm internApp) {
        Term[] sides;
        Term equality = internApp.getParameters()[0];
        this.stackPush(equality, internApp);
        if (!this.isApplication("=", equality) || ((ApplicationTerm)equality).getParameters().length != 2) {
            this.reportError("Not an equality");
            return;
        }
        Term oldTerm = ((ApplicationTerm)equality).getParameters()[0];
        Term newTerm = ((ApplicationTerm)equality).getParameters()[1];
        boolean isNegated = this.isApplication("not", newTerm);
        if (isNegated) {
            newTerm = ((ApplicationTerm)newTerm).getParameters()[0];
        }
        newTerm = this.unquote(newTerm);
        if (this.isApplication("not", oldTerm)) {
            oldTerm = ((ApplicationTerm)oldTerm).getParameters()[0];
            boolean bl = isNegated = !isNegated;
        }
        if (oldTerm == newTerm && !isNegated) {
            return;
        }
        if (this.isApplication("<=", oldTerm) || this.isApplication("<", oldTerm)) {
            Term[] oldArgs = ((ApplicationTerm)oldTerm).getParameters();
            SMTAffineTerm zero = this.convertAffineTerm(oldArgs[1]);
            if (oldArgs.length != 2 || !zero.isConstant() || !zero.getConstant().equals(Rational.ZERO)) {
                this.reportError("Not a normalized <= on LHS: " + equality);
                return;
            }
            Term[] newArgs = ((ApplicationTerm)newTerm).getParameters();
            zero = this.convertAffineTerm(newArgs[1]);
            if (newArgs.length != 2 || !zero.isConstant() || !zero.getConstant().equals(Rational.ZERO)) {
                this.reportError("Not a normalized <= on RHS: " + equality);
                return;
            }
            SMTAffineTerm oldAffine = this.convertAffineTerm(oldArgs[0]);
            SMTAffineTerm newAffine = this.convertAffineTerm(newArgs[0]);
            if (oldAffine.isConstant() || newAffine.isConstant()) {
                this.reportError("Invalid @intern rule " + equality);
            }
            if (!oldAffine.getGcd().equals(Rational.ONE)) {
                oldAffine = oldAffine.mul(oldAffine.getGcd().inverse());
            }
            if (!newAffine.getGcd().equals(Rational.ONE)) {
                this.reportError("Not normalized RHS: " + equality);
                return;
            }
            if (newArgs[0].getSort().getName().equals("Int")) {
                if (!this.isApplication("<=", oldTerm) || !this.isApplication("<=", newTerm)) {
                    return;
                }
                oldAffine = oldAffine.add(oldAffine.getConstant().frac().negate());
            }
            boolean newIsStrict = this.isApplication("<", newTerm);
            if (isNegated) {
                newAffine = newAffine.negate();
                if (newArgs[0].getSort().getName().equals("Int")) {
                    newAffine = newAffine.add(Rational.ONE);
                } else {
                    boolean bl = newIsStrict = !newIsStrict;
                }
            }
            if (!oldAffine.equals(newAffine) || newIsStrict != this.isApplication("<", oldTerm)) {
                this.reportError("LHS and RHS not equal: " + oldAffine + " != " + newAffine + " in " + equality);
            }
            return;
        }
        if (this.isApplication("=", oldTerm) && this.isApplication("=", newTerm) && !isNegated) {
            Term[] oldArgs = ((ApplicationTerm)oldTerm).getParameters();
            Term[] newArgs = ((ApplicationTerm)newTerm).getParameters();
            if (oldArgs.length != 2 || newArgs.length != 2) {
                this.reportError("Not a binary equality rewrite: " + equality);
                return;
            }
            if (oldArgs[0] == newArgs[1] && oldArgs[1] == newArgs[0]) {
                return;
            }
            SMTAffineTerm zero = this.convertAffineTerm(newArgs[1]);
            if (newArgs.length != 2 || !zero.isConstant() || !zero.getConstant().equals(Rational.ZERO)) {
                this.reportError("Not a normalized = on RHS: " + equality);
                return;
            }
            SMTAffineTerm oldAffine = this.convertAffineTerm(oldArgs[0]).add(this.convertAffineTerm(oldArgs[1]).negate());
            SMTAffineTerm newAffine = this.convertAffineTerm(newArgs[0]);
            if (oldAffine.isConstant() || newAffine.isConstant()) {
                this.reportError("Invalid @intern rule " + equality);
            }
            if (!oldAffine.getGcd().equals(Rational.ONE)) {
                oldAffine = oldAffine.mul(oldAffine.getGcd().inverse());
            }
            if (!newAffine.getGcd().equals(Rational.ONE)) {
                this.reportError("Not normalized RHS: " + equality);
                return;
            }
            if (!oldAffine.equals(newAffine) && !oldAffine.negate().equals(newAffine)) {
                this.reportError("LHS and RHS not equal: " + oldAffine + " != " + newAffine + " in " + equality);
            }
            return;
        }
        if (!this.isApplication("=", oldTerm) && this.isApplication("=", newTerm) && (sides = ((ApplicationTerm)newTerm).getParameters()).length == 2 && this.isApplication("true", sides[1]) && sides[0] == oldTerm) {
            return;
        }
        this.reportError("Unhandled @intern rule " + equality.toStringDirect());
    }

    private Term[] termToClause(Term clauseTerm) {
        assert (clauseTerm != null && clauseTerm.getSort().getName() == "Bool");
        if (this.isApplication("or", clauseTerm)) {
            return ((ApplicationTerm)clauseTerm).getParameters();
        }
        if (this.isApplication("false", clauseTerm)) {
            return new Term[0];
        }
        return new Term[]{clauseTerm};
    }

    private Term clauseToTerm(Collection<Term> disjuncts) {
        if (disjuncts.size() <= 1) {
            if (disjuncts.size() == 0) {
                return this.mSkript.term("false", new Term[0]);
            }
            return disjuncts.iterator().next();
        }
        Term[] args = disjuncts.toArray(new Term[disjuncts.size()]);
        return this.mSkript.term("or", args);
    }

    public void walkResolution(ApplicationTerm resApp) {
        Term[] termArgs = resApp.getParameters();
        Term[] pivots = new Term[termArgs.length];
        Term[] clauseTerms = new Term[termArgs.length];
        for (int i = termArgs.length - 1; i >= 1; --i) {
            AnnotatedTerm pivotPlusProof = (AnnotatedTerm)termArgs[i];
            if (pivotPlusProof.getAnnotations().length != 1 || pivotPlusProof.getAnnotations()[0].getKey() != ":pivot") {
                throw new IllegalArgumentException("Annotation :pivot expected");
            }
            pivots[i] = (Term)pivotPlusProof.getAnnotations()[0].getValue();
            clauseTerms[i] = this.stackPopCheck(pivotPlusProof.getSubterm());
        }
        clauseTerms[0] = this.stackPopCheck(termArgs[0]);
        HashSet<Term> allDisjuncts = new HashSet<Term>();
        allDisjuncts.addAll(Arrays.asList(this.termToClause(clauseTerms[0])));
        for (int i = 1; i < termArgs.length; ++i) {
            if (!allDisjuncts.remove(this.negate(pivots[i]))) {
                this.reportWarning("Could not find negated pivot in main clause");
            }
            Term[] clause = this.termToClause(clauseTerms[i]);
            boolean pivotFound = false;
            for (Term t : clause) {
                if (t == pivots[i]) {
                    pivotFound = true;
                    continue;
                }
                allDisjuncts.add(t);
            }
            if (pivotFound) continue;
            this.reportWarning("Could not find pivot in secondary clause");
        }
        this.stackPush(this.clauseToTerm(allDisjuncts), resApp);
    }

    public void walkEquality(ApplicationTerm eqApp) {
        Term[] eqParams = eqApp.getParameters();
        Term[] rewrites = new Term[eqParams.length - 1];
        for (int i = eqParams.length - 1; i >= 1; --i) {
            rewrites[i - 1] = this.stackPopCheck(eqParams[i]);
        }
        Term termEdit = this.stackPopCheck(eqParams[0]);
        for (Term rewrite : rewrites) {
            this.pm_func(rewrite, "=");
            Term[] rewriteSides = ((ApplicationTerm)rewrite).getParameters();
            if (rewriteSides.length != 2) {
                this.reportError("Rewrite equality with more than two sides?");
            }
            termEdit = this.rewriteTerm(termEdit, rewriteSides[0], rewriteSides[1]);
        }
        this.stackPush(termEdit, eqApp);
    }

    public void walkClause(ApplicationTerm clauseApp) {
        HashSet<Term> param2Disjuncts;
        Term clauseTerm1 = this.stackPopCheck(clauseApp.getParameters()[0]);
        Term clauseTerm2 = clauseApp.getParameters()[1];
        HashSet<Term> param1Disjuncts = new HashSet<Term>(Arrays.asList(this.termToClause(clauseTerm1)));
        if (!param1Disjuncts.equals(param2Disjuncts = new HashSet<Term>(Arrays.asList(this.termToClause(clauseTerm2))))) {
            this.reportError("The clause-operation didn't permute correctly!");
        }
        this.stackPush(clauseTerm2, clauseApp);
    }

    public void walkSplit(ApplicationTerm splitApp) {
        AnnotatedTerm termAppSplitInnerAnn = (AnnotatedTerm)splitApp.getParameters()[0];
        ApplicationTerm termSplitReturnApp = (ApplicationTerm)splitApp.getParameters()[1];
        ApplicationTerm termOldCalcApp = (ApplicationTerm)this.stackPopCheck(termAppSplitInnerAnn.getSubterm());
        Term termSplitReturnInner = termSplitReturnApp.getParameters()[0];
        String splitRule = termAppSplitInnerAnn.getAnnotations()[0].getKey();
        if (this.mDebug.contains("currently")) {
            System.out.println("Split-Rule: " + splitRule);
        }
        if (this.mDebug.contains("hardTerm")) {
            System.out.println("Term: " + splitApp.toStringDirect());
        }
        if (splitRule == ":notOr") {
            if (this.mDebug.contains("split_notOr")) {
                System.out.println("Meldung: Wandle um (berechnet):");
                System.out.println(termOldCalcApp.toStringDirect());
                System.out.println("in");
                System.out.println(splitApp.getParameters()[1].toStringDirect());
            }
            this.pm_func(termSplitReturnApp, "not");
            if (!this.pm_func_weak(termOldCalcApp, "not")) {
                System.out.println("Breakpoint");
            }
            this.pm_func(termOldCalcApp, "not");
            ApplicationTerm termOldCalcAppInnerApp = this.convertApp(termOldCalcApp.getParameters()[0]);
            this.pm_func(termOldCalcAppInnerApp, "or");
            for (Term disjunct : termOldCalcAppInnerApp.getParameters()) {
                if (disjunct != termSplitReturnInner) continue;
                this.stackPush(splitApp.getParameters()[1], splitApp);
                return;
            }
            throw new AssertionError((Object)"Error in \"split\"");
        }
        if (splitRule == ":=+1" || splitRule == ":=+2") {
            int rr = 2;
            if (splitRule == ":=+1") {
                rr = 1;
            }
            ApplicationTerm termOldApp = termOldCalcApp;
            ApplicationTerm termNewApp = termSplitReturnApp;
            this.checkNumber(termOldApp, 2);
            this.checkNumber(termNewApp, 2);
            Term termNewNeg = termOldApp.getParameters()[2 - rr];
            Term termNewPos = termOldApp.getParameters()[rr - 1];
            this.pm_func(termOldApp, "=");
            this.pm_func(termNewApp, "or");
            if (termNewApp.getParameters()[rr - 1] != this.mSkript.term("not", termNewNeg) && termNewApp.getParameters()[2 - rr] != this.mSkript.term("not", termNewNeg)) {
                throw new AssertionError((Object)("Error 1 at " + splitRule));
            }
            if (termNewApp.getParameters()[rr - 1] != termNewPos && termNewApp.getParameters()[2 - rr] != termNewPos) {
                throw new AssertionError((Object)("Error 2 at " + splitRule));
            }
            this.stackPush(splitApp.getParameters()[1], splitApp);
            return;
        }
        if (splitRule == ":=-1" || splitRule == ":=-2") {
            this.checkNumber(splitApp, 2);
            ApplicationTerm termOldApp = termOldCalcApp;
            ApplicationTerm termNewApp = termSplitReturnApp;
            this.checkNumber(termOldApp, 1);
            this.checkNumber(termNewApp, 2);
            ApplicationTerm termOldAppInnerApp = this.convertApp(termOldApp.getParameters()[0]);
            this.checkNumber(termOldAppInnerApp, 2);
            Term termF1 = termOldAppInnerApp.getParameters()[0];
            Term termF2 = termOldAppInnerApp.getParameters()[1];
            this.pm_func(termOldApp, "not");
            this.pm_func(termOldAppInnerApp, "=");
            this.pm_func(termNewApp, "or");
            if (splitRule == ":=-1") {
                if (termNewApp.getParameters()[0] != termF1 && termNewApp.getParameters()[1] != termF1) {
                    throw new AssertionError((Object)("Error 1 at " + splitRule));
                }
                if (termNewApp.getParameters()[0] != termF2 && termNewApp.getParameters()[1] != termF2) {
                    throw new AssertionError((Object)("Error 2 at " + splitRule));
                }
            } else {
                ApplicationTerm termNewAppInner1App = this.convertApp(termNewApp.getParameters()[0]);
                ApplicationTerm termNewAppInner2App = this.convertApp(termNewApp.getParameters()[1]);
                this.pm_func(termNewAppInner1App, "not");
                this.pm_func(termNewAppInner2App, "not");
                if (termNewAppInner1App.getParameters()[0] != termF1 && termNewAppInner2App.getParameters()[0] != termF1) {
                    throw new AssertionError((Object)("Error 3 at " + splitRule));
                }
                if (termNewAppInner1App.getParameters()[0] != termF2 && termNewAppInner2App.getParameters()[0] != termF2) {
                    throw new AssertionError((Object)("Error 4 at " + splitRule));
                }
            }
            this.stackPush(splitApp.getParameters()[1], splitApp);
            return;
        }
        if (splitRule == ":ite+1" || splitRule == ":ite+2") {
            this.checkNumber(splitApp, 2);
            ApplicationTerm termOldApp = termOldCalcApp;
            ApplicationTerm termNewApp = termSplitReturnApp;
            this.checkNumber(termOldApp, 3);
            this.checkNumber(termNewApp, 2);
            Term termF1 = termOldApp.getParameters()[0];
            Term termF2 = termOldApp.getParameters()[1];
            Term termF3 = termOldApp.getParameters()[2];
            this.pm_func(termOldApp, "ite");
            this.pm_func(termNewApp, "or");
            if (splitRule == ":ite+2") {
                if (termNewApp.getParameters()[0] != termF1 && termNewApp.getParameters()[1] != termF1) {
                    throw new AssertionError((Object)("Error 1a at " + splitRule));
                }
                if (termNewApp.getParameters()[0] != termF3 && termNewApp.getParameters()[1] != termF3) {
                    throw new AssertionError((Object)("Error 1b at " + splitRule));
                }
            } else {
                if (termNewApp.getParameters()[0] != termF2 && termNewApp.getParameters()[1] != termF2) {
                    throw new AssertionError((Object)("Error 2a at " + splitRule));
                }
                if (termNewApp.getParameters()[0] != this.mSkript.term("not", termF1) && termNewApp.getParameters()[1] != this.mSkript.term("not", termF1)) {
                    throw new AssertionError((Object)("Error 2b at " + splitRule));
                }
            }
            this.stackPush(splitApp.getParameters()[1], splitApp);
            return;
        }
        if (splitRule == ":ite-1" || splitRule == ":ite-2") {
            this.checkNumber(splitApp, 2);
            ApplicationTerm termOldApp = termOldCalcApp;
            ApplicationTerm termNewApp = termSplitReturnApp;
            this.checkNumber(termOldApp, 1);
            this.checkNumber(termNewApp, 2);
            ApplicationTerm termOldAppInnerApp = this.convertApp(termOldApp.getParameters()[0]);
            this.checkNumber(termOldAppInnerApp, 3);
            Term termF1 = termOldAppInnerApp.getParameters()[0];
            Term termF2 = termOldAppInnerApp.getParameters()[1];
            Term termF3 = termOldAppInnerApp.getParameters()[2];
            this.pm_func(termOldApp, "not");
            this.pm_func(termOldAppInnerApp, "ite");
            this.pm_func(termNewApp, "or");
            if (splitRule == ":ite-2") {
                if (termNewApp.getParameters()[0] != termF1 && termNewApp.getParameters()[1] != termF1) {
                    throw new AssertionError((Object)("Error 1 at " + splitRule));
                }
                if (termNewApp.getParameters()[0] != this.mSkript.term("not", termF3) && termNewApp.getParameters()[1] != this.mSkript.term("not", termF3)) {
                    throw new AssertionError((Object)("Error 2 at " + splitRule));
                }
            } else {
                ApplicationTerm termNewAppInner2App = this.convertApp(termNewApp.getParameters()[1]);
                ApplicationTerm termNewAppInner1App = this.convertApp(termNewApp.getParameters()[0]);
                this.pm_func(termNewAppInner1App, "not");
                this.pm_func(termNewAppInner2App, "not");
                this.checkNumber(termNewAppInner1App, 1);
                this.checkNumber(termNewAppInner2App, 1);
                if (termNewAppInner1App.getParameters()[0] != termF2 && termNewAppInner2App.getParameters()[0] != termF1) {
                    throw new AssertionError((Object)("Error 3 at " + splitRule));
                }
                if (termNewAppInner1App.getParameters()[0] != termF1 && termNewAppInner2App.getParameters()[0] != termF2) {
                    throw new AssertionError((Object)("Error 4 at " + splitRule));
                }
            }
            this.stackPush(splitApp.getParameters()[1], splitApp);
            return;
        }
        throw new AssertionError((Object)("Error: The following split-rule is unknown: " + splitRule));
    }

    public void stackPush(Term pushTerm, ApplicationTerm keyTerm) {
        this.mCacheConv.put(keyTerm, pushTerm);
        this.mStackResults.push(pushTerm);
        this.mStackResultsDebug.push(keyTerm);
    }

    public Term stackPopCheck(Term expected) {
        if (this.mStackResults.size() != this.mStackResultsDebug.size()) {
            throw new AssertionError((Object)"The debug-stack and the result-stack have different size");
        }
        Term returnTerm = this.mStackResults.pop();
        Term debugTerm = this.mStackResultsDebug.pop();
        if (this.mCacheConv.get(debugTerm) != returnTerm) {
            throw new AssertionError((Object)("The debugger couldn't associate " + returnTerm.toStringDirect() + " with " + debugTerm.toStringDirect()));
        }
        if (expected != null && debugTerm != expected) {
            throw new AssertionError((Object)"Unexpected Term on proofchecker stack.");
        }
        return returnTerm;
    }

    public Term rewriteTerm(Term termOrig, final Term termDelete, final Term termInsert) {
        return new TermTransformer(){

            private boolean isQuoted(Term t) {
                if (t instanceof AnnotatedTerm) {
                    AnnotatedTerm annot = (AnnotatedTerm)t;
                    for (Annotation a : annot.getAnnotations()) {
                        if (!a.getKey().equals(":quoted")) continue;
                        return true;
                    }
                }
                return false;
            }

            public void convert(Term t) {
                if (t == termDelete) {
                    this.setResult(termInsert);
                } else if (this.isQuoted(t)) {
                    this.setResult(t);
                } else {
                    super.convert(t);
                }
            }
        }.transform(termOrig);
    }

    SMTAffineTerm convertAffineTerm(Term term) {
        return SMTAffineTerm.create(this.mAffineConverter.transform(term));
    }

    ApplicationTerm convertApp(Term term, String debugString) {
        if (this.mDebug.contains("convertApp")) {
            System.out.println("Der untere Aufruf hat die ID: " + debugString);
        }
        return this.convertApp(term);
    }

    ApplicationTerm convertApp(Term term) {
        if (this.mDebug.contains("convertApp")) {
            System.out.println("Aufruf");
        }
        if (!(term instanceof ApplicationTerm)) {
            throw new AssertionError((Object)("Error: The following term should be an ApplicationTerm, but is of the class " + term.getClass().getSimpleName() + ".\n" + "The term was: " + term.toString()));
        }
        return (ApplicationTerm)term;
    }

    ApplicationTerm convertApp_hard(Term term) {
        if (term instanceof AnnotatedTerm) {
            return this.convertApp(((AnnotatedTerm)term).getSubterm(), "annot");
        }
        return this.convertApp(term, "hard");
    }

    AnnotatedTerm convertAnn(Term term) {
        if (!(term instanceof AnnotatedTerm)) {
            throw new AssertionError((Object)("Error: The following term should be an AnnotatedTerm, but is of the class " + term.getClass().getSimpleName() + ".\n" + "The term was: " + term.toString()));
        }
        return (AnnotatedTerm)term;
    }

    ConstantTerm convertConst(Term term) {
        if (!(term instanceof ConstantTerm)) {
            throw new AssertionError((Object)("Error: The following term should be a ConstantTerm, but is of the class " + term.getClass().getSimpleName() + ".\n" + "The term was: " + term.toString()));
        }
        return (ConstantTerm)term;
    }

    Term convertConst_Neg(Term term) {
        if (term instanceof ConstantTerm) {
            return (ConstantTerm)term;
        }
        ApplicationTerm termApp = this.convertApp(term);
        this.pm_func(termApp, "-");
        if (termApp.getParameters()[0] instanceof ConstantTerm) {
            return termApp;
        }
        throw new AssertionError((Object)("Error: The following term should be a ConstantTerm, but is of the class " + term.getClass().getSimpleName() + ".\n" + "The term was: " + term.toString()));
    }

    boolean checkInt_weak(Term term) {
        if (term.getSort() == this.mSkript.sort("Int", new Sort[0])) {
            return true;
        }
        ApplicationTerm termApp = this.convertApp(term);
        this.pm_func(termApp, "-");
        return termApp.getParameters()[0].getSort() == this.mSkript.sort("Int", new Sort[0]);
    }

    void pm_func(ApplicationTerm termApp, String pattern) {
        if (!termApp.getFunction().getName().equals(pattern)) {
            throw new AssertionError((Object)("Error: The pattern \"" + pattern + "\" was supposed to be the function symbol of " + termApp.toStringDirect() + "\n" + "Instead it was " + termApp.getFunction().getName()));
        }
    }

    void pm_func(Term term, String pattern) {
        this.pm_func(this.convertApp(term), pattern);
    }

    boolean pm_func_weak(ApplicationTerm termApp, String pattern) {
        return termApp.getFunction().getName().equals(pattern);
    }

    boolean pm_func_weakest(Term term, String pattern) {
        if (term instanceof ApplicationTerm) {
            return this.pm_func_weak((ApplicationTerm)term, pattern);
        }
        return false;
    }

    boolean pm_func_weak(Term term, String pattern) {
        if (term instanceof ApplicationTerm) {
            return this.pm_func_weak((ApplicationTerm)term, pattern);
        }
        throw new AssertionError((Object)"Expected an ApplicationTerm in func_weak!");
    }

    void pm_annot(AnnotatedTerm termAnn, String pattern) {
        if (termAnn.getAnnotations()[0].getKey() != pattern) {
            throw new AssertionError((Object)("Error: The pattern \"" + pattern + "\" was supposed to be the annotation of " + termAnn.toString() + "\n" + "Instead it was " + termAnn.getAnnotations()[0].toString()));
        }
        if (termAnn.getAnnotations().length != 1) {
            throw new AssertionError((Object)("Error: A term has " + termAnn.getAnnotations().length + " annotations," + ", but was supposed to have just one."));
        }
    }

    void checkNumber(Term[] termArray, int n) {
        if (termArray.length < n) {
            System.out.println("The array: [...");
            for (Term el : termArray) {
                System.out.println(el.toStringDirect());
            }
            System.out.println("...]");
            throw new AssertionError((Object)("Error: The array is to short!\n It should have length " + n));
        }
    }

    void checkNumber(ApplicationTerm termApp, int n) {
        if (termApp.getParameters().length < n) {
            throw new AssertionError((Object)("Error: The parameter-array of " + termApp.toStringDirect() + " is to short!" + "\n It should have length " + n));
        }
    }

    ApplicationTerm uniformizeInEquality(ApplicationTerm termApp) {
        boolean negated = this.pm_func_weak(termApp, "not");
        if (!(this.pm_func_weak(termApp, "<=") || this.pm_func_weak(termApp, "<") || this.pm_func_weak(termApp, ">=") || this.pm_func_weak(termApp, ">") || this.pm_func_weak(termApp, "=") || this.pm_func_weak(termApp, "not"))) {
            throw new AssertionError((Object)"Error 0 in uniformizeInequality");
        }
        ApplicationTerm termIneq = negated ? this.convertApp_hard(termApp.getParameters()[0]) : termApp;
        String relation = termIneq.getFunction().getName();
        this.checkNumber(termIneq, 2);
        SMTAffineTerm termLeft = this.convertAffineTerm(termIneq.getParameters()[0]);
        SMTAffineTerm termRight = this.convertAffineTerm(termIneq.getParameters()[1]);
        SMTAffineTerm termLeftNew = termLeft.add(termRight.negate());
        if (negated) {
            if (relation == "<=") {
                relation = ">";
            } else if (relation == ">=") {
                relation = "<";
            } else if (relation == "<") {
                relation = ">=";
            } else if (relation == ">") {
                relation = "<=";
            } else {
                throw new AssertionError((Object)"Error 1 in uniformizeInequality");
            }
        }
        if (relation == ">=") {
            termLeftNew = termLeftNew.negate();
            relation = "<=";
        } else if (relation == ">") {
            termLeftNew = termLeftNew.negate();
            relation = "<";
        }
        if (this.onlyInts(termLeftNew) && relation == "<") {
            termLeftNew = termLeftNew.add(Rational.ONE);
            relation = "<=";
        }
        Term[] params = new Term[2];
        params[0] = termLeftNew;
        if (!termLeftNew.getSort().isNumericSort()) {
            throw new AssertionError((Object)"Error 2 in uniformizeInequality");
        }
        params[1] = Rational.ZERO.toTerm(termLeftNew.getSort());
        return this.convertApp(this.mSkript.term(relation, params), "unif2");
    }

    boolean onlyInts(Term term) {
        if (term instanceof AnnotatedTerm) {
            return this.onlyInts(((AnnotatedTerm)term).getSubterm());
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm termApp = this.convertApp(term);
            for (Term param : termApp.getParameters()) {
                if (this.onlyInts(param)) continue;
                return false;
            }
            return true;
        }
        if (term instanceof SMTAffineTerm) {
            SMTAffineTerm termAff = (SMTAffineTerm)term;
            return termAff.isIntegral();
        }
        return term.getSort().equals(this.mSkript.sort("Int", new Sort[0]));
    }

    void isConstant(SMTAffineTerm term, Rational constant) {
        if (!this.isConstant_weak(term, constant)) {
            throw new AssertionError((Object)("The following term should be the constant " + constant.toString() + " but isn't: " + term.toStringDirect()));
        }
    }

    boolean isConstant_weak(SMTAffineTerm term, Rational constant) {
        return term.isConstant() && term.getConstant() == constant;
    }

    boolean uniformedSame(ApplicationTerm term1, ApplicationTerm term2) {
        SMTAffineTerm term2leftAff;
        if (term1.equals(term2)) {
            return true;
        }
        SMTAffineTerm term1leftAff = this.convertAffineTerm(term1.getParameters()[0]);
        if (term1leftAff.equals(term2leftAff = this.convertAffineTerm(term1.getParameters()[0]))) {
            return true;
        }
        return term1leftAff.equals(term2leftAff.negate());
    }

    boolean termITEHelper_isEqual(Term termNeg, Term termGoal) {
        if (termNeg == termGoal) {
            return true;
        }
        ApplicationTerm termNegApp = this.convertApp(termNeg);
        this.pm_func(termNegApp, "not");
        this.checkNumber(termNegApp, 1);
        return !this.termITEHelper_isEqual(termNegApp.getParameters()[0], termGoal);
    }

    Term splitNotOrHelper_pushNotInside(Term term) {
        if (!(term instanceof ApplicationTerm)) {
            return term;
        }
        ApplicationTerm termApp = this.convertApp(term);
        if (!this.pm_func_weak(termApp, "not")) {
            Term[] paramsCalc = new Term[termApp.getParameters().length];
            for (int i = 0; i < termApp.getParameters().length; ++i) {
                paramsCalc[i] = this.splitNotOrHelper_pushNotInside(termApp.getParameters()[i]);
            }
            return this.mSkript.term(termApp.getFunction().getName(), paramsCalc);
        }
        this.pm_func(termApp, "not");
        this.checkNumber(termApp, 1);
        if (!(termApp.getParameters()[0] instanceof ApplicationTerm)) {
            return term;
        }
        ApplicationTerm termAppInnerApp = this.convertApp(termApp.getParameters()[0]);
        if (this.pm_func_weak(termAppInnerApp, "not")) {
            return this.splitNotOrHelper_pushNotInside(termAppInnerApp.getParameters()[0]);
        }
        if (this.pm_func_weak(termAppInnerApp, "or")) {
            Term[] paramsCalc = new Term[termAppInnerApp.getParameters().length];
            for (int i = 0; i < paramsCalc.length; ++i) {
                paramsCalc[i] = this.splitNotOrHelper_pushNotInside(this.mSkript.term("not", termAppInnerApp.getParameters()[i]));
            }
            return this.mSkript.term("and", paramsCalc);
        }
        return term;
    }

    ArrayList<Term> splitNotOrHelper_getConjunctsPushed(Term term) {
        ArrayList<Term> termRet = new ArrayList<Term>();
        if (!this.pm_func_weakest(term, "and")) {
            termRet.add(term);
            return termRet;
        }
        ApplicationTerm termApp = this.convertApp(term);
        for (Term param : termApp.getParameters()) {
            termRet.addAll(this.splitNotOrHelper_getConjunctsPushed(param));
        }
        return termRet;
    }

    public Term unquote(Term quotedTerm) {
        AnnotatedTerm annTerm;
        Annotation[] annots;
        if (quotedTerm instanceof AnnotatedTerm && (annots = (annTerm = (AnnotatedTerm)quotedTerm).getAnnotations()).length == 1 && annots[0].getKey() == ":quoted") {
            Term result = annTerm.getSubterm();
            return result;
        }
        this.reportError("Expected quoted literal, but got " + quotedTerm);
        return quotedTerm;
    }

    public boolean isApplication(String funcSym, Term term) {
        ApplicationTerm appTerm;
        FunctionSymbol func;
        return term instanceof ApplicationTerm && (func = (appTerm = (ApplicationTerm)term).getFunction()).isIntern() && func.getName().equals(funcSym);
    }

    private List<Term> collectArguments(String fun, Term term) {
        ArrayDeque<Term> todo = new ArrayDeque<Term>();
        ArrayList<Term> result = new ArrayList<Term>();
        todo.addLast(term);
        while (!todo.isEmpty()) {
            ApplicationTerm appTerm;
            Term t = (Term)todo.removeLast();
            if (t instanceof ApplicationTerm && (appTerm = (ApplicationTerm)t).getFunction().getName() == fun) {
                Term[] args = appTerm.getParameters();
                for (int i = args.length - 1; i >= 0; --i) {
                    todo.addLast(args[i]);
                }
                continue;
            }
            result.add(t);
        }
        return result;
    }

    public boolean checkOrMinus(Term orTerm, Term literal) {
        List<Term> params = this.collectArguments("or", orTerm);
        return params.size() > 1 && params.contains(this.negate(literal));
    }

    class SMTAffineTermTransformer
    extends TermTransformer {
        private final HashSet<String> mFuncSet = new HashSet();

        SMTAffineTermTransformer() {
            this.mFuncSet.add("+");
            this.mFuncSet.add("-");
            this.mFuncSet.add("*");
            this.mFuncSet.add("/");
            this.mFuncSet.add("to_real");
        }

        public void convert(Term t) {
            ApplicationTerm appTerm;
            FunctionSymbol funcSymb;
            if (t instanceof ApplicationTerm && (funcSymb = (appTerm = (ApplicationTerm)t).getFunction()).isIntern() && this.mFuncSet.contains(funcSymb.getName())) {
                super.convert(t);
                return;
            }
            this.setResult(t);
        }

        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            String funcName = appTerm.getFunction().getName();
            assert (this.mFuncSet.contains(funcName));
            if (funcName == "+") {
                SMTAffineTerm sum = SMTAffineTerm.create(newArgs[0]);
                for (int i = 1; i < newArgs.length; ++i) {
                    sum = sum.add(SMTAffineTerm.create(newArgs[i]));
                }
                this.setResult(sum);
            } else if (funcName == "-") {
                SMTAffineTerm sum = SMTAffineTerm.create(newArgs[0]);
                if (newArgs.length == 1) {
                    sum = sum.negate();
                } else {
                    for (int i = 1; i < newArgs.length; ++i) {
                        sum = sum.add(SMTAffineTerm.create(newArgs[i]).negate());
                    }
                }
                this.setResult(sum);
            } else if (funcName == "*") {
                SMTAffineTerm prod = SMTAffineTerm.create(newArgs[0]);
                for (int i = 1; i < newArgs.length; ++i) {
                    SMTAffineTerm other = SMTAffineTerm.create(newArgs[i]);
                    if (prod.isConstant()) {
                        prod = other.mul(prod.getConstant());
                        continue;
                    }
                    if (other.isConstant()) {
                        prod = prod.mul(other.getConstant());
                        continue;
                    }
                    super.convertApplicationTerm(appTerm, newArgs);
                    return;
                }
                this.setResult(prod);
            } else if (funcName == "/") {
                SMTAffineTerm prod = SMTAffineTerm.create(newArgs[0]);
                for (int i = 1; i < newArgs.length; ++i) {
                    SMTAffineTerm other = SMTAffineTerm.create(newArgs[i]);
                    if (!other.isConstant()) {
                        super.convertApplicationTerm(appTerm, newArgs);
                        return;
                    }
                    prod = prod.mul(other.getConstant().inverse());
                }
                this.setResult(prod);
            } else if (funcName == "to_real") {
                SMTAffineTerm t = SMTAffineTerm.create(newArgs[0]);
                this.setResult(t.typecast(appTerm.getSort()));
            } else {
                throw new AssertionError((Object)("Unexpected Function: " + funcName));
            }
        }
    }

    public static class SplitWalker
    implements NonRecursive.Walker {
        final ApplicationTerm mTerm;

        public SplitWalker(ApplicationTerm term) {
            assert (term.getFunction().getName().equals("@split"));
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            ((ProofChecker)engine).walkSplit(this.mTerm);
        }
    }

    public static class ClauseWalker
    implements NonRecursive.Walker {
        final ApplicationTerm mTerm;

        public ClauseWalker(ApplicationTerm term) {
            assert (term.getFunction().getName().equals("@clause"));
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            ((ProofChecker)engine).walkClause(this.mTerm);
        }
    }

    public static class EqualityWalker
    implements NonRecursive.Walker {
        final ApplicationTerm mTerm;

        public EqualityWalker(ApplicationTerm term) {
            assert (term.getFunction().getName().equals("@eq"));
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            ((ProofChecker)engine).walkEquality(this.mTerm);
        }
    }

    public static class ResolutionWalker
    implements NonRecursive.Walker {
        final ApplicationTerm mTerm;

        public ResolutionWalker(ApplicationTerm term) {
            assert (term.getFunction().getName().equals("@res"));
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            ((ProofChecker)engine).walkResolution(this.mTerm);
        }
    }

    public static class ProofWalker
    implements NonRecursive.Walker {
        final ApplicationTerm mTerm;

        public ProofWalker(Term term) {
            assert (term.getSort().getName().equals("@Proof"));
            this.mTerm = (ApplicationTerm)term;
        }

        public void walk(NonRecursive engine) {
            ((ProofChecker)engine).walk(this.mTerm);
        }
    }
}

